/*
 * Decompiled with CFR 0.152.
 */
package net.rocketstrong.waterframescctcompat.blocks.peripherals;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.network.DisplayNetwork;
import me.srrapero720.waterframes.common.network.packets.DisplayControlPacket;
import me.srrapero720.waterframes.common.network.packets.TimePacket;
import me.srrapero720.waterframes.common.network.packets.VolumePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayTilePeripheral
implements IPeripheral {
    private final Set<IComputerAccess> computers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final BlockPos blockPos;
    private final Level level;
    private final DisplayTile Tile;

    public DisplayTilePeripheral(@NotNull BlockPos blockPos, Level level) {
        this.blockPos = blockPos;
        this.level = level;
        this.Tile = (DisplayTile)level.m_7702_(blockPos);
    }

    public String getType() {
        return "MediaDisplay";
    }

    public Set<String> getAdditionalTypes() {
        return super.getAdditionalTypes();
    }

    public void attach(IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    @Nullable
    public Object getTarget() {
        return super.getTarget();
    }

    public boolean equals(@Nullable IPeripheral iPeripheral) {
        return this == iPeripheral;
    }

    @LuaFunction
    public final String getUrl() {
        return this.Tile.data.hasUri() ? this.Tile.data.getUri().toString() : "";
    }

    @LuaFunction
    public final int getTick() {
        return this.Tile.data.tick;
    }

    @LuaFunction
    public final int getMaxTick() {
        return this.Tile.data.tickMax;
    }

    @LuaFunction
    public final float getVolume() {
        return this.Tile.data.volume;
    }

    @LuaFunction
    public final boolean getPaused() {
        return this.Tile.data.paused;
    }

    @LuaFunction
    public final int getTransparency() {
        return this.Tile.data.alpha;
    }

    @LuaFunction(mainThread=true)
    public final void setTick(int tick) {
        DisplayNetwork.sendClient((DisplayControlPacket)new TimePacket(this.Tile.m_58899_(), Math.max(0, Math.min(this.Tile.data.tickMax, tick)), this.Tile.data.tickMax, true), (DisplayTile)this.Tile);
    }

    @LuaFunction(mainThread=true)
    public final void setVolume(int volume) {
        DisplayNetwork.sendClient((DisplayControlPacket)new VolumePacket(this.Tile.m_58899_(), this.Tile.data.volume, true), (DisplayTile)this.Tile);
    }

    @LuaFunction(mainThread=true)
    public final boolean setUrl(String url) {
        URI uri = WaterFrames.createURI((String)url);
        if (uri != null) {
            this.Tile.data.uri = uri;
            this.Tile.setDirty();
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final void play() {
        this.Tile.setPause(false, false);
    }

    @LuaFunction(mainThread=true)
    public final void pause() {
        this.Tile.setPause(false, true);
    }

    @LuaFunction(mainThread=true)
    public final void stop() {
        this.Tile.setStop(false);
    }

    @LuaFunction(mainThread=true)
    public final void loop(boolean enabled) {
        this.Tile.loop(false, enabled);
    }

    @LuaFunction(mainThread=true)
    public final void setTransparency(int alpha) {
        this.Tile.data.alpha = Math.max(0, Math.min(255, alpha));
        this.Tile.setDirty();
    }
}

