/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.screens.widgets;

import java.util.ArrayList;
import java.util.List;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.screens.styles.IconStyles;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.watermedia.api.image.ImageCache;
import org.watermedia.api.player.PlayerAPI;
import team.creative.creativecore.common.gui.controls.simple.GuiIcon;
import team.creative.creativecore.common.gui.style.Icon;

public class WidgetStatusIcon
extends GuiIcon {
    Icon lastIcon;
    private final DisplayTile tile;

    public WidgetStatusIcon(String name, Icon icon, DisplayTile tile) {
        super(name, icon);
        this.tile = tile;
    }

    public void tick() {
        if (!this.isClient()) {
            return;
        }
        this.setTooltip(this.getStatusTooltip());
        this.setIcon(this.getStatusIcon());
        super.tick();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getStatusTooltip() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (!this.tile.data.active) {
            tooltip.add((Component)WidgetStatusIcon.translatable((String)"waterframes.status", (Object[])new Object[]{String.valueOf(ChatFormatting.RED) + WidgetStatusIcon.translate((String)"waterframes.status.off")}));
            tooltip.add((Component)WidgetStatusIcon.translatable((String)"waterframes.status.off.desc"));
            return tooltip;
        }
        if (this.tile.imageCache == null && !this.tile.data.hasUri()) {
            tooltip.add((Component)WidgetStatusIcon.translatable((String)"waterframes.status", (Object[])new Object[]{String.valueOf(ChatFormatting.AQUA) + WidgetStatusIcon.translate((String)"waterframes.status.idle")}));
            tooltip.add((Component)WidgetStatusIcon.translatable((String)"waterframes.status.idle.desc"));
            return tooltip;
        }
        if (this.tile.imageCache == null) {
            tooltip.add((Component)WidgetStatusIcon.translatable((String)"waterframes.status", (Object[])new Object[]{String.valueOf(ChatFormatting.RED) + WidgetStatusIcon.translate((String)"waterframes.status.loading")}));
            return tooltip;
        }
        String status = switch (this.tile.imageCache.getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case ImageCache.Status.READY -> {
                if (this.tile.imageCache.isVideo()) {
                    if (!PlayerAPI.isReady()) {
                        yield String.valueOf(ChatFormatting.RED) + WidgetStatusIcon.translate((String)"waterframes.status.failed.video");
                    }
                    if (this.tile.display != null && this.tile.display.isBuffering()) {
                        yield String.valueOf(ChatFormatting.YELLOW) + WidgetStatusIcon.translate((String)"waterframes.status.buffering");
                    }
                    if (this.tile.display != null && this.tile.display.isBroken()) {
                        yield String.valueOf(ChatFormatting.DARK_RED) + WidgetStatusIcon.translate((String)"waterframes.status.not_working");
                    }
                }
                yield String.valueOf(ChatFormatting.GREEN) + WidgetStatusIcon.translate((String)"waterframes.status.operative");
            }
            case ImageCache.Status.LOADING, ImageCache.Status.WAITING -> String.valueOf(ChatFormatting.YELLOW) + WidgetStatusIcon.translate((String)"waterframes.status.loading");
            case ImageCache.Status.FAILED -> {
                Throwable e = this.tile.imageCache.getException();
                if (e != null) {
                    if (e.getLocalizedMessage() != null && !e.getLocalizedMessage().isEmpty()) {
                        yield String.valueOf(ChatFormatting.DARK_RED) + e.getLocalizedMessage();
                    }
                    if (e.getCause() != null && e.getCause().getLocalizedMessage() != null && !e.getCause().getLocalizedMessage().isEmpty()) {
                        yield String.valueOf(ChatFormatting.DARK_RED) + e.getCause().getLocalizedMessage();
                    }
                    if (e.getCause() != null) {
                        e = e.getCause();
                    }
                    yield String.valueOf(ChatFormatting.DARK_RED) + e.getClass().getSimpleName();
                }
                yield String.valueOf(ChatFormatting.RED) + WidgetStatusIcon.translate((String)"waterframes.download.exception.invalid");
            }
            case ImageCache.Status.FORGOTTEN -> String.valueOf(ChatFormatting.DARK_RED) + WidgetStatusIcon.translate((String)"waterframes.status.not_working");
        };
        tooltip.add((Component)WidgetStatusIcon.translatable((String)"waterframes.status", (Object[])new Object[]{status}));
        if (this.tile.imageCache.isCache()) {
            tooltip.add((Component)WidgetStatusIcon.translatable((String)"waterframes.status.cache").m_130940_(ChatFormatting.AQUA));
        }
        return tooltip;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Icon getStatusIcon() {
        if (!this.tile.data.active) {
            return IconStyles.STATUS_OFF;
        }
        if (this.tile.imageCache == null && !this.tile.data.hasUri()) {
            return IconStyles.STATUS_IDLE;
        }
        if (this.tile.imageCache == null) {
            return IconStyles.STATUS_LOADING;
        }
        return switch (this.tile.imageCache.getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case ImageCache.Status.READY -> {
                if (this.tile.imageCache.isVideo()) {
                    if (!PlayerAPI.isReady()) {
                        yield IconStyles.STATUS_INTERNAL_ERROR_2;
                    }
                    if (this.tile.display != null && this.tile.display.isBuffering()) {
                        yield IconStyles.STATUS_BUFFERING;
                    }
                    if (this.tile.display != null && this.tile.display.isBroken()) {
                        yield IconStyles.STATUS_ERROR;
                    }
                }
                if (this.tile.imageCache.isCache()) {
                    yield IconStyles.STATUS_OK_CACHE;
                }
                yield IconStyles.STATUS_OK;
            }
            case ImageCache.Status.LOADING, ImageCache.Status.WAITING -> IconStyles.STATUS_LOADING;
            case ImageCache.Status.FAILED -> IconStyles.STATUS_ERROR;
            case ImageCache.Status.FORGOTTEN -> this.lastIcon == null ? IconStyles.STATUS_WARN : this.lastIcon;
        };
    }
}

