/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.mpfui.helper.LoremIpsum;
import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.data.agreement.DeliveryAgreement;
import io.github.mortuusars.wares.data.agreement.SealedDeliveryAgreement;
import io.github.mortuusars.wares.data.agreement.component.RequestedItem;
import io.github.mortuusars.wares.data.agreement.component.SealedRequestedItem;
import io.github.mortuusars.wares.data.agreement.component.SteppedInt;
import io.github.mortuusars.wares.data.agreement.component.TextProvider;
import io.github.mortuusars.wares.data.agreement.component.WeightedComponent;
import io.github.mortuusars.wares.test.Tests;
import io.github.mortuusars.wares.test.framework.TestingResult;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class WaresCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"wares").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"give").then(Commands.m_82127_((String)"sealedAgreementExample").executes(WaresCommand::giveExampleSealedAgreement))).then(Commands.m_82127_((String)"agreementExample").executes(WaresCommand::giveExampleAgreement)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").then(Commands.m_82127_((String)"runTests").executes(WaresCommand::runTests))).then(Commands.m_82127_((String)"completeAgreement").executes(WaresCommand::completeAgreement))));
    }

    private static int runTests(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            TestingResult testingResult = new Tests(player).run();
            MutableComponent message = Component.m_237113_((String)"Testing: ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)("Total: " + testingResult.getTotalTestCount() + ".")).m_130940_(ChatFormatting.WHITE));
            if (testingResult.passed().size() > 0) {
                message.m_130946_(" ");
                message.m_7220_((Component)Component.m_237113_((String)("Passed: " + testingResult.passed().size() + ".")).m_130940_(ChatFormatting.GREEN));
            }
            if (testingResult.failed().size() > 0) {
                message.m_130946_(" ");
                message.m_7220_((Component)Component.m_237113_((String)("Failed: " + testingResult.failed().size() + ".")).m_130940_(ChatFormatting.RED));
            }
            if (testingResult.skipped().size() > 0) {
                message.m_130946_(" ");
                message.m_7220_((Component)Component.m_237113_((String)("Skipped: " + testingResult.skipped().size() + ".")).m_130940_(ChatFormatting.GRAY));
            }
            if (testingResult.failed().size() == 0) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> message, false);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)message);
            }
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    private static int giveExampleSealedAgreement(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
        SealedDeliveryAgreement sealedAgreement = new SealedDeliveryAgreement("example_agreement_sealed", TextProvider.of(WeightedComponent.of((Component)Component.m_237113_((String)"Greg the Blacksmith").m_130940_(ChatFormatting.DARK_GRAY)), WeightedComponent.of((Component)Component.m_237113_((String)"Arnold the Butcher").m_130940_(ChatFormatting.DARK_RED))), TextProvider.of((Component)Component.m_237113_((String)"59 Side Road, Vibrant Plains Village")), TextProvider.of((Component)Component.m_237113_((String)"Example Agreement")), TextProvider.of((Component)Component.m_237113_((String)LoremIpsum.words(20))), "default", (Component)Component.m_237113_((String)"Wares Inc."), (Component)Component.m_237113_((String)LoremIpsum.words(45)), (Either<ResourceLocation, List<SealedRequestedItem>>)Either.left((Object)new ResourceLocation("minecraft:chests/village/village_butcher")), (Either<ResourceLocation, List<ItemStack>>)Either.left((Object)new ResourceLocation("minecraft:chests/buried_treasure")), (Either<Integer, SteppedInt>)Either.right((Object)new SteppedInt(12, 64, 8)), (Either<Integer, SteppedInt>)Either.right((Object)new SteppedInt(10, 40, 10)), (Either<Integer, SteppedInt>)Either.left((Object)100), (Either<Integer, SteppedInt>)Either.left((Object)300));
        ItemStack sealedAgreementStack = new ItemStack((ItemLike)Wares.Items.SEALED_DELIVERY_AGREEMENT.get());
        sealedAgreement.toItemStack(sealedAgreementStack);
        if (serverPlayer.m_21205_().m_41619_()) {
            serverPlayer.m_21008_(InteractionHand.MAIN_HAND, sealedAgreementStack);
        } else if (!serverPlayer.m_36356_(sealedAgreementStack)) {
            serverPlayer.m_36176_(sealedAgreementStack, false);
        }
        return 0;
    }

    private static int giveExampleAgreement(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
        DeliveryAgreement agreement = DeliveryAgreement.builder().id("example_agreement").buyerName((Component)Component.m_237113_((String)"Greg the Blacksmith").m_130948_(Style.f_131099_.m_178520_(0x333333))).buyerAddress((Component)Component.m_237113_((String)"12 Side Road, Vibrant Plains Village").m_130940_(ChatFormatting.OBFUSCATED)).title((Component)Component.m_237113_((String)"Example Agreement").m_130948_(Style.f_131099_.m_178520_(9578246))).message((Component)Component.m_237113_((String)LoremIpsum.words(50))).addRequestedItem(new RequestedItem(Items.f_42674_, 4)).addRequestedItem(new RequestedItem(Items.f_42687_, 2)).addRequestedItem(new RequestedItem((TagKey<Item>)ItemTags.f_13149_, 2)).addPaymentItem(new ItemStack((ItemLike)Items.f_42616_, 2)).ordered(5).experience(12).expireTime(serverPlayer.m_9236_().m_46467_() + 18000L).build();
        ItemStack agreementStack = new ItemStack((ItemLike)Wares.Items.DELIVERY_AGREEMENT.get());
        agreement.toItemStack(agreementStack);
        if (serverPlayer.m_21205_().m_41619_()) {
            serverPlayer.m_21008_(InteractionHand.MAIN_HAND, agreementStack);
        } else if (!serverPlayer.m_36356_(agreementStack)) {
            serverPlayer.m_36176_(agreementStack, false);
        }
        return 0;
    }

    private static int completeAgreement(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack mainHandItem = player.m_21205_();
        if (mainHandItem.m_150930_((Item)Wares.Items.COMPLETED_DELIVERY_AGREEMENT.get())) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.wares.agreement.complete.already_completed"));
            return 1;
        }
        if (mainHandItem.m_150930_((Item)Wares.Items.EXPIRED_DELIVERY_AGREEMENT.get())) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.wares.agreement.complete.is_expired"));
            return 1;
        }
        if (!mainHandItem.m_150930_((Item)Wares.Items.DELIVERY_AGREEMENT.get())) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"commands.wares.agreement.complete.wrong_item", (Object[])new Object[]{Wares.Items.DELIVERY_AGREEMENT.get(), mainHandItem.m_41720_()}));
            return 1;
        }
        DeliveryAgreement agreement = DeliveryAgreement.fromItemStack(mainHandItem).orElse(DeliveryAgreement.EMPTY);
        if (agreement == DeliveryAgreement.EMPTY) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.wares.agreement.complete.is_empty"));
            return 1;
        }
        ItemStack completedStack = new ItemStack((ItemLike)Wares.Items.COMPLETED_DELIVERY_AGREEMENT.get());
        agreement.complete();
        agreement.toItemStack(completedStack);
        player.m_21008_(InteractionHand.MAIN_HAND, completedStack);
        return 0;
    }
}

