/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.rawlxxxviii.visual_keybinder.util;

import com.gmail.rawlxxxviii.visual_keybinder.KeybindingPreset;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.loading.FMLPaths;

public class FileUtil {
    private static final String FOLDER_LOCATION = "keybinding presets";
    private static final String PRESET_EXTENSION = ".preset.txt";
    private static final String IS_INITIALIZED_FILE_NAME = "initialized.dat";
    private static final String LOAD_ON_STARTUP_FILE_NAME = "preset_to_load_on_first_startup.txt";
    private static final String LOAD_ON_STARTUP_FILE_CONTENT = "// Fill in the name of the preset on the next line, without '.preset.txt'. It will only be loaded if initialized is not present.";

    public static boolean createInitializedFile() {
        try {
            return new File(String.valueOf(FMLPaths.GAMEDIR.get().resolve(FOLDER_LOCATION + File.separator + IS_INITIALIZED_FILE_NAME))).createNewFile();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isInitializedFileCreated() {
        return new File(String.valueOf(FMLPaths.GAMEDIR.get().resolve(FOLDER_LOCATION + File.separator + IS_INITIALIZED_FILE_NAME))).isFile();
    }

    public static void loadInitialPreset(Options options) {
        try {
            String name;
            List<String> allLines;
            FileUtil.enforceDirectory();
            File file = new File(String.valueOf(FMLPaths.GAMEDIR.get().resolve(FOLDER_LOCATION + File.separator + LOAD_ON_STARTUP_FILE_NAME)));
            if (!file.exists() || !file.isFile()) {
                FileWriter writer = new FileWriter(FMLPaths.GAMEDIR.get().resolve(FOLDER_LOCATION + File.separator + LOAD_ON_STARTUP_FILE_NAME).toString());
                writer.append(LOAD_ON_STARTUP_FILE_CONTENT);
                writer.append("\n");
                writer.close();
            } else if (!FileUtil.isInitializedFileCreated() && (allLines = FileUtil.getAllLines(LOAD_ON_STARTUP_FILE_NAME)).size() > 1 && !(name = allLines.get(1)).isBlank()) {
                FileUtil.loadPreset(options, name);
            }
            FileUtil.createInitializedFile();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Nullable
    public static List<KeybindingPreset> getPresets() {
        try {
            ArrayList<KeybindingPreset> presetList = new ArrayList<KeybindingPreset>();
            for (String name : FileUtil.getFileList()) {
                List<String> allLines = FileUtil.getAllLines(name + PRESET_EXTENSION);
                boolean isReadOnly = !allLines.isEmpty() && allLines.get(0).equals("readonly");
                ArrayList<String> lines = new ArrayList<String>();
                allLines.forEach(x -> {
                    if (x.equals("readonly")) {
                        return;
                    }
                    lines.add((String)x);
                });
                presetList.add(new KeybindingPreset(name, isReadOnly, lines));
            }
            return presetList;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void savePreset(Options options, String name) throws IOException {
        Stream<String> allNames = FileUtil.getFileList().stream().filter(x -> x.equals(name));
        if (allNames.anyMatch(x -> x.equals(name))) {
            boolean isReadOnly;
            List<String> allLines = FileUtil.getAllLines(name + PRESET_EXTENSION);
            boolean bl = isReadOnly = !allLines.isEmpty() && allLines.get(0).equals("readonly");
            if (isReadOnly) {
                return;
            }
        }
        FileWriter writer = new FileWriter(FMLPaths.GAMEDIR.get().resolve(FOLDER_LOCATION + File.separator + name + PRESET_EXTENSION).toString());
        for (KeyMapping keymapping : options.f_92059_) {
            String mappingName = keymapping.m_90860_();
            String key = keymapping.m_90865_() + (String)(keymapping.getKeyModifier() != KeyModifier.NONE ? ":" + keymapping.getKeyModifier() : "");
            writer.append(mappingName).append(":").append(key);
            writer.append("\n");
        }
        writer.close();
    }

    public static String sanitizeString(String input) {
        return input.replaceAll("[^a-zA-Z0-9._]+", "_");
    }

    public static void loadPreset(Options options, String name) throws IOException {
        Stream<String> allNames = FileUtil.getFileList().stream().filter(x -> x.equals(name));
        if (allNames.noneMatch(x -> x.equals(name))) {
            return;
        }
        List<String> allLines = FileUtil.getAllLines(name + PRESET_EXTENSION).stream().filter(x -> !x.equals("readonly") && !x.isBlank()).toList();
        for (KeyMapping keymapping : options.f_92059_) {
            String mappingName = keymapping.m_90860_();
            Optional<String> presetValue = allLines.stream().filter(x -> x.startsWith(mappingName + ":")).findFirst();
            presetValue.ifPresentOrElse(x -> {
                String value = x.substring(mappingName.length() + 1);
                if (value.indexOf(58) != -1) {
                    String[] pts = value.split(":");
                    keymapping.setKeyModifierAndCode(KeyModifier.valueFromString((String)pts[1]), InputConstants.m_84851_((String)pts[0]));
                } else {
                    keymapping.setKeyModifierAndCode(KeyModifier.NONE, InputConstants.m_84851_((String)value));
                }
            }, () -> keymapping.setKeyModifierAndCode(KeyModifier.NONE, InputConstants.f_84822_));
        }
        options.m_92169_();
        KeyMapping.m_90854_();
    }

    public static void deletePreset(String name) throws IOException {
        boolean isReadOnly;
        List<String> allLines = FileUtil.getAllLines(name + PRESET_EXTENSION);
        boolean bl = isReadOnly = !allLines.isEmpty() && allLines.get(0).equals("readonly");
        if (isReadOnly) {
            return;
        }
        Files.delete(FMLPaths.GAMEDIR.get().resolve(FOLDER_LOCATION + File.separator + name + PRESET_EXTENSION));
    }

    public static List<String> getFileList() throws IOException {
        FileUtil.enforceDirectory();
        try (Stream<Path> stream = Files.list(FMLPaths.GAMEDIR.get().resolve(FOLDER_LOCATION));){
            List<String> list = stream.filter(file -> !Files.isDirectory(file, new LinkOption[0])).map(x -> x.getFileName().toString()).filter(file -> file.endsWith(PRESET_EXTENSION)).map(file -> file.substring(0, file.length() - PRESET_EXTENSION.length())).toList();
            return list;
        }
    }

    public static List<String> getAllLines(String fileName) throws IOException {
        return Files.readAllLines(FMLPaths.GAMEDIR.get().resolve(FOLDER_LOCATION + File.separator + fileName));
    }

    private static void enforceDirectory() throws IOException {
        Files.createDirectories(FMLPaths.GAMEDIR.get().resolve(FOLDER_LOCATION), new FileAttribute[0]);
    }
}

