/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.oils;

import com.doctor.vampiricageing.capabilities.CapabilityHelper;
import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.HunterAgeingConfig;
import de.teamlapen.vampirism.api.items.oil.IWeaponOil;
import de.teamlapen.vampirism.items.oil.WeaponOil;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class SeniorityOil
extends WeaponOil {
    public SeniorityOil(int color, int maxDuration) {
        super(color, maxDuration);
    }

    public float onDamage(ItemStack stack, float amount, IWeaponOil oil, LivingEntity target, LivingEntity source) {
        float bonusDamage = 0.0f;
        if (!Helper.isHunter((Entity)source)) {
            return bonusDamage;
        }
        int sourceAge = VampiricAgeingCapabilityManager.getAge(source).map(ageCap -> ageCap.getAge()).orElse(0);
        if (sourceAge < (Integer)HunterAgeingConfig.seniorityOilUseAge.get()) {
            return bonusDamage;
        }
        if (Helper.isVampire((Entity)target) || CapabilityHelper.isWerewolfCheckMod((Entity)target)) {
            int targetAge = VampiricAgeingCapabilityManager.getAge(target).map(ageCap -> ageCap.getAge()).orElse(0);
            bonusDamage = ((Double)((List)HunterAgeingConfig.seniorityOilDamageBonus.get()).get(targetAge)).floatValue();
            return amount * bonusDamage;
        }
        return bonusDamage;
    }

    public void getDescription(ItemStack stack, List<Component> tooltips) {
        super.getDescription(stack, tooltips);
        tooltips.add((Component)Component.m_237110_((String)"text.vampiricageing.useable_by", (Object[])new Object[]{HunterAgeingConfig.seniorityOilUseAge.get()}).m_130940_(ChatFormatting.DARK_RED));
        tooltips.add((Component)Component.m_237115_((String)"text.vampiricageing.seniority_oil.when_applied").m_130940_(ChatFormatting.GRAY));
        tooltips.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"text.vampiricageing.oil.seniority_oil.more_damage").m_130940_(ChatFormatting.DARK_GREEN)));
    }
}

