/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.client.init;

import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.HunterAgeingConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.lib.client.gui.ExtendedGui;
import de.teamlapen.lib.util.OptifineHandler;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientRenderHandler
extends ExtendedGui {
    @Nullable
    private Bat entityBat;
    private final Minecraft mc;
    private int screenPercentage = 0;

    public ClientRenderHandler(@NotNull Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderPlayerPreHigh(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        boolean batMode = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(hunter -> hunter.getBatMode()).orElse(false);
        if (batMode) {
            event.setCanceled(true);
            if (this.entityBat == null) {
                this.entityBat = (Bat)EntityType.f_20549_.m_20615_(event.getEntity().m_20193_());
                this.entityBat.m_27456_(false);
            }
            float partialTicks = event.getPartialTick();
            this.entityBat.f_20884_ = player.f_20884_;
            this.entityBat.f_20883_ = player.f_20883_;
            this.entityBat.f_19797_ = player.f_19797_;
            this.entityBat.m_146926_(player.m_146909_());
            this.entityBat.m_146922_(player.m_146908_());
            this.entityBat.f_20885_ = player.f_20885_;
            this.entityBat.f_19859_ = player.f_19859_;
            this.entityBat.f_19860_ = player.f_19860_;
            this.entityBat.f_20886_ = player.f_20886_;
            this.entityBat.m_6842_(player.m_20145_());
            double d0 = Mth.m_14139_((double)partialTicks, (double)this.entityBat.f_19790_, (double)this.entityBat.m_20185_());
            double d1 = Mth.m_14139_((double)partialTicks, (double)this.entityBat.f_19791_, (double)this.entityBat.m_20186_());
            double d2 = Mth.m_14139_((double)partialTicks, (double)this.entityBat.f_19792_, (double)this.entityBat.m_20189_());
            float f = Mth.m_14179_((float)partialTicks, (float)this.entityBat.f_19859_, (float)this.entityBat.m_146908_());
            this.mc.m_91290_().m_114384_((Entity)this.entityBat, d0, d1, d2, f, partialTicks, event.getPoseStack(), (MultiBufferSource)this.mc.m_91269_().m_110104_(), this.mc.m_91290_().m_114394_((Entity)this.entityBat, partialTicks));
        }
    }

    @SubscribeEvent
    public void onRenderHand(@NotNull RenderHandEvent event) {
        if (this.mc.f_91074_ != null && this.mc.f_91074_.m_6084_() && VampiricAgeingCapabilityManager.getAge((LivingEntity)this.mc.f_91074_).map(hunter -> hunter.getBatMode()).orElse(false).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.f_91074_ == null || !this.mc.f_91074_.m_6084_()) {
            this.screenPercentage = 0;
            return;
        }
        if (event.phase == TickEvent.Phase.END || !((Boolean)HunterAgeingConfig.sunAffectTainted.get()).booleanValue() || !((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue()) {
            return;
        }
        @Nullable IFactionPlayer player = FactionPlayerHandler.getOpt((Player)this.mc.f_91074_).resolve().flatMap(FactionPlayerHandler::getCurrentFactionPlayer).orElse(null);
        if (player instanceof HunterPlayer) {
            this.handleScreenColour((HunterPlayer)player);
        } else {
            this.screenPercentage = 0;
        }
    }

    private void handleScreenColour(HunterPlayer player) {
        VampiricAgeingCapabilityManager.getAge((LivingEntity)player.getRepresentingPlayer()).ifPresent(hunter -> {
            if (hunter.getTicksInSun() / 100 > 0 && !player.getRepresentingPlayer().m_21023_((MobEffect)ModEffects.SUNSCREEN.get())) {
                this.screenPercentage = hunter.getTicksInSun() / 50;
                this.screenPercentage = Math.min(this.screenPercentage, (Integer)VampirismConfig.BALANCE.vpMaxYellowBorderPercentage.get());
            } else {
                this.screenPercentage = 0;
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderWorldLast(RenderGuiEvent.Pre event) {
        int percentages = 0;
        int color = 0;
        if (this.screenPercentage > 0) {
            percentages = this.screenPercentage;
            color = -3038;
        }
        if (percentages > 0 && ((Boolean)VampirismConfig.CLIENT.renderScreenOverlay.get()).booleanValue()) {
            PoseStack stack = event.getGuiGraphics().m_280168_();
            stack.m_85836_();
            int w = this.mc.m_91268_().m_85445_();
            int h = this.mc.m_91268_().m_85446_();
            int bh = Math.round((float)h / 4.0f * (float)percentages / 100.0f);
            int bw = Math.round((float)w / 8.0f * (float)percentages / 100.0f);
            this.fillGradient2(stack, 0, 0, w, bh, color, 0);
            if (!OptifineHandler.isShaders()) {
                this.fillGradient2(stack, 0, h - bh, w, h, 0, color);
            }
            this.fillGradient2(stack, 0, 0, bw, h, 0, color);
            this.fillGradient2(stack, w - bw, 0, w, h, color, 0);
            stack.m_85849_();
        }
    }
}

