/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.capabilities;

import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.WerewolvesAgeingConfig;
import com.doctor.vampiricageing.data.EntityTypeTagProvider;
import de.teamlapen.werewolves.blocks.StoneAltarFireBowlBlock;
import de.teamlapen.werewolves.core.ModDamageTypes;
import de.teamlapen.werewolves.util.Helper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WerewolfAgeingManager {
    public static boolean shouldIncreaseRankDevoured(Player player) {
        return VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(age -> age.getDevoured() >= (Integer)((List)WerewolvesAgeingConfig.devouredForNextAge.get()).get(age.getAge())).orElse(false);
    }

    public static void increasePoints(ServerPlayer player, int points) {
        VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(age -> {
            age.setDevoured(age.getDevoured() + points);
            VampiricAgeingCapabilityManager.syncAgeCap((Player)player);
            if (WerewolfAgeingManager.shouldIncreaseRankDevoured((Player)player)) {
                VampiricAgeingCapabilityManager.increaseAge(player);
            }
        });
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        Entity entity;
        if (((Boolean)WerewolvesAgeingConfig.devourBasedAgeing.get()).booleanValue() && (entity = event.getSource().m_7639_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (Helper.isWerewolf((Entity)event.getSource().m_7639_()) && event.getSource().m_276093_(ModDamageTypes.BITE) && VampiricAgeingCapabilityManager.canAge((LivingEntity)player)) {
                int pointWorth = event.getEntity().m_6095_().m_204039_(EntityTypeTagProvider.pettyDevour) ? (Integer)WerewolvesAgeingConfig.pettyDevourWorth.get() : (event.getEntity().m_6095_().m_204039_(EntityTypeTagProvider.commonDevour) ? (Integer)WerewolvesAgeingConfig.commonDevourWorth.get() : (event.getEntity().m_6095_().m_204039_(EntityTypeTagProvider.greaterDevour) ? (Integer)WerewolvesAgeingConfig.greaterDevourWorth.get() : (event.getEntity().m_6095_().m_204039_(EntityTypeTagProvider.exquisiteDevour) ? (Integer)WerewolvesAgeingConfig.exquisiteDevourWorth.get() : 0)));
                WerewolfAgeingManager.increasePoints(player, pointWorth);
            }
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (Helper.isWerewolf((Player)player) && !player.m_20193_().f_46443_ && player.m_20193_().m_8055_(event.getPos()).m_60734_() instanceof StoneAltarFireBowlBlock && VampiricAgeingCapabilityManager.canAge((LivingEntity)player) && event.getHand() == InteractionHand.MAIN_HAND) {
            int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getEntity()).map(ageCap -> ageCap.getAge()).orElse(0);
            if (((Boolean)WerewolvesAgeingConfig.devourBasedAgeing.get()).booleanValue()) {
                int devourPoints = VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getEntity()).map(ageCap -> ageCap.getDevoured()).orElse(0);
                int devouredForNextAge = (Integer)((List)WerewolvesAgeingConfig.devouredForNextAge.get()).get(age) - devourPoints;
                player.m_213846_((Component)Component.m_237110_((String)"text.vampiricageing.progress_devour", (Object[])new Object[]{devouredForNextAge}).m_130940_(ChatFormatting.DARK_RED));
            }
        }
    }

    @SubscribeEvent
    public void onHurt(LivingHurtEvent event) {
        Player player;
        Entity entity;
        if (event.getSource().m_276093_(ModDamageTypes.BITE) && (entity = event.getSource().m_7639_()) instanceof Player && Helper.isWerewolf((Player)(player = (Player)entity)) && !player.m_20193_().f_46443_) {
            int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
            player.m_5634_(((Double)((List)WerewolvesAgeingConfig.healonBiteAmount.get()).get(age)).floatValue());
            if (((Boolean)WerewolvesAgeingConfig.bitingGivesFood.get()).booleanValue() && age >= (Integer)WerewolvesAgeingConfig.rankForBiteFood.get()) {
                FoodData foodData = player.m_36324_();
                foodData.m_38707_(((Integer)WerewolvesAgeingConfig.biteNutrition.get()).intValue(), ((Double)WerewolvesAgeingConfig.biteSaturation.get()).floatValue());
            }
        }
    }

    @SubscribeEvent
    public void onFootEatenFinish(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (Helper.isWerewolf((Player)((Player)event.getEntity())) && Helper.isRawMeat((ItemStack)event.getItem())) {
                int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
                int multiplier = (Integer)((List)WerewolvesAgeingConfig.nourishmentMultipliers.get()).get(age) - 1;
                for (int i = 1; i <= multiplier; ++i) {
                    player.m_36324_().eat(event.getItem().m_41720_(), event.getItem(), (LivingEntity)player);
                }
            }
        }
    }
}

