/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.capabilities;

import com.doctor.vampiricageing.actions.VampiricAgeingActions;
import com.doctor.vampiricageing.capabilities.AgeingCapability;
import com.doctor.vampiricageing.capabilities.AgeingCapabilityProvider;
import com.doctor.vampiricageing.capabilities.CapabilityHelper;
import com.doctor.vampiricageing.capabilities.IAgeingCapability;
import com.doctor.vampiricageing.config.CommonConfig;
import com.doctor.vampiricageing.config.HunterAgeingConfig;
import com.doctor.vampiricageing.config.WerewolvesAgeingConfig;
import com.doctor.vampiricageing.data.EntityTypeTagProvider;
import com.doctor.vampiricageing.networking.Networking;
import com.doctor.vampiricageing.networking.SyncCapabilityPacket;
import com.doctor.vampiricageing.skills.VampiricAgeingSkills;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.IBiteableEntity;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IDrinkBloodContext;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.event.BloodDrinkEvent;
import de.teamlapen.vampirism.api.event.PlayerFactionEvent;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.core.ModDamageTypes;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.entity.vampire.AdvancedVampireEntity;
import de.teamlapen.vampirism.entity.vampire.DrinkBloodContext;
import de.teamlapen.vampirism.fluids.BloodHelper;
import de.teamlapen.vampirism.items.BloodBottleItem;
import de.teamlapen.vampirism.particle.GenericParticleOptions;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.core.ModAttributes;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="vampiricageing")
public class VampiricAgeingCapabilityManager {
    public static final ResourceLocation AGEING_KEY = new ResourceLocation("vampiricageing", "ageing");
    public static final UUID ATTACK_DAMAGE_UUID = UUID.fromString("060749f1-7868-4fdf-8a54-eb5ddf93742e");
    public static final UUID BITE_DAMAGE_MULTIPLIER_UUID = UUID.fromString("7936e1c2-3439-4819-b0e3-ea57dcc3e8ba");
    public static final UUID MAX_HEALTH_UUID = UUID.fromString("08251d58-2513-4768-b4b5-f2a1a239998e");
    public static final UUID WEREWOLF_MAX_HEALTH_AGE_UUID = UUID.fromString("47461eb3-1376-460d-b542-5d4d17d84b86");
    public static final UUID AGE_ADVANCED_SPEED_INCREASE = UUID.fromString("5728457b-ce7e-4bb5-96de-d1c6809dd1c3");
    public static final UUID EXHAUSTION_UUID = UUID.fromString("1f14dd76-7d9b-47b3-9951-1c221f78d49f");
    public static final UUID STEP_ASSIST_UUID = UUID.fromString("edee6b7f-755a-4dc5-a036-2b8108415c4c");
    public static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.fromString("94d546a9-6848-48cf-bcba-5e162987d58b");
    public static final UUID STRENGTH_INCREASE = UUID.fromString("ee0dca39-3d03-4f75-aed0-c1ae017969f2");
    public static final UUID WEREWOLF_STRENGTH_INCREASE = UUID.fromString("a47672d2-88c8-41de-bafe-8683de11f82a");
    public static final UUID HUNTER_MAX_HEALTH_UUID = UUID.fromString("c668f879-d57a-4182-ba82-87d93610e934");
    public static final UUID HUNTER_SPEED_INCREASE_UUID = UUID.fromString("4277f565-237e-4802-9653-203aa2ef92bb");
    public static final UUID HUNTER_TAINTED_DAMAGE_INCREASE_UUID = UUID.fromString("ea65e383-9172-42ab-a685-53a0c1c4fb3f");
    public static final UUID HUNTER_TAINTED_MAX_HEALTH_INCREASE_UUID = UUID.fromString("128f81c7-27b4-4d0b-a07f-e1a0055ba36a");
    public static final UUID HUNTER_TAINTED_MOVEMENT_SPEED_INCREASE_UUID = UUID.fromString("3c4cdc94-75e8-4528-9800-90298dc44b8a");
    public static final UUID NEONATAL_ATTRIBUTE_AGEING = UUID.fromString("7cb20371-0642-44bd-92ef-5fa5100677c6");
    public static final UUID DBNO_ATTRIBUTE_AGEING = UUID.fromString("47fc2a0c-f517-4920-8f1f-a02539971269");
    public static final Capability<IAgeingCapability> AGEING_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IAgeingCapability>(){});

    public static LazyOptional<IAgeingCapability> getAge(LivingEntity livingEntity) {
        if (livingEntity == null) {
            return LazyOptional.empty();
        }
        return livingEntity.getCapability(AGEING_CAPABILITY);
    }

    public static boolean canAge(LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (entity.m_6084_()) {
                if (Helper.isVampire((Player)player)) {
                    int level = FactionPlayerHandler.getOpt((Player)player).map(fph -> fph.getCurrentLevel(VReference.VAMPIRE_FACTION)).orElse(0);
                    int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
                    return VampiricAgeingCapabilityManager.checkRank((Player)player, level) && age < 5;
                }
                if (CapabilityHelper.isWerewolfCheckMod((Entity)player) && ((Boolean)WerewolvesAgeingConfig.werewolfAgeing.get()).booleanValue()) {
                    int level = FactionPlayerHandler.getOpt((Player)player).map(fph -> fph.getCurrentLevel(WReference.WEREWOLF_FACTION)).orElse(0);
                    int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
                    return VampiricAgeingCapabilityManager.checkRank((Player)player, level) && age < 5;
                }
                if (((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue() && Helper.isHunter((Player)player)) {
                    int level = FactionPlayerHandler.getOpt((Player)player).map(fph -> fph.getCurrentLevel(VReference.HUNTER_FACTION)).orElse(0);
                    int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
                    return VampiricAgeingCapabilityManager.checkRank((Player)player, level) && age < 5;
                }
            }
        }
        return false;
    }

    public static boolean checkRank(Player player, int level) {
        if (((Boolean)CommonConfig.lordLevelRequirement.get()).booleanValue()) {
            int lordLevel = FactionPlayerHandler.getOpt((Player)player).map(FactionPlayerHandler::getLordLevel).orElse(0);
            return lordLevel >= (Integer)CommonConfig.lordLevelRankRequirement.get();
        }
        return level >= (Integer)CommonConfig.levelToBeginAgeMechanic.get();
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        ServerPlayer player;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ServerPlayer && Helper.isVampire((Player)(player = (ServerPlayer)entity)) && VampiricAgeingCapabilityManager.canAge((LivingEntity)player) && ((Boolean)CommonConfig.huntingBasedIncrease.get()).booleanValue()) {
            int pointWorth;
            if (event.getEntity().m_6095_().m_204039_(EntityTypeTagProvider.pettyHuntVampire)) {
                pointWorth = (Integer)CommonConfig.pettyHuntWorth.get();
            } else if (event.getEntity().m_6095_().m_204039_(EntityTypeTagProvider.commonHuntVampire)) {
                pointWorth = (Integer)CommonConfig.commonHuntWorth.get();
            } else if (event.getEntity().m_6095_().m_204039_(EntityTypeTagProvider.greaterHuntVampire)) {
                pointWorth = (Integer)CommonConfig.greaterHuntWorth.get();
            } else {
                return;
            }
            CapabilityHelper.increasePoints(player, pointWorth);
        }
    }

    public static boolean shouldIncreaseRankTicks(Player player) {
        return VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(age -> age.getTime() >= (Integer)((List)CommonConfig.ticksForNextAge.get()).get(age.getAge())).orElse(false);
    }

    public static boolean shouldIncreaseRankInfected(Player player) {
        return VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(age -> age.getInfected() >= (Integer)((List)CommonConfig.infectedForNextAge.get()).get(age.getAge())).orElse(false);
    }

    public static boolean shouldIncreaseRankDrained(Player player) {
        return VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(age -> age.getDrained() >= (Integer)((List)CommonConfig.drainedBloodForNextAge.get()).get(age.getAge())).orElse(false);
    }

    public static void increaseAge(ServerPlayer player) {
        if (VampiricAgeingCapabilityManager.canAge((LivingEntity)player)) {
            VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(age -> {
                if (Helper.isVampire((Player)player)) {
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.ENTITY_VAMPIRE_SCREAM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12496_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                ModParticles.spawnParticlesServer((Level)player.m_9236_(), (ParticleOptions)new GenericParticleOptions(new ResourceLocation("minecraft", "spell_1"), 50, 0x8B0000, 0.2f), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (int)100, (double)1.0, (double)1.0, (double)1.0, (double)0.0);
                age.setAge(age.getAge() + 1);
                if (Helper.isHunter((Player)player) && player.m_21023_((MobEffect)com.doctor.vampiricageing.init.ModEffects.TAINTED_BLOOD_EFFECT.get())) {
                    player.m_21195_((MobEffect)com.doctor.vampiricageing.init.ModEffects.TAINTED_BLOOD_EFFECT.get());
                }
                VampiricAgeingCapabilityManager.syncAgeCap((Player)player);
            });
        }
    }

    public static void onAgeChange(ServerPlayer player, IPlayableFaction<?> faction) {
        int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
        VampiricAgeingCapabilityManager.checkSkills(age, player);
        if (Helper.isVampire((Player)player) || faction == VReference.VAMPIRE_FACTION) {
            VampiricAgeingCapabilityManager.removeModifier(player.m_21051_((Attribute)de.teamlapen.vampirism.core.ModAttributes.BLOOD_EXHAUSTION.get()), EXHAUSTION_UUID);
            VampiricAgeingCapabilityManager.removeModifier(player.m_21051_(Attributes.f_22276_), MAX_HEALTH_UUID);
            VampiricAgeingCapabilityManager.removeModifier(player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()), STEP_ASSIST_UUID);
            VampiricAgeingCapabilityManager.removeModifier(player.m_21051_(Attributes.f_22281_), STRENGTH_INCREASE);
            VampiricAgeingCapabilityManager.removeModifier(player.m_21051_((Attribute)de.teamlapen.vampirism.core.ModAttributes.NEONATAL_DURATION.get()), NEONATAL_ATTRIBUTE_AGEING);
            VampiricAgeingCapabilityManager.removeModifier(player.m_21051_((Attribute)de.teamlapen.vampirism.core.ModAttributes.DBNO_DURATION.get()), DBNO_ATTRIBUTE_AGEING);
            if (age > 0 && age >= (Integer)CommonConfig.stepAssistBonus.get()) {
                player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()).m_22125_(new AttributeModifier(STEP_ASSIST_UUID, "AGE_STEP_ASSIST_CHANGE", 0.5, AttributeModifier.Operation.ADDITION));
            }
            if (((Boolean)CommonConfig.shouldAgeAffectExhaustion.get()).booleanValue()) {
                player.m_21051_((Attribute)de.teamlapen.vampirism.core.ModAttributes.BLOOD_EXHAUSTION.get()).m_22125_(new AttributeModifier(EXHAUSTION_UUID, "AGE_EXHAUSTION_CHANGE", ((Double)((List)CommonConfig.ageExhaustionEffect.get()).get(age)).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            player.m_21051_(Attributes.f_22281_).m_22125_(new AttributeModifier(STRENGTH_INCREASE, "AGE_ATTACK_DAMAGE_INCREASE", ((Double)((List)CommonConfig.ageDamageIncrease.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADDITION));
            player.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier(MAX_HEALTH_UUID, "MAX_HEALTH_AGE_CHANGE", ((Double)((List)CommonConfig.maxHealthIncrease.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADDITION));
            player.m_21051_((Attribute)de.teamlapen.vampirism.core.ModAttributes.DBNO_DURATION.get()).m_22125_(new AttributeModifier(DBNO_ATTRIBUTE_AGEING, "AGE_DBNO_DURATION_CHANGe", (Double)((List)CommonConfig.DBNOTimeMultiplier.get()).get(age) - 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
            player.m_21051_((Attribute)de.teamlapen.vampirism.core.ModAttributes.NEONATAL_DURATION.get()).m_22125_(new AttributeModifier(NEONATAL_ATTRIBUTE_AGEING, "AGE_NEONATAL_DURATION_CHANGe", (Double)((List)CommonConfig.neonatalTimeMultiplier.get()).get(age) - 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (CapabilityHelper.isWerewolfCheckMod((Entity)player, faction)) {
            VampiricAgeingCapabilityManager.removeModifier(player.m_21051_((Attribute)ModAttributes.BITE_DAMAGE.get()), BITE_DAMAGE_MULTIPLIER_UUID);
            VampiricAgeingCapabilityManager.removeModifier(player.m_21051_(Attributes.f_22281_), WEREWOLF_STRENGTH_INCREASE);
            VampiricAgeingCapabilityManager.removeModifier(player.m_21051_(Attributes.f_22276_), WEREWOLF_MAX_HEALTH_AGE_UUID);
            player.m_21051_(Attributes.f_22281_).m_22125_(new AttributeModifier(WEREWOLF_STRENGTH_INCREASE, "WEREWOLF_AGE_ATTACK_DAMAGE_INCREASE", ((Double)((List)WerewolvesAgeingConfig.ageDamageIncrease.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADDITION));
            player.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier(WEREWOLF_MAX_HEALTH_AGE_UUID, "WEREWOLF_MAX_HEALTH_AGE_CHANGE", ((Double)((List)WerewolvesAgeingConfig.maxHealthIncrease.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADDITION));
            player.m_21051_((Attribute)ModAttributes.BITE_DAMAGE.get()).m_22125_(new AttributeModifier(BITE_DAMAGE_MULTIPLIER_UUID, "AGE_BITE_DAMAGE_INCREASE", ((Double)((List)WerewolvesAgeingConfig.biteDamageMultiplier.get()).get(age)).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (Helper.isHunter((Player)player) || faction == VReference.HUNTER_FACTION) {
            VampiricAgeingCapabilityManager.removeModifier(player.m_21051_(Attributes.f_22276_), HUNTER_MAX_HEALTH_UUID);
            VampiricAgeingCapabilityManager.removeModifier(player.m_21051_(Attributes.f_22279_), HUNTER_SPEED_INCREASE_UUID);
            VampiricAgeingCapabilityManager.removeModifier(player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()), STEP_ASSIST_UUID);
            if (age > 0 && age >= (Integer)HunterAgeingConfig.stepAssistAge.get()) {
                player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()).m_22125_(new AttributeModifier(STEP_ASSIST_UUID, "AGE_STEP_ASSIST_CHANGE", 0.5, AttributeModifier.Operation.ADDITION));
            }
            player.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier(HUNTER_MAX_HEALTH_UUID, "HUNTER_AGE_MAX_HEALTH_INCREASE", ((Double)((List)HunterAgeingConfig.maxHealthIncrease.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADDITION));
            player.m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier(HUNTER_SPEED_INCREASE_UUID, "HUNTER_AGE_SPEED_INCREASE", ((Double)((List)HunterAgeingConfig.movementSpeedBonus.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADDITION));
            int cumulativeTaintedBloodAge = CapabilityHelper.getCumulativeTaintedAge((Player)player);
            VampiricAgeingCapabilityManager.removeModifier(player.m_21051_(Attributes.f_22281_), HUNTER_TAINTED_DAMAGE_INCREASE_UUID);
            VampiricAgeingCapabilityManager.removeModifier(player.m_21051_(Attributes.f_22279_), HUNTER_TAINTED_MOVEMENT_SPEED_INCREASE_UUID);
            VampiricAgeingCapabilityManager.removeModifier(player.m_21051_(Attributes.f_22276_), HUNTER_TAINTED_MAX_HEALTH_INCREASE_UUID);
            player.m_21051_(Attributes.f_22281_).m_22125_(new AttributeModifier(HUNTER_TAINTED_DAMAGE_INCREASE_UUID, "HUNTER_TAINTED_DAMAGE_INCREASE", ((Double)((List)HunterAgeingConfig.taintedDamageBonuses.get()).get(cumulativeTaintedBloodAge)).doubleValue(), AttributeModifier.Operation.ADDITION));
            player.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier(HUNTER_TAINTED_MAX_HEALTH_INCREASE_UUID, "HUNTER_TAINTED_MAX_HEALTH_INCREASE", ((Double)((List)HunterAgeingConfig.taintedBloodMaxHealthIncreases.get()).get(cumulativeTaintedBloodAge)).doubleValue(), AttributeModifier.Operation.ADDITION));
            player.m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier(HUNTER_TAINTED_MOVEMENT_SPEED_INCREASE_UUID, "HUNTER_TAINTED_MOVEMENT_SPEED_INCREASE", ((Double)((List)HunterAgeingConfig.taintedBloodMovementSpeedIncreases.get()).get(cumulativeTaintedBloodAge)).doubleValue(), AttributeModifier.Operation.ADDITION));
        }
    }

    public static void checkSkills(int age, ServerPlayer player) {
        boolean unlockedSkills = false;
        if (Helper.isVampire((Player)player)) {
            VampirePlayer.getOpt((Player)player).ifPresent(vamp -> {
                ISkillHandler handler = vamp.getSkillHandler();
                if (age >= (Integer)CommonConfig.drainBloodActionRank.get()) {
                    handler.enableSkill((ISkill)VampiricAgeingSkills.BLOOD_DRAIN_SKILL.get());
                } else {
                    handler.disableSkill((ISkill)VampiricAgeingSkills.BLOOD_DRAIN_SKILL.get());
                }
                if (age >= (Integer)CommonConfig.celerityActionRank.get()) {
                    handler.enableSkill((ISkill)VampiricAgeingSkills.CELERTIY_ACTION.get());
                } else {
                    handler.disableSkill((ISkill)VampiricAgeingSkills.CELERTIY_ACTION.get());
                }
                if (age >= (Integer)CommonConfig.ageWaterWalkingRank.get()) {
                    handler.enableSkill((ISkill)VampiricAgeingSkills.WATER_WALKING_SKILL.get());
                } else {
                    handler.disableSkill((ISkill)VampiricAgeingSkills.WATER_WALKING_SKILL.get());
                }
            });
        } else if (Helper.isHunter((Player)player)) {
            HunterPlayer.getOpt((Player)player).ifPresent(hunter -> {
                ISkillHandler handler = hunter.getSkillHandler();
                if (age >= (Integer)HunterAgeingConfig.taintedBloodBottleAge.get()) {
                    handler.enableSkill((ISkill)VampiricAgeingSkills.TAINTED_BLOOD_SKILL.get());
                } else {
                    handler.disableSkill((ISkill)VampiricAgeingSkills.TAINTED_BLOOD_SKILL.get());
                }
                int cumulativeAge = CapabilityHelper.getCumulativeTaintedAge((Player)player);
                if (cumulativeAge >= (Integer)HunterAgeingConfig.hunterTeleportActionAge.get()) {
                    handler.enableSkill((ISkill)VampiricAgeingSkills.HUNTER_TELEPORT_SKILL.get());
                } else {
                    handler.disableSkill((ISkill)VampiricAgeingSkills.HUNTER_TELEPORT_SKILL.get());
                }
                if (cumulativeAge >= (Integer)HunterAgeingConfig.limitedBatModeAge.get()) {
                    handler.enableSkill((ISkill)VampiricAgeingSkills.LIMITED_BAT_MODE_SKILL.get());
                } else {
                    handler.disableSkill((ISkill)VampiricAgeingSkills.LIMITED_BAT_MODE_SKILL.get());
                }
            });
        }
        VampiricAgeingCapabilityManager.syncAgeCapNoChange((Player)player);
    }

    public static void removeModifier(@NotNull AttributeInstance att, @NotNull UUID uuid) {
        AttributeModifier m = att.m_22111_(uuid);
        if (m != null) {
            att.m_22130_(m);
        }
    }

    public static void incrementInfected(ServerPlayer player) {
        VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(age -> {
            age.setInfected(age.getInfected() + 1);
            VampiricAgeingCapabilityManager.syncAgeCap((Player)player);
            if (VampiricAgeingCapabilityManager.shouldIncreaseRankInfected((Player)player)) {
                VampiricAgeingCapabilityManager.increaseAge(player);
            }
        });
    }

    public static void increaseDrainedBlood(ServerPlayer player, int amount) {
        VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(age -> {
            age.setDrained(age.getDrained() + amount);
            VampiricAgeingCapabilityManager.syncAgeCap((Player)player);
            if (VampiricAgeingCapabilityManager.shouldIncreaseRankDrained((Player)player)) {
                VampiricAgeingCapabilityManager.increaseAge(player);
            }
        });
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        AgeingCapabilityProvider provider = new AgeingCapabilityProvider();
        if (event.getObject() instanceof Player || event.getObject() instanceof AdvancedVampireEntity || event.getObject() instanceof AdvancedVampireEntity.IMob) {
            event.addCapability(AGEING_KEY, (ICapabilityProvider)provider);
        }
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IAgeingCapability.class);
    }

    @SubscribeEvent
    public static void onPotionEffectRemove(MobEffectEvent.Remove event) {
        LivingEntity livingEntity;
        if (((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && event.getEffect() == ModEffects.SANGUINARE.get() && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (!event.getEntity().m_20193_().f_46443_) {
                player.getPersistentData().m_128473_("AGE");
            }
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getOriginal()).ifPresent(oldAge -> {
            IAgeingCapability newAgeCap = (IAgeingCapability)VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getEntity()).orElse((Object)new AgeingCapability());
            CompoundTag ageTag = (CompoundTag)oldAge.serializeNBT();
            newAgeCap.deserializeNBT((Tag)ageTag);
            VampiricAgeingCapabilityManager.syncAgeCap(event.getEntity());
        });
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void onCoffinInteract(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (Helper.isVampire((Player)player) && !player.m_20193_().f_46443_ && player.m_20193_().m_8055_(event.getPos()).m_60734_() instanceof CoffinBlock && VampiricAgeingCapabilityManager.canAge((LivingEntity)player)) {
            int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getEntity()).map(ageCap -> ageCap.getAge()).orElse(0);
            if (((Boolean)CommonConfig.timeBasedIncrease.get()).booleanValue()) {
                int ticksAlive = VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getEntity()).map(ageCap -> ageCap.getTime()).orElse(0);
                int secondsForNextAge = ((Integer)((List)CommonConfig.ticksForNextAge.get()).get(age) - ticksAlive) / 20;
                player.m_213846_((Component)Component.m_237110_((String)"text.vampiricageing.progress_ticks", (Object[])new Object[]{secondsForNextAge}).m_130940_(ChatFormatting.DARK_RED));
            }
            if (((Boolean)CommonConfig.biteBasedIncrease.get()).booleanValue()) {
                int infected = VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getEntity()).map(ageCap -> ageCap.getInfected()).orElse(0);
                int infectedForNextAge = (Integer)((List)CommonConfig.infectedForNextAge.get()).get(age) - infected;
                player.m_213846_((Component)Component.m_237110_((String)"text.vampiricageing.progress_infected", (Object[])new Object[]{infectedForNextAge}).m_130940_(ChatFormatting.DARK_RED));
            }
            if (((Boolean)CommonConfig.drainBasedIncrease.get()).booleanValue()) {
                int drained = VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getEntity()).map(ageCap -> ageCap.getDrained()).orElse(0);
                int drainedForNextAge = (Integer)((List)CommonConfig.drainedBloodForNextAge.get()).get(age) - drained;
                player.m_213846_((Component)Component.m_237110_((String)"text.vampiricageing.progress_drained", (Object[])new Object[]{drainedForNextAge}).m_130940_(ChatFormatting.DARK_RED));
            }
            if (((Boolean)CommonConfig.huntingBasedIncrease.get()).booleanValue()) {
                int hunted = VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getEntity()).map(ageCap -> ageCap.getHunted()).orElse(0);
                int huntedForNextAge = (Integer)((List)CommonConfig.huntedForNextAge.get()).get(age) - hunted;
                player.m_213846_((Component)Component.m_237110_((String)"text.vampiricageing.progress_hunted_vampire", (Object[])new Object[]{huntedForNextAge}).m_130940_(ChatFormatting.DARK_RED));
            }
        }
    }

    @SubscribeEvent
    public static void sireBloodInteract(PlayerInteractEvent event) {
        int age;
        Player player = event.getEntity();
        if (player.m_6144_() && ((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && Helper.isVampire((Player)player) && event.getHand() == InteractionHand.MAIN_HAND && event.getItemStack().m_150930_(Items.f_42590_) && (age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0).intValue()) > 1 && VampirePlayer.getOpt((Player)player).map(vamp -> vamp.getBloodLevel() > 8).orElse(false).booleanValue()) {
            ItemStack mainHandStack = player.m_21205_();
            mainHandStack.m_41774_(1);
            ItemStack stack = ((BloodBottleItem)ModItems.BLOOD_BOTTLE.get()).m_7968_();
            stack.m_41784_().m_128405_("AGE", --age);
            stack.m_41721_(4);
            player.m_36356_(stack);
            VampirePlayer.getOpt((Player)player).ifPresent(vamp -> vamp.removeBlood(0.5f));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDeath(LivingDeathEvent event) {
        Entity entity;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (((Boolean)CommonConfig.deathReset.get()).booleanValue()) {
                VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(age -> {
                    age.setAge(0);
                    VampiricAgeingCapabilityManager.syncAgeCap((Player)player);
                });
            }
        }
        LivingEntity dead = event.getEntity();
        if (!dead.m_20193_().f_46443_ && (entity = event.getSource().m_7639_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && player.m_21206_().m_150930_(Items.f_42590_) && Helper.isVampire((Entity)dead) && (dead instanceof AdvancedVampireEntity || dead instanceof Player)) {
                int age2 = VampiricAgeingCapabilityManager.getAge(event.getEntity()).map(ageCap -> ageCap.getAge()).orElse(0);
                ItemStack offHandStack = player.m_21206_();
                offHandStack.m_41774_(1);
                ItemStack stack = ((BloodBottleItem)ModItems.BLOOD_BOTTLE.get()).m_7968_();
                stack.m_41784_().m_128405_("AGE", age2);
                stack.m_41721_(1);
                player.m_36356_(stack);
            }
        }
        if (dead.getPersistentData().m_128441_("AGE")) {
            dead.getPersistentData().m_128473_("AGE");
        }
    }

    @SubscribeEvent
    public static void tooltipEvent(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_150930_((Item)ModItems.BLOOD_BOTTLE.get()) && ((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && stack.m_41784_().m_128441_("AGE")) {
            int age = stack.m_41784_().m_128451_("AGE");
            event.getToolTip().add(Component.m_237115_((String)"text.vampiricageing.blood_rank").m_130946_(String.valueOf(age)));
        }
    }

    @SubscribeEvent
    public static void useItem(LivingEntityUseItemEvent.Stop event) {
        LivingEntity entity = event.getEntity();
        ItemStack stack = event.getItem();
        if (BloodHelper.getBlood((ItemStack)stack) != 0) {
            return;
        }
        if (((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && stack.m_41784_().m_128441_("AGE") && entity instanceof Player) {
            Player player = (Player)entity;
            if (Helper.isVampire((Entity)entity) && event.getItem().m_150930_((Item)ModItems.BLOOD_BOTTLE.get())) {
                int age = stack.m_41784_().m_128451_("AGE");
                int ageRank = VampiricAgeingCapabilityManager.getAge(entity).map(ageCap -> ageCap.getAge()).orElse(0);
                stack.m_41784_().m_128473_("AGE");
                if (age > 0 && age > ageRank) {
                    VampiricAgeingCapabilityManager.getAge(entity).ifPresent(ageCap -> {
                        ageCap.setAge(age);
                        VampiricAgeingCapabilityManager.syncAgeCap(player);
                    });
                }
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.player.f_19797_ % 100 == 0 && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (((Boolean)CommonConfig.timeBasedIncrease.get()).booleanValue() && event.phase == TickEvent.Phase.END && VampiricAgeingCapabilityManager.canAge((LivingEntity)player2) && Helper.isVampire((Player)player2)) {
                VampiricAgeingCapabilityManager.getAge((LivingEntity)player2).ifPresent(age -> {
                    age.setTime(age.getTime() + 100);
                    VampiricAgeingCapabilityManager.syncAgeCap((Player)player2);
                    if (VampiricAgeingCapabilityManager.shouldIncreaseRankTicks((Player)player2)) {
                        VampiricAgeingCapabilityManager.increaseAge(player2);
                    }
                });
            }
        }
        if (event.player.f_19797_ % 20 == 0 && ((Boolean)CommonConfig.deadlySourcesFastDrainExhaustion.get()).booleanValue()) {
            if (!event.player.m_21023_((MobEffect)ModEffects.GARLIC.get())) {
                return;
            }
            if (!Helper.isVampire((Player)event.player)) {
                return;
            }
            int age2 = VampiricAgeingCapabilityManager.getAge((LivingEntity)event.player).map(ageCap -> ageCap.getAge()).orElse(0);
            VampirePlayer.getOpt((Player)event.player).ifPresent(vamp -> vamp.addExhaustion(((Double)((List)CommonConfig.amountExhaustionDrainFromSources.get()).get(age2)).floatValue()));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            VampiricAgeingCapabilityManager.syncAgeCap(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerDimChangedEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            VampiricAgeingCapabilityManager.syncAgeCap(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void respawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            VampiricAgeingCapabilityManager.syncAgeCap(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerStartTrackingEvent(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof Player && event.getEntity() instanceof ServerPlayer) {
            VampiricAgeingCapabilityManager.syncAgeCap(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onChangeFaction(PlayerFactionEvent.FactionLevelChanged event) {
        if (event.getNewLevel() == 0 || event.getCurrentFaction() != event.getOldFaction() && event.getOldFaction() != null) {
            VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getPlayer().getPlayer()).ifPresent(age -> {
                age.setAge(0);
                VampiricAgeingCapabilityManager.syncAgeCap(event.getPlayer().getPlayer(), event.getOldFaction());
                Player player = event.getPlayer().getPlayer();
                if (event.getOldFaction() == VReference.HUNTER_FACTION) {
                    if (player.m_21023_((MobEffect)com.doctor.vampiricageing.init.ModEffects.TAINTED_BLOOD_EFFECT.get())) {
                        player.m_21195_((MobEffect)com.doctor.vampiricageing.init.ModEffects.TAINTED_BLOOD_EFFECT.get());
                    }
                    age.setTransformed(false);
                }
                VampiricAgeingCapabilityManager.syncAgeCap(player, event.getOldFaction());
            });
        } else if (event.getNewLevel() > 0 && event.getCurrentFaction() == VReference.VAMPIRE_FACTION && ((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && event.getPlayer().getPlayer().getPersistentData().m_128441_("AGE")) {
            int sireAge = event.getPlayer().getPlayer().getPersistentData().m_128451_("AGE");
            VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getPlayer().getPlayer()).ifPresent(age -> {
                age.setAge(sireAge);
                VampiricAgeingCapabilityManager.syncAgeCap(event.getPlayer().getPlayer());
                event.getPlayer().getPlayer().getPersistentData().m_128473_("AGE");
            });
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (Helper.isVampire((Entity)event.getEntity())) {
                int age = VampiricAgeingCapabilityManager.getAge(event.getEntity()).map(ageCap -> ageCap.getAge()).orElse(0);
                if (!Helper.canKillVampires((DamageSource)event.getSource()) && event.getAmount() >= event.getEntity().m_21223_() && ((Boolean)CommonConfig.shouldOnlyDieFromKillingSources.get()).booleanValue() && age >= (Integer)CommonConfig.shouldOnlyDieFromKillingSourcesAgeRank.get()) {
                    if (((Boolean)CommonConfig.immortalBloodLoss.get()).booleanValue() && event.getAmount() >= (float)((Integer)CommonConfig.bloodlossDamageThreshold.get()).intValue()) {
                        int bloodLoss = Math.round(((Double)CommonConfig.bloodlossScaleFactor.get()).floatValue() * Math.min(event.getAmount(), ((Integer)CommonConfig.bloodlossDamageCap.get()).floatValue()));
                        VampirePlayer.getOpt((Player)player).ifPresent(vp -> vp.useBlood(bloodLoss, true));
                    }
                    if (!((Boolean)CommonConfig.immortalBloodLoss.get()).booleanValue() || ((Boolean)CommonConfig.immortalBloodLoss.get()).booleanValue() && !VampirePlayer.getOpt((Player)player).map(vp -> (double)vp.getBloodLevel() < 0.5).orElse(false).booleanValue()) {
                        player.m_21153_(1.0f);
                        event.setCanceled(true);
                    }
                }
                if (event.getSource().m_276093_(ModDamageTypes.SUN_DAMAGE)) {
                    event.setAmount(event.getAmount() / ((Double)((List)CommonConfig.sunDamageReduction.get()).get(age)).floatValue());
                } else if (event.getSource().m_276093_(ModDamageTypes.VAMPIRE_IN_FIRE) || event.getSource().m_276093_(ModDamageTypes.VAMPIRE_ON_FIRE) || event.getSource().m_276093_(ModDamageTypes.HOLY_WATER)) {
                    if (((Boolean)CommonConfig.rageModeWeaknessToggle.get()).booleanValue() && VampirePlayer.getOpt((Player)player).map(vamp -> vamp.getActionHandler().isActionActive((ILastingAction)VampireActions.VAMPIRE_RAGE.get())).orElse(false).booleanValue() && ((Double)((List)CommonConfig.genericVampireWeaknessReduction.get()).get(age)).floatValue() < 1.0f) {
                        return;
                    }
                    if (!event.getSource().m_276093_(ModDamageTypes.HOLY_WATER) && ((Boolean)CommonConfig.deadlySourcesFastDrainExhaustion.get()).booleanValue() && event.getEntity() instanceof Player) {
                        VampirePlayer.getOpt((Player)player).ifPresent(vamp -> vamp.addExhaustion(((Double)((List)CommonConfig.amountExhaustionDrainFromSources.get()).get(age)).floatValue()));
                    }
                    event.setAmount(event.getAmount() / ((Double)((List)CommonConfig.genericVampireWeaknessReduction.get()).get(age)).floatValue());
                } else if (event.getSource().m_276093_(DamageTypes.f_268441_) && ((Boolean)CommonConfig.harsherOutOfBlood.get()).booleanValue() && age > 0) {
                    event.setAmount(event.getAmount() * (float)age);
                } else if (event.getSource().m_7639_() != null && event.getSource().m_7639_().m_6095_().m_204039_(ModTags.Entities.HUNTER) && ((Boolean)CommonConfig.shouldAgeIncreaseHunterMobDamage.get()).booleanValue()) {
                    event.setAmount(event.getAmount() * ((Double)((List)CommonConfig.damageMultiplierFromHunters.get()).get(age)).floatValue());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        Player player;
        LivingEntity target = event.getEntity();
        Entity source = event.getSource().m_7639_();
        if (source instanceof Player && Helper.isVampire((Player)(player = (Player)source))) {
            VampirePlayer.getOpt((Player)player).ifPresent(vamp -> {
                if (vamp.getActionHandler().isActionActive((ILastingAction)VampiricAgeingActions.DRAIN_BLOOD_ACTION.get())) {
                    IVampirePlayer.BITE_TYPE biteType = vamp.determineBiteType(target);
                    int blood = 0;
                    float saturationMod = 1.0f;
                    if (biteType == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_PLAYER) {
                        blood = VampirePlayer.getOpt((Player)((Player)target)).map(v -> v.onBite((IVampire)vamp)).orElse(0);
                        saturationMod = VampirePlayer.getOpt((Player)((Player)target)).map(VampirePlayer::getBloodSaturation).orElse(Float.valueOf(0.0f)).floatValue();
                        vamp.drinkBlood(blood, saturationMod, (IDrinkBloodContext)new DrinkBloodContext(target));
                    } else if (biteType == IVampirePlayer.BITE_TYPE.HUNTER_CREATURE && target instanceof Player) {
                        Player targetPlayer = (Player)target;
                        targetPlayer.m_36324_().m_38703_(1.0f);
                        vamp.drinkBlood(1, 0.1f, (IDrinkBloodContext)new DrinkBloodContext(target));
                    } else if (biteType == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_CREATURE) {
                        LazyOptional opt = ExtendedCreature.getSafe((Entity)target);
                        blood = opt.map(creature -> creature.onBite((IVampire)vamp)).orElse(0);
                        saturationMod = opt.map(IBiteableEntity::getBloodSaturation).orElse(Float.valueOf(0.0f)).floatValue();
                        vamp.drinkBlood(blood, saturationMod, (IDrinkBloodContext)new DrinkBloodContext(target));
                    }
                }
            });
        }
        if (source instanceof AdvancedVampireEntity) {
            ServerPlayer player2;
            AdvancedVampireEntity vamp2 = (AdvancedVampireEntity)source;
            if (((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && target instanceof ServerPlayer && Helper.canBecomeVampire((Player)(player2 = (ServerPlayer)target))) {
                VampiricAgeingCapabilityManager.getAge((LivingEntity)vamp2).ifPresent(vampireAge -> {
                    if (vampireAge.getAge() > 1 && (double)vamp2.m_217043_().m_188501_() > 0.85) {
                        SanguinareEffect.addRandom((LivingEntity)player2, (boolean)true);
                        player2.getPersistentData().m_128473_("AGE");
                        player2.getPersistentData().m_128405_("AGE", vampireAge.getAge() - 1);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void vampireDrinkBlood(BloodDrinkEvent.PlayerDrinkBloodEvent event) {
        if (event.getBloodSource().getEntity().isPresent()) {
            Player player = (Player)event.getVampire().getRepresentingEntity();
            if (((Boolean)CommonConfig.drainBasedIncrease.get()).booleanValue() && !player.m_20193_().f_46443_ && VampiricAgeingCapabilityManager.canAge((LivingEntity)player)) {
                VampiricAgeingCapabilityManager.increaseDrainedBlood((ServerPlayer)player, event.getAmount());
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof AdvancedVampireEntity) {
            AdvancedVampireEntity vamp = (AdvancedVampireEntity)entity;
            if (((Boolean)CommonConfig.advancedVampireAge.get()).booleanValue() && !event.getEntity().m_20193_().f_46443_) {
                VampiricAgeingCapabilityManager.getAge((LivingEntity)vamp).ifPresent(vampireAge -> {
                    if (vampireAge.getAge() != 0) {
                        return;
                    }
                    List percentages = (List)CommonConfig.percentageAdvancedVampireAges.get();
                    double random = vamp.m_217043_().m_188500_();
                    double cumulative = 0.0;
                    for (int i = 0; i < percentages.size(); ++i) {
                        if (!(random <= (cumulative += ((Double)percentages.get(i)).doubleValue()))) continue;
                        vampireAge.setAge(i);
                        break;
                    }
                    float ageMultiplier = Math.min(1.0f, (float)vampireAge.getAge() / 2.0f);
                    VampiricAgeingCapabilityManager.removeModifier(vamp.m_21051_(Attributes.f_22276_), MAX_HEALTH_UUID);
                    VampiricAgeingCapabilityManager.removeModifier(vamp.m_21051_(Attributes.f_22281_), ATTACK_DAMAGE_UUID);
                    VampiricAgeingCapabilityManager.removeModifier(vamp.m_21051_(Attributes.f_22278_), KNOCKBACK_RESISTANCE_UUID);
                    VampiricAgeingCapabilityManager.removeModifier(vamp.m_21051_(Attributes.f_22279_), AGE_ADVANCED_SPEED_INCREASE);
                    vamp.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier(MAX_HEALTH_UUID, "AGE_VAMPIRE_HEALTH_INCREASE", (double)ageMultiplier, AttributeModifier.Operation.MULTIPLY_BASE));
                    vamp.m_21051_(Attributes.f_22281_).m_22125_(new AttributeModifier(ATTACK_DAMAGE_UUID, "AGE_VAMPIRE_DAMAGE_INCREASE", (double)ageMultiplier, AttributeModifier.Operation.MULTIPLY_BASE));
                    vamp.m_21051_(Attributes.f_22278_).m_22125_(new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "AGE_VAMPIRE_KNOCKBACK_RESISTANCE", 0.25 * (double)ageMultiplier, AttributeModifier.Operation.ADDITION));
                    vamp.m_21153_(vamp.m_21233_());
                    if (vampireAge.getAge() > 2) {
                        vamp.m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier(AGE_ADVANCED_SPEED_INCREASE, "AGE_VAMPIRE_SPEED_INCREASE", 0.2 * (double)ageMultiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onFoodEatenFinish(LivingEntityUseItemEvent.Finish event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && Helper.isVampire((Player)(player = (Player)livingEntity))) {
            int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
            if (!event.getItem().m_150930_(Items.f_42437_) || age < (Integer)CommonConfig.goldenAppleNoRegenRank.get()) {
                return;
            }
            if (player.m_21124_(MobEffects.f_19605_) != null && player.m_21124_(MobEffects.f_19605_).m_19557_() == 400) {
                player.m_21195_(MobEffects.f_19605_);
            }
        }
    }

    @SubscribeEvent
    public static void onItemUseStart(LivingEntityUseItemEvent.Start event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && Helper.isVampire((Player)(player = (Player)livingEntity))) {
            int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
            if (event.getItem().m_150930_(Items.f_42437_) && age >= (Integer)CommonConfig.goldenAppleNoEatRank.get()) {
                event.setCanceled(true);
            }
        }
    }

    public static void syncAgeCap(Player player) {
        IAgeingCapability cap = (IAgeingCapability)VampiricAgeingCapabilityManager.getAge((LivingEntity)player).orElse((Object)new AgeingCapability());
        CompoundTag tag = (CompoundTag)cap.serializeNBT();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncCapabilityPacket(tag));
            VampiricAgeingCapabilityManager.onAgeChange(serverPlayer, null);
        }
    }

    public static void syncAgeCap(Player player, IPlayableFaction<?> faction) {
        IAgeingCapability cap = (IAgeingCapability)VampiricAgeingCapabilityManager.getAge((LivingEntity)player).orElse((Object)new AgeingCapability());
        CompoundTag tag = (CompoundTag)cap.serializeNBT();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncCapabilityPacket(tag));
            VampiricAgeingCapabilityManager.onAgeChange(serverPlayer, faction);
        }
    }

    public static void syncAgeCapNoChange(Player player) {
        IAgeingCapability cap = (IAgeingCapability)VampiricAgeingCapabilityManager.getAge((LivingEntity)player).orElse((Object)new AgeingCapability());
        CompoundTag tag = (CompoundTag)cap.serializeNBT();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncCapabilityPacket(tag));
        }
    }
}

