/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.capabilities;

import com.doctor.vampiricageing.actions.LimitedHunterBatModeAction;
import com.doctor.vampiricageing.capabilities.CapabilityHelper;
import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.HunterAgeingConfig;
import com.doctor.vampiricageing.data.EntityTypeTagProvider;
import com.doctor.vampiricageing.mixin.FoodStatsAccessor;
import com.google.common.collect.Multimap;
import de.teamlapen.vampirism.blocks.MedChairBlock;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.world.ModDamageSources;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="vampiricageing")
public class HunterAgeingManager {
    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        ServerPlayer player;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ServerPlayer && Helper.isHunter((Player)(player = (ServerPlayer)entity)) && VampiricAgeingCapabilityManager.canAge((LivingEntity)player)) {
            int pointWorth;
            if (event.getEntity().m_6095_().m_204039_(EntityTypeTagProvider.pettyHunt)) {
                pointWorth = (Integer)HunterAgeingConfig.pettyHuntWorth.get();
            } else if (event.getEntity().m_6095_().m_204039_(EntityTypeTagProvider.commonHunt)) {
                pointWorth = (Integer)HunterAgeingConfig.commonHuntWorth.get();
            } else if (event.getEntity().m_6095_().m_204039_(EntityTypeTagProvider.greaterHunt)) {
                pointWorth = (Integer)HunterAgeingConfig.greaterHuntWorth.get();
            } else {
                return;
            }
            CapabilityHelper.increasePoints(player, pointWorth);
        }
        if (((Boolean)HunterAgeingConfig.permanentTransformationDeathReset.get()).booleanValue() && Helper.isHunter((Entity)event.getEntity()) && event.getEntity() instanceof ServerPlayer) {
            VampiricAgeingCapabilityManager.getAge(event.getEntity()).ifPresent(hunter -> hunter.setTransformed(false));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(LivingEvent.LivingTickEvent event) {
        if (event.getEntity().m_9236_().m_46467_() % 20L != 0L) {
            return;
        }
        if (!(event.getEntity() instanceof Player) || event.getEntity().m_9236_().f_46443_) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!Helper.isHunter((Player)player) || !((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue()) {
            return;
        }
        int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
        if (age >= (Integer)HunterAgeingConfig.fasterRegenerationAge.get()) {
            Difficulty difficulty = player.m_9236_().m_46791_();
            boolean flag = player.m_9236_().m_46469_().m_46207_(GameRules.f_46139_);
            FoodData stats = player.m_36324_();
            if (flag && stats.m_38722_() > 0.0f && player.m_36325_() && stats.m_38702_() >= 20) {
                if (((FoodStatsAccessor)stats).getFoodTimer() >= 9) {
                    float f = Math.min(stats.m_38722_(), 6.0f);
                    player.m_5634_(f / 6.0f);
                    stats.m_38703_(f);
                }
            } else if (flag && stats.m_38702_() >= 18 && player.m_36325_()) {
                if (((FoodStatsAccessor)stats).getFoodTimer() >= 79) {
                    player.m_5634_(1.0f);
                    stats.m_38703_(6.0f);
                }
            } else if (stats.m_38702_() <= 0 && ((FoodStatsAccessor)stats).getFoodTimer() >= 79 && (player.m_21223_() > 10.0f || difficulty == Difficulty.HARD || player.m_21223_() > 1.0f && difficulty == Difficulty.NORMAL)) {
                DamageHandler.hurtVanilla((Entity)player, DamageSources::m_269064_, (float)1.0f);
            }
        }
        if (((Boolean)HunterAgeingConfig.taintedBloodAvailable.get()).booleanValue() && age >= (Integer)HunterAgeingConfig.taintedBloodBottleAge.get()) {
            VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(hunter -> {
                if (hunter.getTemporaryTaintedAgeBonus() > 0 || hunter.isTransformed()) {
                    if (!hunter.isTransformed()) {
                        hunter.setTemporaryTainedTicks(hunter.getTemporaryTainedTicks() - 20);
                        if (hunter.getTemporaryTainedTicks() <= 0) {
                            hunter.setTemporaryTaintedAgeBonus(0);
                        }
                    }
                    int cumulativeAge = CapabilityHelper.getCumulativeTaintedAge(player);
                    if (((Boolean)HunterAgeingConfig.sunAffectTainted.get()).booleanValue() && cumulativeAge >= (Integer)HunterAgeingConfig.taintedSunAffectAge.get()) {
                        int ticksInSun = hunter.getTicksInSun();
                        if (Helper.gettingSundamge((LivingEntity)player, (LevelAccessor)player.m_20193_(), (ProfilerFiller)player.m_20193_().m_46473_()) && ticksInSun <= (Integer)HunterAgeingConfig.maxTicksInSun.get()) {
                            hunter.setTicksInSun(ticksInSun + 20 * (Integer)((List)HunterAgeingConfig.taintedAgeSunBadnessMultiplier.get()).get(cumulativeAge));
                        } else if (hunter.getTicksInSun() >= 100) {
                            int reductionAmount = hunter.getTicksInSun() < 1000 ? 100 : 1000;
                            hunter.setTicksInSun(Math.max(0, ticksInSun - reductionAmount));
                        }
                        HunterAgeingManager.applySunEffects(player, hunter.getTicksInSun());
                    }
                    if (cumulativeAge >= (Integer)HunterAgeingConfig.underwaterBreathingTaintedAge.get()) {
                        player.m_20301_(300);
                    }
                    VampiricAgeingCapabilityManager.syncAgeCap(player);
                }
            });
        }
    }

    public static void applySunEffects(Player player, int ticksInSun) {
        if (player.m_150110_().f_35937_ || player.m_21023_((MobEffect)ModEffects.SUNSCREEN.get())) {
            return;
        }
        if (ticksInSun >= (Integer)HunterAgeingConfig.sunWeaknessTicks.get()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 40, 0));
        }
        if (ticksInSun >= (Integer)HunterAgeingConfig.sunSlownessTicks.get() && ticksInSun < (Integer)HunterAgeingConfig.sunSlownessThreeTicks.get()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 1));
        } else if (ticksInSun >= (Integer)HunterAgeingConfig.sunSlownessThreeTicks.get()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 2));
        }
        if (ticksInSun >= (Integer)HunterAgeingConfig.sunDamageTicks.get()) {
            DamageHandler.hurtModded((Entity)player, ModDamageSources::sunDamage, (float)1.5f);
            if (ticksInSun >= (Integer)HunterAgeingConfig.sunDamageTicks.get() * 2) {
                DamageHandler.hurtModded((Entity)player, ModDamageSources::sunDamage, (float)1.5f);
            }
            if (ticksInSun >= (Integer)HunterAgeingConfig.sunDamageTicks.get() * 3) {
                DamageHandler.hurtModded((Entity)player, ModDamageSources::sunDamage, (float)2.0f);
            }
        }
        if (ticksInSun >= (Integer)HunterAgeingConfig.sunBlindnessTicks.get()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 0));
        }
    }

    @SubscribeEvent
    public static void onInteractBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (event.getHand() == InteractionHand.MAIN_HAND && Helper.isHunter((Player)player) && !player.m_20193_().f_46443_ && player.m_20193_().m_8055_(event.getPos()).m_60734_() instanceof MedChairBlock && VampiricAgeingCapabilityManager.canAge((LivingEntity)player)) {
            int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getEntity()).map(ageCap -> ageCap.getAge()).orElse(0);
            int huntedPoints = VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getEntity()).map(ageCap -> ageCap.getHunted()).orElse(0);
            int huntedForNextAge = (Integer)((List)HunterAgeingConfig.huntedForNextAge.get()).get(age) - huntedPoints;
            player.m_213846_((Component)Component.m_237110_((String)"text.vampiricageing.progress_hunted", (Object[])new Object[]{huntedForNextAge}).m_130940_(ChatFormatting.DARK_RED));
        }
    }

    @SubscribeEvent
    public static void onInteract(PlayerInteractEvent event) {
        Player player = event.getEntity();
        if (event.getItemStack().m_150930_((Item)ModItems.INJECTION_GARLIC.get()) && CapabilityHelper.getCumulativeTaintedAge(player) > 0) {
            VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(hunter -> {
                hunter.setTemporaryTaintedAgeBonus(0);
                hunter.setTemporaryTainedTicks(0);
                hunter.setTransformed(false);
            });
            VampiricAgeingCapabilityManager.syncAgeCap(player);
            event.getItemStack().m_41774_(1);
        }
    }

    @SubscribeEvent
    public static void onDamageByHunter(LivingDamageEvent event) {
        if (event.getSource().m_7639_() == null || event.getEntity().m_20193_().f_46443_) {
            return;
        }
        Entity sourceEntity = event.getSource().m_7639_();
        if (!(Helper.isHunter((Entity)sourceEntity) && ((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue() && sourceEntity instanceof Player)) {
            return;
        }
        Item item = ((Player)sourceEntity).m_21205_().m_41720_();
        Multimap attributes = item.getAttributeModifiers(EquipmentSlot.MAINHAND, ((Player)sourceEntity).m_21205_());
        if (!attributes.get((Object)Attributes.f_22281_).isEmpty() && (Helper.isVampire((Entity)event.getEntity()) || CapabilityHelper.isWerewolfCheckMod((Entity)event.getEntity()))) {
            Player hunterSource = (Player)sourceEntity;
            int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)hunterSource).map(ageCap -> ageCap.getAge()).orElse(0);
            event.setAmount(event.getAmount() + ((Double)((List)HunterAgeingConfig.ageEnemyFactionDamageIncrease.get()).get(age)).floatValue());
        }
    }

    @SubscribeEvent
    public static void onDamageHunter(LivingDamageEvent event) {
        if (!Helper.isHunter((Entity)event.getEntity()) || !((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (CapabilityHelper.getCumulativeTaintedAge(player) > 0 && !player.m_20193_().f_46443_) {
            int cumulativeAge = CapabilityHelper.getCumulativeTaintedAge(player);
            if (event.getSource().m_276093_(DamageTypes.f_268468_) || event.getSource().m_276093_(DamageTypes.f_268631_)) {
                event.setAmount(event.getAmount() * ((Double)((List)HunterAgeingConfig.taintedFireDamageMultiplier.get()).get(cumulativeAge)).floatValue());
            }
        }
    }

    @SubscribeEvent
    public static void onXpGain(PlayerXpEvent.XpChange event) {
        Player player = event.getEntity();
        if (!Helper.isHunter((Player)player) || !((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue()) {
            return;
        }
        int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
        event.setAmount(Math.round((float)event.getAmount() / ((Double)((List)HunterAgeingConfig.xpGainReduction.get()).get(age)).floatValue()));
    }

    @SubscribeEvent
    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (!((Boolean)HunterAgeingConfig.hunterIncreasedMiningSpeed.get()).booleanValue() || !((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue()) {
            return;
        }
        if (!Helper.isHunter((Player)event.getEntity())) {
            return;
        }
        if (HunterAgeingManager.isBat(event.getEntity())) {
            event.setCanceled(true);
        }
        int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getEntity()).map(ageCap -> ageCap.getAge()).orElse(0);
        event.setNewSpeed(event.getOriginalSpeed() * ((Double)((List)HunterAgeingConfig.hunterMiningSpeedBonus.get()).get(age)).floatValue());
    }

    @SubscribeEvent
    public static void eyeHeight(EntityEvent.Size event) {
        Player player;
        if (event.getEntity() instanceof Player && ((Player)event.getEntity()).m_150109_() != null && event.getEntity().m_6084_() && event.getEntity().m_20182_().m_82556_() != 0.0 && event.getEntity().m_20202_() == null && VampiricAgeingCapabilityManager.getAge((LivingEntity)(player = (Player)event.getEntity())).map(hunter -> hunter.getBatMode()).orElse(false).booleanValue()) {
            event.setNewSize(LimitedHunterBatModeAction.BAT_SIZE);
            event.setNewEyeHeight(0.51000005f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player.m_6084_() && HunterAgeingManager.isBat(player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTryMount(EntityMountEvent event) {
        if (event.getEntity() instanceof Player && HunterAgeingManager.isBat((Player)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockRightClicked(PlayerInteractEvent.RightClickBlock event) {
        if (HunterAgeingManager.isBat(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onItemUse(LivingEntityUseItemEvent.Start event) {
        Player player;
        if (event.getEntity() instanceof Player && HunterAgeingManager.isBat(player = (Player)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        if ((event.getItemStack().m_41720_() instanceof ThrowablePotionItem || event.getItemStack().m_41720_() instanceof CrossbowItem) && HunterAgeingManager.isBat(event.getEntity())) {
            event.setCancellationResult(InteractionResult.m_19078_((boolean)event.getLevel().m_5776_()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (!(event.getEntity() instanceof Player) || !event.getEntity().m_6084_()) {
            return;
        }
        if (event.getPlacedBlock().m_60795_()) {
            return;
        }
        try {
            if (HunterAgeingManager.isBat((Player)event.getEntity())) {
                MinecraftServer server;
                BlockEntity t;
                event.setCanceled(true);
                if (event.getPlacedBlock().m_155947_() && (t = event.getLevel().m_7702_(event.getPos())) instanceof Container) {
                    ((Container)t).m_6211_();
                }
                if (event.getEntity() instanceof ServerPlayer && (server = event.getEntity().m_9236_().m_7654_()) != null) {
                    server.m_6846_().m_11292_((ServerPlayer)event.getEntity());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isBat(Player player) {
        return VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(age -> age.getBatMode()).orElse(false);
    }
}

