/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.actions;

import com.doctor.vampiricageing.capabilities.CapabilityHelper;
import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.HunterAgeingConfig;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.hunter.DefaultHunterAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.entity.AreaParticleCloudEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class HunterTeleportAction
extends DefaultHunterAction {
    public boolean activate(@NotNull IHunterPlayer hunter, IAction.ActivationContext context) {
        Player player = hunter.getRepresentingPlayer();
        int dist = (Integer)HunterAgeingConfig.hunterTeleportActionMaxDistance.get();
        HitResult target = UtilLib.getPlayerLookingSpot((Player)player, (double)dist);
        double ox = player.m_20185_();
        double oy = player.m_20186_();
        double oz = player.m_20189_();
        if (target.m_6662_() == HitResult.Type.MISS) {
            player.m_5496_((SoundEvent)SoundEvents.f_12209_.get(), 1.0f, 1.0f);
            return false;
        }
        BlockPos pos = null;
        if (target.m_6662_() == HitResult.Type.BLOCK) {
            if (player.m_20193_().m_8055_(((BlockHitResult)target).m_82425_()).m_280555_()) {
                pos = ((BlockHitResult)target).m_82425_().m_7494_();
            }
        } else if (player.m_20193_().m_8055_(((EntityHitResult)target).m_82443_().m_20183_()).m_280555_()) {
            pos = ((EntityHitResult)target).m_82443_().m_20183_();
        }
        if (pos != null) {
            player.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5);
            if (player.m_20193_().m_46855_(player.m_20191_()) || !player.m_20193_().m_45784_((Entity)player)) {
                pos = null;
            }
        }
        if (pos == null) {
            player.m_6034_(ox, oy, oz);
            player.m_5496_((SoundEvent)SoundEvents.f_12208_.get(), 1.0f, 1.0f);
            return false;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer playerMp = (ServerPlayer)player;
            playerMp.m_9231_();
            playerMp.m_6021_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5);
        }
        AreaParticleCloudEntity particleCloud = new AreaParticleCloudEntity((EntityType)ModEntities.PARTICLE_CLOUD.get(), player.m_20193_());
        particleCloud.m_6034_(ox, oy, oz);
        particleCloud.setRadius(0.7f);
        particleCloud.setHeight(player.m_20206_());
        particleCloud.setDuration(5);
        particleCloud.setSpawnRate(15.0f);
        player.m_20193_().m_7967_((Entity)particleCloud);
        player.m_20193_().m_7785_(ox, oy, oz, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f, false);
        player.m_20193_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f, false);
        return true;
    }

    public boolean canBeUsedBy(@NotNull IHunterPlayer hunter) {
        boolean isBat = VampiricAgeingCapabilityManager.getAge(hunter.getRepresentingEntity()).map(h -> h.getBatMode()).orElse(false);
        return CapabilityHelper.getCumulativeTaintedAge(hunter.getRepresentingPlayer()) >= (Integer)HunterAgeingConfig.hunterTeleportActionAge.get() && !isBat;
    }

    public int getCooldown(@NotNull IHunterPlayer player) {
        return (Integer)HunterAgeingConfig.hunterTeleportActionCooldown.get() * 20;
    }

    public boolean isEnabled() {
        return (Boolean)HunterAgeingConfig.hunterTeleportAction.get();
    }
}

