/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.util;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.xplat.PeripheraliumPlatform;
import site.siredvin.turtlematic.TurtlematicCore;
import site.siredvin.turtlematic.common.configuration.TurtlematicConfig;
import site.siredvin.turtlematic.util.UtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fJ\"\u0010\u0018\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u000e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lsite/siredvin/turtlematic/util/ChunkManager;", "Lnet/minecraft/world/level/saveddata/SavedData;", "()V", "forcedChunks", "", "Ljava/util/UUID;", "Lsite/siredvin/turtlematic/util/ChunkManager$LoadChunkRecord;", "initialized", "", "mainThread", "Ljava/lang/Thread;", "tickCounter", "", "addForceChunk", "level", "Lnet/minecraft/server/level/ServerLevel;", "owner", "pos", "Lnet/minecraft/world/level/ChunkPos;", "init", "", "server", "Lnet/minecraft/server/MinecraftServer;", "removeChunk", "removeForceChunk", "loadedChunk", "save", "Lnet/minecraft/nbt/CompoundTag;", "compoundTag", "stop", "tick", "touch", "Companion", "LoadChunkRecord", "turtlematic-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nChunkManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkManager.kt\nsite/siredvin/turtlematic/util/ChunkManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1855#2:200\n1856#2:203\n1855#2:204\n1855#2,2:205\n1856#2:207\n1855#2:208\n1603#2,9:209\n1855#2:218\n1856#2:220\n1612#2:221\n1855#2,2:222\n1856#2:224\n215#3,2:201\n215#3,2:225\n1#4:219\n*S KotlinDebug\n*F\n+ 1 ChunkManager.kt\nsite/siredvin/turtlematic/util/ChunkManager\n*L\n112#1:200\n112#1:203\n127#1:204\n129#1:205,2\n127#1:207\n144#1:208\n146#1:209,9\n146#1:218\n146#1:220\n146#1:221\n152#1:222,2\n144#1:224\n114#1:201,2\n162#1:225,2\n146#1:219\n*E\n"})
public final class ChunkManager
extends SavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long tickCounter;
    @NotNull
    private final Map<UUID, LoadChunkRecord> forcedChunks = new LinkedHashMap();
    private boolean initialized;
    @Nullable
    private Thread mainThread;
    @NotNull
    private static final String DIMENSION_NAME_TAG = "dimensionName";
    @NotNull
    private static final String POS_TAG = "pos";
    @NotNull
    private static final String DATA_NAME = "turtlematic_ForcedChunks";
    @NotNull
    private static final String FORCED_CHUNKS_TAG = "forcedChunks";

    public final synchronized boolean addForceChunk(@NotNull ServerLevel level, @NotNull UUID owner, @NotNull ChunkPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)pos, (String)POS_TAG);
        if (this.forcedChunks.containsKey(owner)) {
            TurtlematicCore.INSTANCE.getLOGGER().debug("Chunk re-added to force loaded {} with touch", (Object)pos);
            LoadChunkRecord loadChunkRecord = this.forcedChunks.get(owner);
            if (loadChunkRecord != null) {
                loadChunkRecord.touch();
            }
            return true;
        }
        TurtlematicCore.INSTANCE.getLOGGER().debug("Chunk added to force loaded {}", (Object)pos);
        Map<UUID, LoadChunkRecord> map = this.forcedChunks;
        String string = level.m_46472_().m_135782_().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"level.dimension().location().toString()");
        LoadChunkRecord loadChunkRecord = new LoadChunkRecord(string, pos, 0L, 4, null);
        map.put(owner, loadChunkRecord);
        this.m_77762_();
        return PeripheraliumPlatform.Companion.setChunkForceLoad$default((PeripheraliumPlatform.Companion)PeripheraliumPlatform.Companion, (ServerLevel)level, (String)"turtlematic", (UUID)owner, (ChunkPos)pos, (boolean)true, (boolean)false, (int)32, null);
    }

    public final synchronized void touch(@NotNull UUID owner) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            LoadChunkRecord loadChunkRecord = this.forcedChunks.get(owner);
            if (loadChunkRecord == null) break block0;
            loadChunkRecord.touch();
        }
    }

    public final synchronized boolean removeChunk(@NotNull UUID owner, @NotNull ChunkPos pos, @NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)pos, (String)POS_TAG);
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (this.mainThread != null && Intrinsics.areEqual((Object)Thread.currentThread(), (Object)this.mainThread)) {
            TurtlematicCore.INSTANCE.getLOGGER().debug("Chunk removed from to force loaded {}", (Object)pos);
            return PeripheraliumPlatform.Companion.setChunkForceLoad$default((PeripheraliumPlatform.Companion)PeripheraliumPlatform.Companion, (ServerLevel)level, (String)"turtlematic", (UUID)owner, (ChunkPos)pos, (boolean)false, (boolean)false, (int)32, null);
        }
        TurtlematicCore.INSTANCE.getLOGGER().debug("Market chunk to remove {}", (Object)pos);
        LoadChunkRecord loadChunkRecord = this.forcedChunks.get(owner);
        if (loadChunkRecord == null) {
            return false;
        }
        LoadChunkRecord forcedChunk = loadChunkRecord;
        forcedChunk.invalidate();
        return false;
    }

    public final synchronized boolean removeForceChunk(@NotNull ServerLevel level, @NotNull UUID owner, @Nullable ChunkPos loadedChunk) {
        boolean result2;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (!this.forcedChunks.containsKey(owner)) {
            return true;
        }
        LoadChunkRecord loadChunkRecord = this.forcedChunks.get(owner);
        if (loadChunkRecord == null) {
            return true;
        }
        LoadChunkRecord chunkRecord = loadChunkRecord;
        String string = level.m_46472_().m_135782_().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"level.dimension().location().toString()");
        String dimensionName = string;
        if (!Intrinsics.areEqual((Object)chunkRecord.getDimensionName(), (Object)dimensionName)) {
            boolean bl = false;
            Object[] objectArray = new Object[]{chunkRecord.getDimensionName(), dimensionName};
            String string2 = String.format("Incorrect dimension! Should be %s instead of %s", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(\n                \u2026ensionName,\n            )");
            String string3 = string2;
            throw new IllegalArgumentException(string3.toString());
        }
        boolean bl = result2 = loadedChunk == null ? this.removeChunk(owner, chunkRecord.getPos(), level) : this.removeChunk(owner, loadedChunk, level);
        if (result2) {
            this.forcedChunks.remove(owner);
            this.m_77762_();
        }
        return result2;
    }

    public static /* synthetic */ boolean removeForceChunk$default(ChunkManager chunkManager, ServerLevel serverLevel, UUID uUID, ChunkPos chunkPos, int n, Object object) {
        if ((n & 4) != 0) {
            chunkPos = null;
        }
        return chunkManager.removeForceChunk(serverLevel, uUID, chunkPos);
    }

    public final synchronized void init(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (!this.initialized) {
            this.mainThread = server.m_6304_();
            Iterable iterable = server.m_129785_();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"server.allLevels");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerLevel level = (ServerLevel)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)level.m_46472_().m_135782_().toString(), (String)"level.dimension().location().toString()");
                Map<UUID, LoadChunkRecord> $this$forEach$iv2 = this.forcedChunks;
                boolean $i$f$forEach2 = false;
                Iterator<Map.Entry<UUID, LoadChunkRecord>> iterator = $this$forEach$iv2.entrySet().iterator();
                while (iterator.hasNext()) {
                    String dimensionName;
                    Map.Entry<UUID, LoadChunkRecord> element$iv2;
                    Map.Entry<UUID, LoadChunkRecord> it = element$iv2 = iterator.next();
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getValue().getDimensionName(), (Object)dimensionName)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level");
                    PeripheraliumPlatform.Companion.setChunkForceLoad$default((PeripheraliumPlatform.Companion)PeripheraliumPlatform.Companion, (ServerLevel)level, (String)"turtlematic", (UUID)it.getKey(), (ChunkPos)it.getValue().getPos(), (boolean)true, (boolean)false, (int)32, null);
                }
            }
            this.initialized = true;
        }
    }

    public final synchronized void stop(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (this.initialized) {
            Iterable iterable = server.m_129785_();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"server.allLevels");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerLevel level = (ServerLevel)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)level.m_46472_().m_135782_().toString(), (String)"level.dimension().location().toString()");
                Iterable $this$forEach$iv2 = this.forcedChunks.entrySet();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String dimensionName;
                    Map.Entry it = (Map.Entry)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)((LoadChunkRecord)it.getValue()).getDimensionName(), (Object)dimensionName)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level");
                    PeripheraliumPlatform.Companion.setChunkForceLoad$default((PeripheraliumPlatform.Companion)PeripheraliumPlatform.Companion, (ServerLevel)level, (String)"turtlematic", (UUID)((UUID)it.getKey()), (ChunkPos)((LoadChunkRecord)it.getValue()).getPos(), (boolean)false, (boolean)false, (int)32, null);
                }
            }
            this.initialized = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void tick(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        long l = this.tickCounter;
        this.tickCounter = l + 1L;
        if (this.tickCounter % (long)20 == 0L) {
            Iterable iterable = server.m_129785_();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"server.allLevels");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapNotNullTo$iv$iv;
                ServerLevel level = (ServerLevel)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)level.m_46472_().m_135782_().toString(), (String)"level.dimension().location().toString()");
                Iterable $this$mapNotNull$iv = this.forcedChunks.entrySet();
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    UUID it$iv$iv;
                    String dimensionName;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    Map.Entry it = (Map.Entry)element$iv$iv;
                    boolean bl3 = false;
                    if ((Intrinsics.areEqual((Object)((LoadChunkRecord)it.getValue()).getDimensionName(), (Object)dimensionName) && !((LoadChunkRecord)it.getValue()).getValid() ? (UUID)it.getKey() : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List purgeList = (List)destination$iv$iv;
                Iterable $this$forEach$iv2 = purgeList;
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    UUID it = (UUID)element$iv2;
                    boolean bl5 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level");
                    ChunkManager.removeForceChunk$default(this, level, it, null, 4, null);
                }
            }
        }
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        TurtlematicCore.INSTANCE.getLOGGER().info("Saving all forces chunks " + this.forcedChunks.entrySet().size());
        CompoundTag forcedChunksTag = new CompoundTag();
        Map<UUID, LoadChunkRecord> $this$forEach$iv = this.forcedChunks;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, LoadChunkRecord>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, LoadChunkRecord> element$iv;
            Map.Entry<UUID, LoadChunkRecord> entry = element$iv = iterator.next();
            boolean bl = false;
            UUID key = entry.getKey();
            LoadChunkRecord value = entry.getValue();
            forcedChunksTag.m_128365_(key.toString(), (Tag)value.serialize());
        }
        compoundTag.m_128365_(FORCED_CHUNKS_TAG, (Tag)forcedChunksTag);
        return compoundTag;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lsite/siredvin/turtlematic/util/ChunkManager$Companion;", "", "()V", "DATA_NAME", "", "DIMENSION_NAME_TAG", "FORCED_CHUNKS_TAG", "POS_TAG", "get", "Lsite/siredvin/turtlematic/util/ChunkManager;", "level", "Lnet/minecraft/server/level/ServerLevel;", "load", "data", "Lnet/minecraft/nbt/CompoundTag;", "readChunkRecord", "Lsite/siredvin/turtlematic/util/ChunkManager$LoadChunkRecord;", "tag", "turtlematic-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        private final LoadChunkRecord readChunkRecord(CompoundTag tag) {
            String string = tag.m_128461_(ChunkManager.DIMENSION_NAME_TAG);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tag.getString(DIMENSION_NAME_TAG)");
            CompoundTag compoundTag = tag.m_128469_(ChunkManager.POS_TAG);
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"tag.getCompound(POS_TAG)");
            return new LoadChunkRecord(string, UtilsKt.chunkPosFromNBT(compoundTag), 0L, 4, null);
        }

        @NotNull
        public final ChunkManager load(@NotNull CompoundTag data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            ChunkManager manager = new ChunkManager();
            CompoundTag forcedData = data.m_128469_(ChunkManager.FORCED_CHUNKS_TAG);
            for (String key : forcedData.m_128431_()) {
                UUID uUID;
                Map map = manager.forcedChunks;
                Intrinsics.checkNotNullExpressionValue((Object)UUID.fromString(key), (String)"fromString(key)");
                CompoundTag compoundTag = forcedData.m_128469_(key);
                Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"forcedData.getCompound(key)");
                LoadChunkRecord loadChunkRecord = this.readChunkRecord(compoundTag);
                map.put(uUID, loadChunkRecord);
            }
            TurtlematicCore.INSTANCE.getLOGGER().info("Loaded " + manager.forcedChunks.size() + " forced chunks");
            return manager;
        }

        @NotNull
        public final ChunkManager get(@NotNull ServerLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            SavedData savedData = level.m_8895_().m_164861_(Companion::load, Companion::get$lambda$0, ChunkManager.DATA_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)savedData, (String)"level.dataStorage.comput\u2026nkManager() }, DATA_NAME)");
            return (ChunkManager)savedData;
        }

        private static final ChunkManager get$lambda$0() {
            return new ChunkManager();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\"\u001a\u00020\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lsite/siredvin/turtlematic/util/ChunkManager$LoadChunkRecord;", "", "dimensionName", "", "pos", "Lnet/minecraft/world/level/ChunkPos;", "lastTouch", "", "(Ljava/lang/String;Lnet/minecraft/world/level/ChunkPos;J)V", "getDimensionName", "()Ljava/lang/String;", "getLastTouch", "()J", "setLastTouch", "(J)V", "getPos", "()Lnet/minecraft/world/level/ChunkPos;", "valid", "", "getValid", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "invalidate", "", "serialize", "Lnet/minecraft/nbt/CompoundTag;", "toString", "touch", "turtlematic-forge-1.20.1"})
    public static final class LoadChunkRecord {
        @NotNull
        private final String dimensionName;
        @NotNull
        private final ChunkPos pos;
        private long lastTouch;

        public LoadChunkRecord(@NotNull String dimensionName, @NotNull ChunkPos pos, long lastTouch) {
            Intrinsics.checkNotNullParameter((Object)dimensionName, (String)ChunkManager.DIMENSION_NAME_TAG);
            Intrinsics.checkNotNullParameter((Object)pos, (String)ChunkManager.POS_TAG);
            this.dimensionName = dimensionName;
            this.pos = pos;
            this.lastTouch = lastTouch;
        }

        public /* synthetic */ LoadChunkRecord(String string, ChunkPos chunkPos, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                l = Instant.now().getEpochSecond();
            }
            this(string, chunkPos, l);
        }

        @NotNull
        public final String getDimensionName() {
            return this.dimensionName;
        }

        @NotNull
        public final ChunkPos getPos() {
            return this.pos;
        }

        public final long getLastTouch() {
            return this.lastTouch;
        }

        public final void setLastTouch(long l) {
            this.lastTouch = l;
        }

        public final boolean getValid() {
            long currentEpoch = Instant.now().getEpochSecond();
            return this.lastTouch + TurtlematicConfig.INSTANCE.getChunkLoadedTimeLimit() >= currentEpoch;
        }

        public final void touch() {
            this.lastTouch = Instant.now().getEpochSecond();
        }

        public final void invalidate() {
            this.lastTouch = Instant.now().getEpochSecond() - TurtlematicConfig.INSTANCE.getChunkLoadedTimeLimit() / (long)2;
        }

        @NotNull
        public final CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_(ChunkManager.DIMENSION_NAME_TAG, this.dimensionName);
            tag.m_128365_(ChunkManager.POS_TAG, (Tag)UtilsKt.toNBT(this.pos));
            return tag;
        }

        @NotNull
        public final String component1() {
            return this.dimensionName;
        }

        @NotNull
        public final ChunkPos component2() {
            return this.pos;
        }

        public final long component3() {
            return this.lastTouch;
        }

        @NotNull
        public final LoadChunkRecord copy(@NotNull String dimensionName, @NotNull ChunkPos pos, long lastTouch) {
            Intrinsics.checkNotNullParameter((Object)dimensionName, (String)ChunkManager.DIMENSION_NAME_TAG);
            Intrinsics.checkNotNullParameter((Object)pos, (String)ChunkManager.POS_TAG);
            return new LoadChunkRecord(dimensionName, pos, lastTouch);
        }

        public static /* synthetic */ LoadChunkRecord copy$default(LoadChunkRecord loadChunkRecord, String string, ChunkPos chunkPos, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = loadChunkRecord.dimensionName;
            }
            if ((n & 2) != 0) {
                chunkPos = loadChunkRecord.pos;
            }
            if ((n & 4) != 0) {
                l = loadChunkRecord.lastTouch;
            }
            return loadChunkRecord.copy(string, chunkPos, l);
        }

        @NotNull
        public String toString() {
            return "LoadChunkRecord(dimensionName=" + this.dimensionName + ", pos=" + this.pos + ", lastTouch=" + this.lastTouch + ")";
        }

        public int hashCode() {
            int result2 = this.dimensionName.hashCode();
            result2 = result2 * 31 + this.pos.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.lastTouch);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoadChunkRecord)) {
                return false;
            }
            LoadChunkRecord loadChunkRecord = (LoadChunkRecord)other;
            if (!Intrinsics.areEqual((Object)this.dimensionName, (Object)loadChunkRecord.dimensionName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pos, (Object)loadChunkRecord.pos)) {
                return false;
            }
            return this.lastTouch == loadChunkRecord.lastTouch;
        }
    }
}

