/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.mixins;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.client.render.TurtleBlockEntityRenderer;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import site.siredvin.turtlematic.computercraft.peripheral.misc.TurtleChatterPeripheral;
import site.siredvin.turtlematic.util.DataStorageObjects;

@Mixin(value={TurtleBlockEntityRenderer.class})
public class TurtleBlockEntityRendererMixin {
    private static final int MAX_WIDTH = 160;
    private static final int MAX_LINES = 6;
    private static final float TEXT_SCALING = 0.025f;
    private static final float BASE_HEIGHT = 1.6f;

    @Inject(at={@At(value="HEAD")}, method={"render(Ldan200/computercraft/shared/turtle/blocks/TurtleBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V"}, remap=false)
    public void render(@Nonnull TurtleBlockEntity turtle, float partialTicks, @Nonnull PoseStack transform, @Nonnull MultiBufferSource buffers, int lightmapCoord, int overlayLight, CallbackInfo info) {
        ITurtleUpgrade rightUpdate;
        TurtleSide side = TurtleSide.LEFT;
        ITurtleUpgrade leftUpdate = turtle.getUpgrade(side);
        if (!(leftUpdate != null && leftUpdate.getUpgradeID().equals((Object)TurtleChatterPeripheral.Companion.getUPGRADE_ID()) || (rightUpdate = turtle.getUpgrade(side = TurtleSide.RIGHT)) != null && rightUpdate.getUpgradeID().equals((Object)TurtleChatterPeripheral.Companion.getUPGRADE_ID()))) {
            return;
        }
        String text = DataStorageObjects.TurtleChat.INSTANCE.getMessage(turtle.getAccess(), side);
        if (text == null || text.isBlank()) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        ArrayList textLines = new ArrayList();
        for (String textPart : text.split("\n")) {
            textLines.addAll(font.m_92923_(FormattedText.m_130775_((String)textPart), 160));
        }
        transform.m_85836_();
        Objects.requireNonNull(font);
        float lineHeight = 9.0f * 0.025f;
        float height = 1.6f + lineHeight * (float)Math.min(6, textLines.size());
        Vec3 translation = turtle.getRenderOffset(partialTicks);
        transform.m_85837_(translation.f_82479_, translation.f_82480_ + (double)height, translation.f_82481_);
        transform.m_252880_(0.5f, 0.0f, 0.5f);
        transform.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        transform.m_85841_(-0.025f, -0.025f, 0.025f);
        float firstLineOffset = 0.0f;
        for (int i = 0; i < Math.min(textLines.size(), 6); ++i) {
            FormattedCharSequence textLine = (FormattedCharSequence)textLines.get(i);
            if (i == 0) {
                firstLineOffset = (float)(-font.m_92724_(textLine)) / 2.0f;
            }
            MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            Objects.requireNonNull(font);
            font.m_272191_(textLine, firstLineOffset, (float)(9 * (i + 1)), 0xFFFFFF, false, transform.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            bufferSource.m_109911_();
        }
        transform.m_85849_();
    }
}

