/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.computercraft.plugins;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IOwnerAbility;
import site.siredvin.peripheralium.api.peripheral.IPeripheralCheck;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwnerAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.FuelAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.PeripheralOwnerAbility;
import site.siredvin.peripheralium.computercraft.peripheral.owner.TurtlePeripheralOwner;
import site.siredvin.peripheralium.util.NBTUtil;
import site.siredvin.turtlematic.common.configuration.TurtlematicConfig;
import site.siredvin.turtlematic.computercraft.operations.SingleOperation;
import site.siredvin.turtlematic.computercraft.operations.SingleOperationContext;
import site.siredvin.turtlematic.computercraft.peripheral.automatas.BaseAutomataCorePeripheral;
import site.siredvin.turtlematic.computercraft.plugins.AutomataCorePlugin;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u000fH\u0007J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u001e\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lsite/siredvin/turtlematic/computercraft/plugins/AutomataWarpingPlugin;", "Lsite/siredvin/turtlematic/computercraft/plugins/AutomataCorePlugin;", "automataCore", "Lsite/siredvin/turtlematic/computercraft/peripheral/automatas/BaseAutomataCorePeripheral;", "(Lsite/siredvin/turtlematic/computercraft/peripheral/automatas/BaseAutomataCorePeripheral;)V", "operations", "", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;", "getOperations", "()Ljava/util/List;", "pointData", "Lnet/minecraft/nbt/CompoundTag;", "getPointData", "()Lnet/minecraft/nbt/CompoundTag;", "deletePoint", "Ldan200/computercraft/api/lua/MethodResult;", "name", "", "distanceToPoint", "estimateWarpCost", "getWarpCost", "", "context", "Lsite/siredvin/turtlematic/computercraft/operations/SingleOperationContext;", "points", "savePoint", "warpToPoint", "Companion", "turtlematic-forge-1.20.1"})
public final class AutomataWarpingPlugin
extends AutomataCorePlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String POINT_DATA_MARK = "warp_points";
    @NotNull
    private static final String WORLD_DATA_MARK = "warp_world";

    public AutomataWarpingPlugin(@NotNull BaseAutomataCorePeripheral automataCore) {
        Intrinsics.checkNotNullParameter((Object)((Object)automataCore), (String)"automataCore");
        super(automataCore);
    }

    @Override
    @NotNull
    public List<IPeripheralOperation<?>> getOperations() {
        return CollectionsKt.listOf((Object)((Object)SingleOperation.WARP));
    }

    @NotNull
    protected final CompoundTag getPointData() {
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.getAutomataCore().getPeripheralOwner();
        CompoundTag settings = owner.getDataStorage();
        if (!settings.m_128441_(WORLD_DATA_MARK)) {
            Level level = owner.getLevel();
            Intrinsics.checkNotNull((Object)level);
            settings.m_128359_(WORLD_DATA_MARK, level.m_46472_().m_135782_().toString());
        } else {
            String string = settings.m_128461_(WORLD_DATA_MARK);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"settings.getString(WORLD_DATA_MARK)");
            String worldName = string;
            Level level = owner.getLevel();
            Intrinsics.checkNotNull((Object)level);
            if (!Intrinsics.areEqual((Object)level.m_46472_().m_135782_().toString(), (Object)worldName)) {
                throw new LuaException("Incorrect world for this upgrade");
            }
        }
        if (!settings.m_128441_(POINT_DATA_MARK)) {
            settings.m_128365_(POINT_DATA_MARK, (Tag)new CompoundTag());
        }
        CompoundTag compoundTag = settings.m_128469_(POINT_DATA_MARK);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"settings.getCompound(POINT_DATA_MARK)");
        return compoundTag;
    }

    private final int getWarpCost(SingleOperationContext context) {
        IOwnerAbility iOwnerAbility = ((TurtlePeripheralOwner)this.getAutomataCore().getPeripheralOwner()).getAbility((IPeripheralOwnerAbility)PeripheralOwnerAbility.Companion.getFUEL());
        Intrinsics.checkNotNull((Object)iOwnerAbility);
        FuelAbility fuelAbility = (FuelAbility)iOwnerAbility;
        return SingleOperation.WARP.getCost(context) * fuelAbility.getFuelConsumptionMultiply();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult savePoint(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        BaseAutomataCorePeripheral.addRotationCycle$default(this.getAutomataCore(), 0, 1, null);
        CompoundTag data = this.getPointData();
        if (data.m_128431_().size() >= TurtlematicConfig.INSTANCE.getEndAutomataCoreWarpPointLimit()) {
            Object[] objectArray = new Object[]{null, "Cannot add new point, limit reached"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(\n                null\u2026t reached\",\n            )");
            return methodResult;
        }
        data.m_128365_(name, (Tag)NBTUtil.INSTANCE.toNBT(((TurtlePeripheralOwner)this.getAutomataCore().getPeripheralOwner()).getPos()));
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult deletePoint(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        BaseAutomataCorePeripheral.addRotationCycle$default(this.getAutomataCore(), 0, 1, null);
        CompoundTag data = this.getPointData();
        if (!data.m_128441_(name)) {
            Object[] objectArray = new Object[]{null, "Cannot find point to delete"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot find point to delete\")");
            return methodResult;
        }
        data.m_128473_(name);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult points() {
        CompoundTag data = this.getPointData();
        MethodResult methodResult = MethodResult.of((Object)data.m_128431_());
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(data.allKeys)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult warpToPoint(@NotNull String name) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.getAutomataCore().getPeripheralOwner();
        Level level = owner.getLevel();
        Intrinsics.checkNotNull((Object)level);
        Level level2 = level;
        CompoundTag data = this.getPointData();
        if (!data.m_128441_(name)) {
            Object[] objectArray = new Object[]{null, "Cannot find point to warp to"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot find point to warp to\")");
            return methodResult;
        }
        CompoundTag compoundTag = data.m_128469_(name);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"data.getCompound(name)");
        BlockPos newPosition = NBTUtil.INSTANCE.blockPosFromNBT(compoundTag);
        return this.getAutomataCore().withOperation(SingleOperation.WARP, this.getAutomataCore().toDistance(newPosition), arg_0 -> AutomataWarpingPlugin.warpToPoint$lambda$0(owner, level2, newPosition, arg_0), (IPeripheralCheck)new IPeripheralCheck(owner, level2, newPosition){
            final /* synthetic */ TurtlePeripheralOwner $owner;
            final /* synthetic */ Level $level;
            final /* synthetic */ BlockPos $newPosition;
            {
                this.$owner = $owner;
                this.$level = $level;
                this.$newPosition = $newPosition;
            }

            @Nullable
            public final MethodResult check(@NotNull SingleOperationContext it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!this.$owner.isMovementPossible(this.$level, this.$newPosition)) {
                    Object[] objectArray = new Object[]{null, "Move forbidden"};
                    return MethodResult.of((Object[])objectArray);
                }
                return null;
            }

            @Nullable
            public IPeripheralCheck<T> checkAlso(@NotNull IPeripheralCheck<T> check) {
                return IPeripheralCheck.DefaultImpls.checkAlso((IPeripheralCheck)this, check);
            }
        });
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult estimateWarpCost(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CompoundTag data = this.getPointData();
        CompoundTag compoundTag = data.m_128469_(name);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"data.getCompound(name)");
        BlockPos newPosition = NBTUtil.INSTANCE.blockPosFromNBT(compoundTag);
        MethodResult methodResult = MethodResult.of((Object)this.getWarpCost(this.getAutomataCore().toDistance(newPosition)));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(getWarpCost(automataC\u2026toDistance(newPosition)))");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult distanceToPoint(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CompoundTag data = this.getPointData();
        CompoundTag compoundTag = data.m_128469_(name);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"data.getCompound(name)");
        BlockPos newPosition = NBTUtil.INSTANCE.blockPosFromNBT(compoundTag);
        MethodResult methodResult = MethodResult.of((Object)newPosition.m_123333_((Vec3i)((TurtlePeripheralOwner)this.getAutomataCore().getPeripheralOwner()).getPos()));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(newPosition.distManha\u2026ore.peripheralOwner.pos))");
        return methodResult;
    }

    private static final MethodResult warpToPoint$lambda$0(TurtlePeripheralOwner $owner, Level $level, BlockPos $newPosition, SingleOperationContext it) {
        Intrinsics.checkNotNullParameter((Object)$owner, (String)"$owner");
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$newPosition, (String)"$newPosition");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean result2 = $owner.move($level, $newPosition);
        if (!result2) {
            Object[] objectArray = new Object[]{null, "Cannot teleport to location"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot teleport to location\")");
            return methodResult;
        }
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lsite/siredvin/turtlematic/computercraft/plugins/AutomataWarpingPlugin$Companion;", "", "()V", "POINT_DATA_MARK", "", "WORLD_DATA_MARK", "turtlematic-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

