/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import com.tom.storagemod.util.ItemPredicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TagFilter
implements ItemPredicate {
    private ItemStack stack;
    private boolean allowList;
    private List<TagKey<Item>> tags;

    public TagFilter(ItemStack stack) {
        this.stack = stack;
        CompoundTag tag = stack.m_41784_();
        this.allowList = tag.m_128471_("allowlist");
        ListTag list = tag.m_128437_("tags", 8);
        this.tags = new ArrayList<TagKey<Item>>();
        try {
            for (int i = 0; i < list.size(); ++i) {
                this.tags.add((TagKey<Item>)ItemTags.create((ResourceLocation)new ResourceLocation(list.m_128778_(i))));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean configMatch(ItemStack stack) {
        return stack == this.stack;
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.test0(stack) == this.allowList;
    }

    private boolean test0(ItemStack stack) {
        for (int i = 0; i < this.tags.size(); ++i) {
            if (!stack.m_204117_(this.tags.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowList() {
        return this.allowList;
    }

    public void setAllowList(boolean allowList) {
        this.allowList = allowList;
    }

    public void flush() {
        CompoundTag tag = this.stack.m_41784_();
        tag.m_128379_("allowlist", this.allowList);
        ListTag list = new ListTag();
        this.tags.forEach(t -> list.add((Object)StringTag.m_129297_((String)t.f_203868_().toString())));
        tag.m_128365_("tags", (Tag)list);
    }

    public List<TagKey<Item>> getTags() {
        return this.tags;
    }

    public void setTags(List<ResourceLocation> tags) {
        this.tags = tags.stream().map(ItemTags::create).toList();
    }
}

