/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.registration.ModRecipes;
import unhappycodings.thoriumreactors.common.util.FluidParseUtil;

public class SaltSmeltingRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final Ingredient inputSlot1;
    private final Ingredient inputSlot2;
    private final Ingredient inputSlot3;
    private final FluidStack outputTank;
    private final int operationAfterTicks;
    private final int ticks;
    private final int temperature;

    public SaltSmeltingRecipe(ResourceLocation id, Ingredient inputSlot1, Ingredient inputSlot2, Ingredient inputSlot3, FluidStack outputTank, int ticks, int operationAfterTicks, int temperature) {
        this.id = id;
        this.inputSlot1 = inputSlot1;
        this.inputSlot2 = inputSlot2;
        this.inputSlot3 = inputSlot3;
        this.outputTank = outputTank;
        this.ticks = ticks;
        this.operationAfterTicks = operationAfterTicks;
        this.temperature = temperature;
    }

    public boolean matches(@NotNull SimpleContainer container, Level level) {
        if (level.m_5776_()) {
            return false;
        }
        return this.inputSlot1.test(container.m_8020_(2)) && this.inputSlot2.test(container.m_8020_(1)) && this.inputSlot3.test(container.m_8020_(0));
    }

    public boolean matchesAll(@NotNull SimpleContainer container, FluidStack outputFluid, Level level) {
        return this.matches(container, level) && this.matchesFluid(outputFluid);
    }

    public boolean matchesFluid(FluidStack outputFluid) {
        return this.outputTank.getFluid().m_6212_(outputFluid.getFluid()) || outputFluid.isEmpty();
    }

    @NotNull
    public ItemStack assemble(@NotNull SimpleContainer container, @Nullable RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public Ingredient getInputSlot1() {
        return this.inputSlot1;
    }

    public Ingredient getInputSlot2() {
        return this.inputSlot2;
    }

    public Ingredient getInputSlot3() {
        return this.inputSlot3;
    }

    @NotNull
    public ItemStack m_8043_(@Nullable RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public FluidStack getResultFluid() {
        return this.outputTank;
    }

    public int getOperationAfterTicks() {
        return this.operationAfterTicks;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.SALT_SMELTING_RECIPE_TYPE.get();
    }

    public int getTemperature() {
        return this.temperature;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.inputSlot3, this.inputSlot2, this.inputSlot1});
    }

    public int getTicks() {
        return this.ticks;
    }

    public static class Serializer
    implements RecipeSerializer<SaltSmeltingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("thoriumreactors", "salt_smelting");

        @NotNull
        public SaltSmeltingRecipe fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject pSerializedRecipe) {
            Ingredient input1 = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"input").getAsJsonObject("slot-0"));
            if (input1.m_43947_()) {
                throw new IllegalArgumentException("Invalid pattern: Input ingredient 0 must be set! (" + input1 + ")");
            }
            Ingredient input2 = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"input").getAsJsonObject("slot-1"));
            if (input2.m_43947_()) {
                throw new IllegalArgumentException("Invalid pattern: Input ingredient 1 must be set! (" + input2 + ")");
            }
            Ingredient input3 = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"input").getAsJsonObject("slot-2"));
            if (input3.m_43947_()) {
                throw new IllegalArgumentException("Invalid pattern: Input ingredient 2 must be set! (" + input3 + ")");
            }
            FluidStack outputTank = FluidParseUtil.readFluid(GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output").getAsJsonObject("tank-0"));
            if (outputTank.isEmpty()) {
                throw new IllegalArgumentException("Invalid pattern: Output fluid must be set! (" + outputTank + ")");
            }
            int ticks = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"ticks");
            if (ticks <= 0 || ticks > 2500) {
                throw new IllegalArgumentException("Invalid pattern: Needed ticks must be in between 1 and 2500! (" + ticks + ")");
            }
            int operationAfterTicks = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"operationAfterTicks");
            if (operationAfterTicks <= 0 || operationAfterTicks > 1000) {
                throw new IllegalArgumentException("Invalid pattern: Needed ticks must be in between 1 and 1000! (" + operationAfterTicks + ")");
            }
            int temperature = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"temperature");
            if (temperature <= 0 || temperature > 2500) {
                throw new IllegalArgumentException("Invalid pattern: Needed temperature cannot be zero or higher than 2500! (" + ticks + ")");
            }
            return new SaltSmeltingRecipe(pRecipeId, input1, input2, input3, outputTank, ticks, operationAfterTicks, temperature);
        }

        @Nullable
        public SaltSmeltingRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            Ingredient inputSlot1 = Ingredient.m_43940_((FriendlyByteBuf)buf);
            Ingredient inputSlot2 = Ingredient.m_43940_((FriendlyByteBuf)buf);
            Ingredient inputSlot3 = Ingredient.m_43940_((FriendlyByteBuf)buf);
            FluidStack outputTank = buf.readFluidStack();
            int ticks = buf.readInt();
            int operationAfterTicks = buf.readInt();
            int temperature = buf.readInt();
            return new SaltSmeltingRecipe(id, inputSlot1, inputSlot2, inputSlot3, outputTank, ticks, operationAfterTicks, temperature);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, SaltSmeltingRecipe recipe) {
            recipe.inputSlot1.m_43923_(buf);
            recipe.inputSlot2.m_43923_(buf);
            recipe.inputSlot3.m_43923_(buf);
            buf.writeFluidStack(recipe.outputTank);
            buf.writeInt(recipe.ticks);
            buf.writeInt(recipe.operationAfterTicks);
            buf.writeInt(recipe.temperature);
        }
    }
}

