/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.registration.ModRecipes;

public class ConcentratingRecipe
implements Recipe<SimpleContainer> {
    public final ResourceLocation id;
    public final Ingredient inputSlot;
    public final ItemStack outputSlot;
    public final int ticks;

    public ConcentratingRecipe(ResourceLocation id, Ingredient inputSlot, ItemStack outputTank, int ticks) {
        this.id = id;
        this.inputSlot = inputSlot;
        this.outputSlot = outputTank;
        this.ticks = ticks;
    }

    public boolean matches(@NotNull SimpleContainer container, Level level) {
        if (level.m_5776_()) {
            return false;
        }
        return this.inputSlot.test(container.m_8020_(0));
    }

    @NotNull
    public ItemStack assemble(@NotNull SimpleContainer pContainer, @NotNull RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@Nullable RegistryAccess pRegistryAccess) {
        return this.outputSlot.m_41777_();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.CONCENTRATING_RECIPE_TYPE.get();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.inputSlot});
    }

    public int getTicks() {
        return this.ticks;
    }

    public static class Serializer
    implements RecipeSerializer<ConcentratingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("thoriumreactors", "concentrating");

        @NotNull
        public ConcentratingRecipe fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject pSerializedRecipe) {
            Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"input").getAsJsonObject("slot-0"));
            if (input.m_43947_()) {
                throw new IllegalArgumentException("Invalid pattern: Input ingredient must be set! (" + input + ")");
            }
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output").getAsJsonObject("slot-0"));
            if (output.m_41619_()) {
                throw new IllegalArgumentException("Invalid pattern: Output ingredient must be set! (" + output + ")");
            }
            int ticks = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"ticks");
            if (ticks <= 0 || ticks > 2500) {
                throw new IllegalArgumentException("Invalid pattern: Needed ticks cannot be zero or higher than 2500! (" + ticks + ")");
            }
            return new ConcentratingRecipe(pRecipeId, input, output, ticks);
        }

        @Nullable
        public ConcentratingRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack output = buf.m_130267_();
            int ticks = buf.readInt();
            return new ConcentratingRecipe(id, input, output, ticks);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, ConcentratingRecipe recipe) {
            recipe.inputSlot.m_43923_(buf);
            buf.m_130055_(recipe.outputSlot);
            buf.writeInt(recipe.ticks);
        }
    }
}

