/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.recipe;

import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.registration.ModRecipes;
import unhappycodings.thoriumreactors.common.util.FluidParseUtil;

public class CentrifugingRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final FluidStack inputTank;
    private final FluidStack outputTank;
    private final int operationAfterTicks;
    private final int ticks;

    public CentrifugingRecipe(ResourceLocation id, FluidStack inputTank, FluidStack outputTank, int ticks, int operationAfterTicks) {
        this.id = id;
        this.inputTank = inputTank;
        this.outputTank = outputTank;
        this.ticks = ticks;
        this.operationAfterTicks = operationAfterTicks;
    }

    public boolean matches(@NotNull SimpleContainer container, @NotNull Level level) {
        return false;
    }

    public boolean matchesFluid(FluidStack inputFluid, FluidStack outputFluid) {
        return this.inputTank.getFluid().m_6212_(inputFluid.getFluid()) && this.inputTank.getAmount() <= inputFluid.getAmount() && (this.outputTank.getFluid().m_6212_(outputFluid.getFluid()) || outputFluid.isEmpty());
    }

    @NotNull
    public ItemStack assemble(@Nullable SimpleContainer pContainer, @NotNull RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@Nullable RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public FluidStack getResultFluid() {
        return this.outputTank;
    }

    public int getOperationAfterTicks() {
        return this.operationAfterTicks;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.CENTRIFUGING_RECIPE_TYPE.get();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[0]);
    }

    public FluidStack getFluidIngredient() {
        return this.inputTank;
    }

    public int getTicks() {
        return this.ticks;
    }

    public static class Serializer
    implements RecipeSerializer<CentrifugingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("thoriumreactors", "centrifuging");

        @NotNull
        public CentrifugingRecipe fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject pSerializedRecipe) {
            FluidStack inputTank = FluidParseUtil.readFluid(GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"input").getAsJsonObject("tank-0"));
            if (inputTank.isEmpty()) {
                throw new IllegalArgumentException("Invalid pattern: Input fluid must be set! (" + inputTank + ")");
            }
            FluidStack outputTank = FluidParseUtil.readFluid(GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output").getAsJsonObject("tank-0"));
            if (outputTank.isEmpty()) {
                throw new IllegalArgumentException("Invalid pattern: Output fluid must be set! (" + outputTank + ")");
            }
            int ticks = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"ticks");
            if (ticks <= 0 || ticks > 2500) {
                throw new IllegalArgumentException("Invalid pattern: Needed ticks must be in between 1 and 2500! (" + ticks + ")");
            }
            int operationAfterTicks = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"operationAfterTicks");
            if (operationAfterTicks <= 0 || operationAfterTicks > 1000) {
                throw new IllegalArgumentException("Invalid pattern: Needed ticks must be in between 1 and 1000! (" + operationAfterTicks + ")");
            }
            return new CentrifugingRecipe(pRecipeId, inputTank, outputTank, ticks, operationAfterTicks);
        }

        @Nullable
        public CentrifugingRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            FluidStack inputTank = buf.readFluidStack();
            FluidStack outputTank = buf.readFluidStack();
            int ticks = buf.readInt();
            int operationAfterTicks = buf.readInt();
            return new CentrifugingRecipe(id, inputTank, outputTank, ticks, operationAfterTicks);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, CentrifugingRecipe recipe) {
            buf.writeFluidStack(recipe.inputTank);
            buf.writeFluidStack(recipe.outputTank);
            buf.writeInt(recipe.ticks);
            buf.writeInt(recipe.operationAfterTicks);
        }
    }
}

