/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.network.toserver;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;
import unhappycodings.thoriumreactors.common.blockentity.base.MachineContainerBlockEntity;
import unhappycodings.thoriumreactors.common.network.PacketHandler;
import unhappycodings.thoriumreactors.common.network.base.IPacket;
import unhappycodings.thoriumreactors.common.network.toclient.machine.MachineClientDumpModePacket;

public class MachineDumpModePacket
implements IPacket {
    private final BlockPos pos;
    private final String tag;

    public MachineDumpModePacket(BlockPos pos, String tag) {
        this.pos = pos;
        this.tag = tag;
    }

    public static MachineDumpModePacket decode(FriendlyByteBuf buffer) {
        return new MachineDumpModePacket(buffer.m_130135_(), buffer.m_130277_());
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        BlockEntity machine = player.m_20193_().m_7702_(this.pos);
        if (!(machine instanceof MachineContainerBlockEntity)) {
            return;
        }
        MachineContainerBlockEntity blockEntity = (MachineContainerBlockEntity)machine;
        boolean targetBool = false;
        if (this.tag.equals("input")) {
            blockEntity.setInputDump(!blockEntity.isInputDump());
            targetBool = blockEntity.isInputDump();
        }
        if (this.tag.equals("output")) {
            blockEntity.setOutputDump(!blockEntity.isOutputDump());
            targetBool = blockEntity.isOutputDump();
        }
        if (this.tag.equals("dumpInput")) {
            blockEntity.setFluidIn(FluidStack.EMPTY);
        }
        if (this.tag.equals("dumpOutput")) {
            blockEntity.setFluidOut(FluidStack.EMPTY);
        }
        PacketHandler.sendToClient(new MachineClientDumpModePacket(this.pos, this.tag, targetBool), player);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130070_(this.tag);
    }
}

