/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.network.toclient.reactor;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import unhappycodings.thoriumreactors.common.blockentity.turbine.TurbineControllerBlockEntity;
import unhappycodings.thoriumreactors.common.network.base.IPacket;

public class TurbineActivePacket
implements IPacket {
    private final BlockPos pos;
    private final boolean activated;

    public TurbineActivePacket(BlockPos pos, boolean activated) {
        this.pos = pos;
        this.activated = activated;
    }

    public static TurbineActivePacket decode(FriendlyByteBuf buffer) {
        return new TurbineActivePacket(buffer.m_130135_(), buffer.readBoolean());
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        Level level = player.m_20193_();
        BlockEntity machine = level.m_7702_(this.pos);
        if (!(machine instanceof TurbineControllerBlockEntity)) {
            return;
        }
        TurbineControllerBlockEntity blockEntity = (TurbineControllerBlockEntity)machine;
        blockEntity.setActivated(this.activated);
        blockEntity.m_6596_();
        if (this.activated) {
            try {
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://127.0.0.1:6969/?turbineStarts=1")).build();
                client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeBoolean(this.activated);
    }
}

