/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.network.toclient.reactor;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;
import unhappycodings.thoriumreactors.common.blockentity.reactor.ReactorControllerBlockEntity;
import unhappycodings.thoriumreactors.common.network.base.IPacket;

public class ClientReactorRenderDataPacket
implements IPacket {
    private final BlockPos pos;
    private final int reactorHeight;
    private FluidStack fluidIn;
    private FluidStack fluidOut;

    public ClientReactorRenderDataPacket(BlockPos pos, int reactorHeight, FluidStack fluidIn, FluidStack fluidOut) {
        this.pos = pos;
        this.reactorHeight = reactorHeight;
        this.fluidIn = fluidIn;
        this.fluidOut = fluidOut;
    }

    public static ClientReactorRenderDataPacket decode(FriendlyByteBuf buffer) {
        return new ClientReactorRenderDataPacket(buffer.m_130135_(), buffer.readInt(), buffer.readFluidStack(), buffer.readFluidStack());
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockEntity machine = player.m_9236_().m_7702_(this.pos);
        if (!(machine instanceof ReactorControllerBlockEntity)) {
            return;
        }
        ReactorControllerBlockEntity blockEntity = (ReactorControllerBlockEntity)machine;
        blockEntity.setReactorHeight(this.reactorHeight);
        blockEntity.setFluidIn(this.fluidIn);
        blockEntity.setFluidOut(this.fluidOut);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeInt(this.reactorHeight);
        buffer.writeFluidStack(this.fluidIn);
        buffer.writeFluidStack(this.fluidOut);
    }
}

