/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.network.toclient.machine;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import unhappycodings.thoriumreactors.common.blockentity.machine.MachineGeneratorBlockEntity;
import unhappycodings.thoriumreactors.common.network.base.IPacket;

public class ClientGeneratorDataPacket
implements IPacket {
    private final BlockPos pos;
    private final int currentProduction;
    private final int energy;
    private final int maxFuel;
    private final int fuel;
    private final boolean powerable;
    private final int redstoneMode;

    public ClientGeneratorDataPacket(BlockPos pos, int currentProduction, int energy, int fuel, int maxFuel, boolean powerable, int redstoneMode) {
        this.pos = pos;
        this.currentProduction = currentProduction;
        this.energy = energy;
        this.fuel = fuel;
        this.maxFuel = maxFuel;
        this.powerable = powerable;
        this.redstoneMode = redstoneMode;
    }

    public static ClientGeneratorDataPacket decode(FriendlyByteBuf buffer) {
        return new ClientGeneratorDataPacket(buffer.m_130135_(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readBoolean(), buffer.readInt());
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockEntity machine = player.m_9236_().m_7702_(this.pos);
        if (!(machine instanceof MachineGeneratorBlockEntity)) {
            return;
        }
        MachineGeneratorBlockEntity blockEntity = (MachineGeneratorBlockEntity)machine;
        blockEntity.setCurrentProduction(this.currentProduction);
        blockEntity.setEnergy(this.energy);
        blockEntity.setFuel(this.fuel);
        blockEntity.setMaxFuel(this.maxFuel);
        blockEntity.setRedstoneMode(this.redstoneMode);
        blockEntity.setPowerable(this.powerable);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeInt(this.currentProduction);
        buffer.writeInt(this.energy);
        buffer.writeInt(this.fuel);
        buffer.writeInt(this.maxFuel);
        buffer.writeBoolean(this.powerable);
        buffer.writeInt(this.redstoneMode);
    }
}

