/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.network.toclient.machine;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import unhappycodings.thoriumreactors.common.blockentity.machine.MachineFluidEvaporationBlockEntity;
import unhappycodings.thoriumreactors.common.network.base.IPacket;

public class ClientFluidEvaporatorDataPacket
implements IPacket {
    private final BlockPos pos;
    private final int energy;
    private final int maxRecipeTime;
    private final int recipeTime;
    private final int redstoneMode;
    private final boolean powerable;
    private final String fluidTypeIn;
    private final int fluidIn;

    public ClientFluidEvaporatorDataPacket(BlockPos pos, int energy, int maxRecipeTime, int recipeTime, int fluidIn, String fluidTypeIn, boolean powerable, int redstoneMode) {
        this.pos = pos;
        this.energy = energy;
        this.maxRecipeTime = maxRecipeTime;
        this.recipeTime = recipeTime;
        this.powerable = powerable;
        this.redstoneMode = redstoneMode;
        this.fluidTypeIn = fluidTypeIn;
        this.fluidIn = fluidIn;
    }

    public static ClientFluidEvaporatorDataPacket decode(FriendlyByteBuf buffer) {
        return new ClientFluidEvaporatorDataPacket(buffer.m_130135_(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.m_130277_(), buffer.readBoolean(), buffer.readInt());
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockEntity machine = player.m_9236_().m_7702_(this.pos);
        if (!(machine instanceof MachineFluidEvaporationBlockEntity)) {
            return;
        }
        MachineFluidEvaporationBlockEntity blockEntity = (MachineFluidEvaporationBlockEntity)machine;
        blockEntity.setEnergy(this.energy);
        blockEntity.setMaxRecipeTime(this.maxRecipeTime);
        blockEntity.setRecipeTime(this.recipeTime);
        blockEntity.setFluidIn(new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(this.fluidTypeIn)), this.fluidIn));
        blockEntity.setPowerable(this.powerable);
        blockEntity.setRedstoneMode(this.redstoneMode);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeInt(this.energy);
        buffer.writeInt(this.maxRecipeTime);
        buffer.writeInt(this.recipeTime);
        buffer.writeInt(this.fluidIn);
        buffer.m_130070_(this.fluidTypeIn);
        buffer.writeBoolean(this.powerable);
        buffer.writeInt(this.redstoneMode);
    }
}

