/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import unhappycodings.thoriumreactors.common.fluid.ModFluidTypes;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @WrapOperation(method={"aiStep()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getFluidHeight(Lnet/minecraft/tags/TagKey;)D", ordinal=1)}, require=0)
    private double thoriumreactors_customFluidJumpWeaker(LivingEntity livingEntity, TagKey<Fluid> tagKey, Operation<Double> original) {
        List<FluidType> fluidTypes = List.of((FluidType)ModFluidTypes.MOLTEN_SALT.get(), (FluidType)ModFluidTypes.DEPLETED_MOLTEN_SALT.get(), (FluidType)ModFluidTypes.HEATED_MOLTEN_SALT.get(), (FluidType)ModFluidTypes.HYDROFLUORITE.get(), (FluidType)ModFluidTypes.STEAM.get(), (FluidType)ModFluidTypes.URANIUM_HEXAFLUORITE.get(), (FluidType)ModFluidTypes.ENRICHED_URANIUM_HEXAFLUORITE.get());
        for (FluidType fluidType : fluidTypes) {
            double newFluidHeight = this.getFluidTypeHeight(fluidType);
            if (!(newFluidHeight > 0.0)) continue;
            return newFluidHeight;
        }
        return (Double)original.call(new Object[]{livingEntity, tagKey});
    }
}

