/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.container.reactor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import unhappycodings.thoriumreactors.client.config.ClientConfig;
import unhappycodings.thoriumreactors.client.gui.widgets.ModButton;
import unhappycodings.thoriumreactors.common.blockentity.reactor.ReactorControllerBlockEntity;
import unhappycodings.thoriumreactors.common.blockentity.turbine.TurbineControllerBlockEntity;
import unhappycodings.thoriumreactors.common.container.base.editbox.ModEditBox;
import unhappycodings.thoriumreactors.common.container.reactor.ReactorControllerContainer;
import unhappycodings.thoriumreactors.common.enums.ReactorButtonTypeEnum;
import unhappycodings.thoriumreactors.common.enums.ReactorStateEnum;
import unhappycodings.thoriumreactors.common.network.PacketHandler;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ReactorControllerLoadPacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ReactorControllerRodInsertPacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ReactorControllerScramPacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ReactorControllerTemperaturePacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ReactorOpenContainerPacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.TurbineActivePacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.TurbineCoilsPacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.TurbineFlowPacket;
import unhappycodings.thoriumreactors.common.network.toserver.reactor.ReactorControllerChangedPacket;
import unhappycodings.thoriumreactors.common.network.toserver.reactor.ReactorControllerCopyTurbinePacket;
import unhappycodings.thoriumreactors.common.network.toserver.reactor.ReactorControllerRemoveTurbinePacket;
import unhappycodings.thoriumreactors.common.network.toserver.reactor.ReactorControllerStatePacket;
import unhappycodings.thoriumreactors.common.registration.ModSounds;
import unhappycodings.thoriumreactors.common.util.FormattingUtil;
import unhappycodings.thoriumreactors.common.util.ScreenUtil;

public class ReactorControllerScreen
extends AbstractContainerScreen<ReactorControllerContainer> {
    private final ReactorControllerContainer container;
    public Float[] tempGraphValues = new Float[93];
    public Float[] flowGraphValues = new Float[93];
    public Float[] speedGraphValues = new Float[93];
    public Float[] generationGraphValues = new Float[93];
    public boolean leftSideButtonsAdded;
    public boolean rightSideButtonsAdded;
    public int tempIntegers = 0;
    public int flowIntegers = 0;
    public int speedIntegers = 0;
    public int generationIntegers = 0;
    public int selectedRod = -1;
    public int curMouseX = 0;
    public int curMouseY = 0;
    public boolean lastScramState;
    public ModButton[] fuelRodsButtons = new ModButton[81];
    public ModButton[] controlRodsButtons = new ModButton[64];
    public static ModButton incrementerFlow;
    public ModButton turbineLeft;
    public ModButton turbineRight;
    public ModButton turbineRemove;
    public ModButton turbineCopy;
    public ModButton coilEngageButton;
    public ModButton coilDisengageButton;
    public ModButton activateButton;
    public ModButton deactivateButton;
    public ModButton scramButton;
    public ModButton rodSetButton;
    public ModButton loadSetButton;
    public ModButton tempSetButton;
    public ModEditBox[] positionInputs;
    public ModEditBox inputBox1;
    public ModEditBox inputBox2;
    public ModEditBox inputBox3;
    public int selectedTurbine = 0;

    public ReactorControllerScreen(ReactorControllerContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.container = screenContainer;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.addElements();
    }

    public void addElements() {
        int row;
        int i;
        ReactorControllerBlockEntity entity = this.container.getTile();
        this.m_7787_((GuiEventListener)new ModButton(-36, 20, 6, 25, null, () -> ClientConfig.showLeftReactorScreenArea.set((Object)((Boolean)ClientConfig.showLeftReactorScreenArea.get() == false ? 1 : 0)), null, entity, this, 0, 0, true));
        this.m_7787_((GuiEventListener)new ModButton(206, 20, 6, 25, null, () -> ClientConfig.showRightReactorScreenArea.set((Object)((Boolean)ClientConfig.showRightReactorScreenArea.get() == false ? 1 : 0)), null, entity, this, 0, 0, true));
        for (i = 0; i < this.controlRodsButtons.length; ++i) {
            row = i / 8;
            int index = i;
            this.controlRodsButtons[i] = new ModButton(64 - row * 7 + i % 8 * 7, 14 + row * 7 + i % 8 * 7, 4, 4, null, () -> {
                this.selectedRod = index;
                if (this.inputBox3 != null) {
                    this.inputBox3.setValue(String.valueOf(entity.getControlRodStatus((byte)index)));
                }
            }, null, entity, this, 0, 0, true);
            this.m_7787_((GuiEventListener)this.controlRodsButtons[i]);
        }
        for (i = 0; i < this.fuelRodsButtons.length; ++i) {
            row = i / 9;
            this.fuelRodsButtons[i] = new ModButton(64 - row * 7 + i % 9 * 7, 7 + row * 7 + i % 9 * 7, 4, 4, null, null, null, entity, this, 0, 0, false);
            this.m_7787_((GuiEventListener)this.fuelRodsButtons[i]);
        }
    }

    public void trySetValue(ReactorButtonTypeEnum typeEnum) {
        ReactorControllerBlockEntity entity = this.container.getTile();
        try {
            if (typeEnum == ReactorButtonTypeEnum.TEMP && Integer.parseInt(this.inputBox1.getValue()) <= 1320 && Integer.parseInt(this.inputBox1.getValue()) >= 0) {
                PacketHandler.sendToServer(new ReactorControllerTemperaturePacket(entity.m_58899_(), Short.parseShort(this.inputBox1.getValue())));
            }
            if (typeEnum == ReactorButtonTypeEnum.LOAD && Integer.parseInt(this.inputBox2.getValue()) <= 100 && Integer.parseInt(this.inputBox2.getValue()) >= 0) {
                PacketHandler.sendToServer(new ReactorControllerLoadPacket(entity.m_58899_(), Byte.parseByte(this.inputBox2.getValue())));
            }
            if (typeEnum == ReactorButtonTypeEnum.RODS && Integer.parseInt(this.inputBox3.getValue()) <= 100 && Integer.parseInt(this.inputBox3.getValue()) >= 0) {
                PacketHandler.sendToServer(new ReactorControllerRodInsertPacket(entity.m_58899_(), Byte.parseByte(this.inputBox3.getValue()), (byte)this.selectedRod, ReactorControllerScreen.m_96638_()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setTurbineCoils(boolean value) {
        ReactorControllerBlockEntity entity = this.container.getTile();
        if (entity.getTurbinePos().isEmpty()) {
            return;
        }
        PacketHandler.sendToServer(new TurbineCoilsPacket(entity.getTurbinePos().get(this.selectedTurbine), value));
    }

    public void setTurbineActive(boolean value) {
        ReactorControllerBlockEntity entity = this.container.getTile();
        if (entity.getTurbinePos().isEmpty()) {
            return;
        }
        PacketHandler.sendToServer(new TurbineActivePacket(entity.getTurbinePos().get(this.selectedTurbine), value));
    }

    public void setTurbineFlow(boolean reverse) {
        ReactorControllerBlockEntity entity = this.container.getTile();
        if (entity.getTurbinePos().isEmpty()) {
            return;
        }
        int xPos = this.f_96543_ - this.getMainSizeX() / 2;
        int yPos = this.f_96544_ - this.getMainSizeY() / 2;
        boolean mouseOver = ScreenUtil.mouseInArea((xPos + 514) / 2, (yPos + 149) / 2, (xPos + 514 + 28) / 2, (yPos + 149 + 19) / 2, this.curMouseX, this.curMouseY);
        TurbineControllerBlockEntity targetEntity = (TurbineControllerBlockEntity)this.container.getTile().m_58904_().m_7702_(this.container.getTile().getTurbinePos().get(this.selectedTurbine));
        PacketHandler.sendToServer(new TurbineFlowPacket(targetEntity.m_58899_(), (byte)(incrementerFlow.m_5953_(this.curMouseX, this.curMouseY) && mouseOver ? -1 * (ReactorControllerScreen.m_96638_() ? (reverse ? 100 : 10) : 1) : (ReactorControllerScreen.m_96638_() ? (reverse ? 100 : 10) : 1))));
    }

    public void m_6574_(Minecraft pMinecraft, int pWidth, int pHeight) {
        super.m_6574_(pMinecraft, pWidth, pHeight);
        if (this.m_6348_(this.curMouseX, this.curMouseY, 0)) {
            PacketHandler.sendToServer(new ReactorOpenContainerPacket(this.container.getTile().m_58899_()));
        }
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        ReactorControllerBlockEntity entity = ((ReactorControllerContainer)this.m_6262_()).getTile();
        for (int i = 0; i < this.controlRodsButtons.length; ++i) {
            int inputValue;
            byte finalValue;
            if (!this.controlRodsButtons[i].m_5953_(pMouseX, pMouseY) || (finalValue = (byte)((double)(inputValue = entity.getControlRodStatus((byte)i)) + (ReactorControllerScreen.m_96638_() ? pDelta * 10.0 : pDelta))) > 100 || finalValue < 0) continue;
            if (i == this.selectedRod && this.inputBox3 != null) {
                this.inputBox3.setValue(String.valueOf(finalValue));
            }
            PacketHandler.sendToServer(new ReactorControllerRodInsertPacket(entity.m_58899_(), finalValue, (byte)i, false));
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)ModSounds.DIGITALBEEP_0.get()), (float)(pDelta > 0.0 ? 1.0f : 0.99f)));
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    protected void subInit() {
        for (ModEditBox editBox : this.positionInputs) {
            editBox.setBordered(false);
            editBox.setEditable(true);
            editBox.setMaxLength(3);
            editBox.setFilter(this::isInputValid);
            this.m_7787_((GuiEventListener)editBox);
        }
        ReactorControllerBlockEntity entity = this.container.getTile();
        this.inputBox3.setValue("0");
        this.inputBox2.setValue(String.valueOf(entity.getReactorTargetLoadSet()));
        this.inputBox1.setValue(String.valueOf((int)entity.getReactorTargetTemperature()));
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.leftSideButtonsAdded) {
            for (ModEditBox editBox : this.positionInputs) {
                editBox.m_93692_(false);
                if (!editBox.m_198029_()) continue;
                this.m_264313_((GuiEventListener)editBox);
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean isInputValid(String string) {
        if (string.isEmpty()) {
            return true;
        }
        if (string.contains(" ")) {
            return false;
        }
        if (string.length() == 1) {
            return string.matches("[0-9-]");
        }
        return string.split("")[string.split("").length - 1].matches("^-?(\\d+$)");
    }

    public void renderRods(GuiGraphics graphics) {
        int row;
        int i;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getBackgroundTexture());
        ReactorControllerBlockEntity entity = ((ReactorControllerContainer)this.m_6262_()).getTile();
        int xPos = this.f_96543_ - this.getMainSizeX() / 2;
        int yPos = this.f_96544_ - this.getMainSizeY() / 2;
        for (i = 0; i < entity.getFuelRodStatus().length; ++i) {
            row = i / 9;
            graphics.m_280163_(this.getBackgroundTexture(), xPos + (200 - row * 14) + i % 9 * 14, yPos + (68 + row * 14) + i % 9 * 14, 993.0f, (float)(140 - this.getBlitOffset(entity.getFuelRodStatus((byte)i)) * 14), 14, 14, 1024, 1024);
        }
        for (i = 0; i < entity.getControlRodStatus().length; ++i) {
            row = i / 8;
            graphics.m_280163_(this.getBackgroundTexture(), xPos + (200 - row * 14) + i % 8 * 14, yPos + (82 + row * 14) + i % 8 * 14, this.controlRodsButtons[i].m_5953_(this.curMouseX, this.curMouseY) || this.selectedRod == i ? 965.0f : 979.0f, (float)(140 - this.getBlitOffset(entity.getControlRodStatus((byte)i)) * 14 + (entity.isScrammed() && entity.m_58904_().m_46467_() % 20L > 10L ? 200 : 0)), 14, 14, 1024, 1024);
        }
    }

    public int getBlitOffset(int status) {
        int value = 0;
        for (int i = 0; i <= 100; i += 10) {
            if (status < i) continue;
            value = i;
        }
        return value / 10;
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTicks, int x, int y) {
        Object status;
        PoseStack matrixStack = graphics.m_280168_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getBackgroundTexture());
        int xPos = this.f_96543_ - this.getMainSizeX() / 2;
        int yPos = this.f_96544_ - this.getMainSizeY() / 2;
        ReactorControllerBlockEntity entity = this.container.getTile();
        long ticks = this.container.getTile().m_58904_().m_46467_();
        boolean mouseOverSetL = ScreenUtil.mouseInArea((xPos - 72) / 2, (yPos + 147) / 2, (xPos - 72 + 52) / 2, (yPos + 147 + 21) / 2, x, y);
        boolean mouseOverSetM = ScreenUtil.mouseInArea((xPos - 141) / 2, (yPos + 147) / 2, (xPos - 141 + 52) / 2, (yPos + 147 + 21) / 2, x, y);
        boolean mouseOverSetR = ScreenUtil.mouseInArea((xPos - 211) / 2, (yPos + 147) / 2, (xPos - 211 + 52) / 2, (yPos + 147 + 21) / 2, x, y);
        boolean mouseOverStart = ScreenUtil.mouseInArea((xPos + 514) / 2, (yPos + 261) / 2, (xPos + 514 + 83) / 2, (yPos + 261 + 21) / 2, x, y);
        boolean mouseOverRunning = ScreenUtil.mouseInArea((xPos + 514) / 2, (yPos + 289) / 2, (xPos + 514 + 83) / 2, (yPos + 289 + 21) / 2, x, y);
        boolean mouseOverStop = ScreenUtil.mouseInArea((xPos + 514) / 2, (yPos + 316) / 2, (xPos + 514 + 83) / 2, (yPos + 316 + 21) / 2, x, y);
        boolean mouseOverIncrementFlow = ScreenUtil.mouseInArea((xPos + 514) / 2, (yPos + 149) / 2, (xPos + 514 + 28) / 2, (yPos + 149 + 19) / 2, this.curMouseX, this.curMouseY);
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        graphics.m_280163_(this.getBackgroundTexture(), xPos, yPos, 227.0f, 0.0f, 500, 448, 1024, 1024);
        if (this.leftSideButtonsAdded) {
            TurbineControllerBlockEntity controllerBlockEntity;
            BlockEntity blockEntity;
            graphics.m_280163_(this.getBackgroundTexture(), xPos - this.getLeftSideX() - 2, yPos, 0.0f, 0.0f, this.getLeftSideX(), this.getLeftSideY(), 1024, 1024);
            graphics.m_280163_(this.getBackgroundTexture(), xPos - 72, yPos + 148, 83.0f, mouseOverSetL ? 512.0f : 491.0f, 83, 21, 1024, 1024);
            graphics.m_280163_(this.getBackgroundTexture(), xPos - 141, yPos + 148, 83.0f, mouseOverSetM ? 512.0f : 491.0f, 83, 21, 1024, 1024);
            graphics.m_280163_(this.getBackgroundTexture(), xPos - 211, yPos + 148, 83.0f, mouseOverSetR ? 512.0f : 491.0f, 83, 21, 1024, 1024);
            boolean turbineActive = false;
            if (entity.turbinePos.size() > 0 && (blockEntity = entity.m_58904_().m_7702_(entity.turbinePos.get(this.selectedTurbine))) instanceof TurbineControllerBlockEntity && (controllerBlockEntity = (TurbineControllerBlockEntity)blockEntity).isActivated()) {
                turbineActive = true;
            }
            graphics.m_280163_(this.getBackgroundTexture(), xPos - 49, yPos + 293, (float)((entity.isScrammed() ? 957 : 1017) + (turbineActive || entity.isScrammed() ? 0 : -60)), entity.isScrammed() || !turbineActive ? 155.0f : (ticks % 10L == 0L ? 160.0f : 155.0f), 6, 5, 1024, 1024);
            graphics.m_280163_(this.getBackgroundTexture(), xPos - 47, yPos + 285, (float)((entity.isScrammed() ? 957 : 1017) + (turbineActive || entity.isScrammed() ? 0 : -60)), entity.isScrammed() || !turbineActive ? 155.0f : (ticks % 11L == 0L ? 160.0f : 155.0f), 6, 5, 1024, 1024);
            graphics.m_280163_(this.getBackgroundTexture(), xPos - 98, yPos + 285, (float)((entity.isScrammed() ? 957 : 1017) + (turbineActive || entity.isScrammed() ? 0 : -60)), entity.isScrammed() || !turbineActive ? 155.0f : 155.0f, 6, 5, 1024, 1024);
            graphics.m_280163_(this.getBackgroundTexture(), xPos - 100, yPos + 293, (float)((entity.isScrammed() ? 957 : 1017) + (turbineActive || entity.isScrammed() ? 0 : -60)), entity.isScrammed() || !turbineActive ? 155.0f : (ticks % 6L == 0L ? 160.0f : 155.0f), 6, 5, 1024, 1024);
            graphics.m_280163_(this.getBackgroundTexture(), xPos - 89, yPos + 253, (float)((entity.isScrammed() ? 957 : 1017) + (turbineActive || entity.isScrammed() ? 0 : -60)), entity.isScrammed() || !turbineActive ? 155.0f : (ticks % 20L == 0L ? 160.0f : 155.0f), 6, 5, 1024, 1024);
            graphics.m_280163_(this.getBackgroundTexture(), xPos - 190, yPos + 248, (float)((entity.isScrammed() ? 957 : 1017) + (entity.isReactorActive() || entity.isScrammed() ? 0 : -60)), entity.isScrammed() || !entity.isReactorActive() ? 155.0f : (ticks % 2L == 0L ? 160.0f : 155.0f), 6, 5, 1024, 1024);
            graphics.m_280163_(this.getBackgroundTexture(), xPos - 183, yPos + 297, (float)((entity.isScrammed() ? 957 : 1017) + (entity.isReactorActive() || entity.isScrammed() ? 0 : -60)), entity.isScrammed() || !entity.isReactorActive() ? 155.0f : 160.0f, 6, 5, 1024, 1024);
            graphics.m_280163_(this.getBackgroundTexture(), xPos - 174, yPos + 297, (float)((entity.isScrammed() ? 957 : 1017) + (entity.isReactorActive() || entity.isScrammed() ? 0 : -60)), entity.isScrammed() || !entity.isReactorActive() ? 155.0f : (ticks % 13L == 0L ? 160.0f : 155.0f), 6, 5, 1024, 1024);
            graphics.m_280163_(this.getBackgroundTexture(), xPos - 166, yPos + 297, (float)((entity.isScrammed() ? 957 : 1017) + (entity.isReactorActive() || entity.isScrammed() ? 0 : -60)), entity.isScrammed() || !entity.isReactorActive() ? 155.0f : 155.0f, 6, 5, 1024, 1024);
            graphics.m_280163_(this.getBackgroundTexture(), xPos - 158, yPos + 297, (float)((entity.isScrammed() ? 957 : 1017) + (entity.isReactorActive() || entity.isScrammed() ? 0 : -60)), entity.isScrammed() || !entity.isReactorActive() ? 155.0f : (ticks % 8L == 0L ? 155.0f : 160.0f), 6, 5, 1024, 1024);
            graphics.m_280163_(this.getBackgroundTexture(), xPos - 111, yPos + 233, (float)((entity.isScrammed() ? 957 : 1017) + (entity.isExchangerActive() || entity.isScrammed() ? 0 : -60)), entity.isScrammed() || !entity.isExchangerActive() ? 155.0f : (ticks % 16L == 0L ? 160.0f : 155.0f), 6, 5, 1024, 1024);
            graphics.m_280163_(this.getBackgroundTexture(), xPos - 127, yPos + 302, (float)((entity.isScrammed() ? 957 : 1017) + (entity.isExchangerActive() || entity.isScrammed() ? 0 : -60)), entity.isScrammed() || !entity.isExchangerActive() ? 155.0f : (ticks % 18L == 0L ? 160.0f : 155.0f), 6, 5, 1024, 1024);
            status = entity.isScrammed() ? "scram" : (entity.getReactorCurrentTemperature() / 971.0f * 100.0f > 104.0f ? (entity.getReactorCurrentTemperature() / 971.0f * 100.0f > 114.0f ? "critical" : "overload") : "normal");
            graphics.m_280163_(this.getBackgroundTexture(), xPos - 205, yPos + 342, (float)((ticks % 20L < 10L ? 991 : 1003) + (entity.isScrammed() ? -24 : 0)), 154.0f, 12, 12, 1024, 1024);
            graphics.m_280163_(this.getBackgroundTexture(), xPos + (450 - Minecraft.m_91087_().f_91062_.m_92895_(Component.m_237115_((String)("text.thoriumreactors.inventory.reactor.text." + (String)status)).getString()) * 2 - 8), yPos + 181, (float)((ticks % 20L < 10L ? 991 : 1003) - (entity.isScrammed() ? 24 : 0) - (entity.getReactorCurrentTemperature() / 971.0f * 100.0f > 104.0f && !entity.isScrammed() ? 24 : 0)), (float)(154 + (entity.isScrammed() ? 0 : 12)), 12, 12, 1024, 1024);
        }
        if (this.rightSideButtonsAdded) {
            graphics.m_280163_(this.getBackgroundTexture(), xPos + this.getMainSizeX() + 1, yPos, 728.0f, 0.0f, this.getRightSideX(), this.getRightSideY(), 1024, 1024);
            graphics.m_280163_(this.getBackgroundTexture(), xPos + 515, yPos + 149, 166.0f, !entity.getTurbinePos().isEmpty() ? (incrementerFlow.m_5953_(this.curMouseX, this.curMouseY) ? (float)(mouseOverIncrementFlow ? 468 : 487) : 449.0f) : 900.0f, 58, 19, 1024, 1024);
            if (entity.getReactorState() == ReactorStateEnum.STARTING) {
                graphics.m_280163_(this.getBackgroundTexture(), xPos + 514, yPos + 261, 83.0f, mouseOverStart ? 470.0f : 449.0f, 83, 21, 1024, 1024);
            }
            if (entity.getReactorState() == ReactorStateEnum.RUNNING) {
                graphics.m_280163_(this.getBackgroundTexture(), xPos + 514, yPos + 289, 0.0f, mouseOverRunning ? 512.0f : 491.0f, 83, 21, 1024, 1024);
            }
            if (entity.getReactorState() == ReactorStateEnum.STOP) {
                graphics.m_280163_(this.getBackgroundTexture(), xPos + 514, yPos + 316, 0.0f, mouseOverStop ? 470.0f : 449.0f, 83, 21, 1024, 1024);
            }
            graphics.m_280163_(this.getBackgroundTexture(), xPos + 627, yPos + 301, 166.0f, this.scramButton.m_5953_(this.curMouseX, this.curMouseY) ? 540.0f : 506.0f, 80, 34, 1024, 1024);
            if (!entity.getTurbinePos().isEmpty() && (status = this.container.getTile().m_58904_().m_7702_(entity.getTurbinePos().get(this.selectedTurbine))) instanceof TurbineControllerBlockEntity) {
                TurbineControllerBlockEntity targetEntity = (TurbineControllerBlockEntity)((Object)status);
                if (targetEntity.isCoilsEngaged()) {
                    graphics.m_280163_(this.getBackgroundTexture(), xPos + 590, yPos + 86, 82.0f, (float)((!this.coilEngageButton.m_5953_(this.curMouseX, this.curMouseY) ? 533 : 555) + (targetEntity.isCoilsEngaged() ? 0 : 44)), 52, 22, 1024, 1024);
                }
                if (!targetEntity.isCoilsEngaged()) {
                    graphics.m_280163_(this.getBackgroundTexture(), xPos + 655, yPos + 86, 30.0f, (float)((!this.coilDisengageButton.m_5953_(this.curMouseX, this.curMouseY) ? 533 : 555) + (!targetEntity.isCoilsEngaged() ? 0 : 44)), 52, 22, 1024, 1024);
                }
                if (targetEntity.isActivated()) {
                    graphics.m_280163_(this.getBackgroundTexture(), xPos + 590, yPos + 127, 82.0f, (float)((!this.activateButton.m_5953_(this.curMouseX, this.curMouseY) ? 533 : 555) + (targetEntity.isActivated() ? 0 : 44)), 52, 22, 1024, 1024);
                }
                if (!targetEntity.isActivated()) {
                    graphics.m_280163_(this.getBackgroundTexture(), xPos + 655, yPos + 127, 30.0f, (float)((!this.deactivateButton.m_5953_(this.curMouseX, this.curMouseY) ? 533 : 555) + (!targetEntity.isActivated() ? 0 : 44)), 52, 22, 1024, 1024);
                }
            }
            graphics.m_280163_(this.getBackgroundTexture(), xPos + 548, yPos + 22, 961.0f, this.selectedTurbine != 0 ? (float)(!this.turbineLeft.m_5953_(this.curMouseX, this.curMouseY) ? 360 : 377) : 394.0f, 17, 17, 1024, 1024);
            graphics.m_280163_(this.getBackgroundTexture(), xPos + 663, yPos + 22, 978.0f, this.selectedTurbine + 1 < this.container.getTile().getTurbinePos().size() ? (float)(!this.turbineRight.m_5953_(this.curMouseX, this.curMouseY) ? 360 : 377) : 394.0f, 17, 17, 1024, 1024);
            graphics.m_280163_(this.getBackgroundTexture(), xPos + 692, yPos + 25, 995.0f, !this.turbineRemove.m_5953_(this.curMouseX, this.curMouseY) ? 393.0f : 382.0f, 28, 11, 1024, 1024);
            graphics.m_280163_(this.getBackgroundTexture(), xPos + 508, yPos + 25, 995.0f, !this.turbineRemove.m_5953_(this.curMouseX, this.curMouseY) ? 360.0f : 371.0f, 28, 11, 1024, 1024);
            int value = 0;
            if (entity.getFuelRodStatus().length != 0) {
                for (int i = 0; i < entity.getFuelRodStatus().length; ++i) {
                    value += entity.getFuelRodStatus()[i];
                }
                graphics.m_280163_(this.getBackgroundTexture(), xPos + 564, yPos + 376, 224.0f, 449.0f, (int)((float)value / 8100.0f * 100.0f * 1.23f), 9, 1024, 1024);
                graphics.m_280163_(this.getBackgroundTexture(), xPos + 564, yPos + 396, 224.0f, 458.0f, (int)((float)entity.getFluidAmountIn() / (float)entity.getFluidCapacityIn() * 100.0f * 1.23f), 9, 1024, 1024);
            }
        }
        this.renderRods(graphics);
        this.updateTempGraphData();
        this.updateFlowGraphData();
        this.updateSpeedGraphData();
        this.updateGenerationGraphData();
        this.renderGraph(graphics, xPos + 39, yPos + 395, this.tempGraphValues);
        this.renderGraph(graphics, xPos + 149, yPos + 395, this.flowGraphValues);
        this.renderGraph(graphics, xPos + 259, yPos + 395, this.speedGraphValues);
        this.renderGraph(graphics, xPos + 369, yPos + 395, this.generationGraphValues);
        matrixStack.m_85849_();
    }

    public void sendChangedPacket() {
        PacketHandler.sendToServer(new ReactorControllerChangedPacket(((ReactorControllerContainer)this.m_6262_()).getTile().m_58899_()));
    }

    private void changeReactorState(ReactorStateEnum state) {
        PacketHandler.sendToServer(new ReactorControllerStatePacket(((ReactorControllerContainer)this.m_6262_()).getTile().m_58899_(), state));
        this.sendChangedPacket();
    }

    private void scram() {
        PacketHandler.sendToServer(new ReactorControllerScramPacket(((ReactorControllerContainer)this.m_6262_()).getTile().m_58899_()));
        this.sendChangedPacket();
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int x, int y, float pPartialTick) {
        ReactorControllerBlockEntity entity = ((ReactorControllerContainer)this.m_6262_()).getTile();
        this.curMouseX = x;
        this.curMouseY = y;
        this.m_280273_(graphics);
        super.m_88315_(graphics, x, y, pPartialTick);
        this.m_280072_(graphics, x, y);
        if (((Boolean)ClientConfig.showRightReactorScreenArea.get()).booleanValue() && !this.rightSideButtonsAdded) {
            incrementerFlow = new ModButton(220, 45, 31, 11, null, () -> this.setTurbineFlow(false), () -> this.setTurbineFlow(true), entity, this, 0, 0, true);
            this.m_7787_((GuiEventListener)incrementerFlow);
            this.turbineLeft = new ModButton(237, -18, 8, 8, null, () -> this.trySetTurbineSelection(false), null, entity, this, 0, 0, true);
            this.turbineRight = new ModButton(295, -18, 8, 8, null, () -> this.trySetTurbineSelection(true), null, entity, this, 0, 0, true);
            this.turbineRemove = new ModButton(309, -17, 14, 6, null, () -> this.removeTurbine(this.selectedTurbine), null, entity, this, 0, 0, true);
            this.turbineCopy = new ModButton(217, -17, 14, 6, null, () -> this.copyTurbineConfigurations(this.selectedTurbine), null, entity, this, 0, 0, true);
            this.coilEngageButton = new ModButton(258, 15, 26, 11, null, () -> this.setTurbineCoils(true), null, entity, this, 0, 0, true);
            this.coilDisengageButton = new ModButton(290, 15, 26, 11, null, () -> this.setTurbineCoils(false), null, entity, this, 0, 0, true);
            this.activateButton = new ModButton(258, 35, 26, 11, null, () -> this.setTurbineActive(true), null, entity, this, 0, 0, true);
            this.deactivateButton = new ModButton(290, 35, 26, 11, null, () -> this.setTurbineActive(false), null, entity, this, 0, 0, true);
            this.m_7787_((GuiEventListener)this.turbineLeft);
            this.m_7787_((GuiEventListener)this.turbineRight);
            this.m_7787_((GuiEventListener)this.turbineRemove);
            this.m_7787_((GuiEventListener)this.turbineCopy);
            this.m_7787_((GuiEventListener)this.coilEngageButton);
            this.m_7787_((GuiEventListener)this.coilDisengageButton);
            this.m_7787_((GuiEventListener)this.activateButton);
            this.m_7787_((GuiEventListener)this.deactivateButton);
            this.m_7787_((GuiEventListener)new ModButton(220, 101, 41, 11, null, () -> this.changeReactorState(ReactorStateEnum.STARTING), null, entity, this, 0, 0, true));
            this.m_7787_((GuiEventListener)new ModButton(220, 115, 41, 11, null, () -> this.changeReactorState(ReactorStateEnum.RUNNING), null, entity, this, 0, 0, true));
            this.m_7787_((GuiEventListener)new ModButton(220, 128, 41, 11, null, () -> this.changeReactorState(ReactorStateEnum.STOP), null, entity, this, 0, 0, true));
            this.scramButton = new ModButton(276, 120, 41, 19, null, this::scram, null, entity, this, 0, 0, true);
            this.m_7787_((GuiEventListener)this.scramButton);
            this.rightSideButtonsAdded = true;
        } else if (this.rightSideButtonsAdded && !((Boolean)ClientConfig.showRightReactorScreenArea.get()).booleanValue()) {
            this.resetWidgets();
        }
        if (((Boolean)ClientConfig.showLeftReactorScreenArea.get()).booleanValue() && !this.leftSideButtonsAdded) {
            this.rodSetButton = new ModButton(-142, 44, 25, 12, null, () -> this.trySetValue(ReactorButtonTypeEnum.RODS), null, entity, this, 0, 0, true);
            this.loadSetButton = new ModButton(-108, 44, 25, 12, null, () -> this.trySetValue(ReactorButtonTypeEnum.LOAD), null, entity, this, 0, 0, true);
            this.tempSetButton = new ModButton(-72, 44, 25, 12, null, () -> this.trySetValue(ReactorButtonTypeEnum.TEMP), null, entity, this, 0, 0, true);
            this.m_7787_((GuiEventListener)this.rodSetButton);
            this.m_7787_((GuiEventListener)this.loadSetButton);
            this.m_7787_((GuiEventListener)this.tempSetButton);
            this.inputBox1 = new ModEditBox(this.f_96547_, this.f_97735_ - 68, this.f_97736_ + 32, 30, 8, (Component)Component.m_237119_().m_130938_(ScreenUtil::notoSans));
            this.inputBox2 = new ModEditBox(this.f_96547_, this.f_97735_ - 102, this.f_97736_ + 32, 30, 8, (Component)Component.m_237119_().m_130938_(ScreenUtil::notoSans));
            this.inputBox3 = new ModEditBox(this.f_96547_, this.f_97735_ - 138, this.f_97736_ + 32, 30, 8, (Component)Component.m_237119_().m_130938_(ScreenUtil::notoSans));
            for (ModEditBox modEditBox : this.positionInputs = new ModEditBox[]{this.inputBox1, this.inputBox2, this.inputBox3}) {
                this.m_142416_((GuiEventListener)modEditBox);
            }
            this.subInit();
            this.leftSideButtonsAdded = true;
        } else if (this.leftSideButtonsAdded && !((Boolean)ClientConfig.showLeftReactorScreenArea.get()).booleanValue()) {
            this.resetWidgets();
        }
        this.lastScramState = entity.isScrammed();
    }

    public void removeTurbine(int turbine) {
        ReactorControllerBlockEntity entity = this.container.getTile();
        PacketHandler.sendToServer(new ReactorControllerRemoveTurbinePacket(entity.m_58899_(), turbine));
        this.selectedTurbine = 0;
    }

    public void copyTurbineConfigurations(int turbine) {
        ReactorControllerBlockEntity entity = this.container.getTile();
        PacketHandler.sendToServer(new ReactorControllerCopyTurbinePacket(entity.m_58899_(), turbine));
    }

    public void trySetTurbineSelection(boolean increase) {
        if (!increase && this.selectedTurbine > 0) {
            --this.selectedTurbine;
        } else if (increase && this.selectedTurbine + 1 < this.container.getTile().getTurbinePos().size()) {
            ++this.selectedTurbine;
        }
        this.generationIntegers = 0;
        this.generationGraphValues = new Float[93];
        this.speedIntegers = 0;
        this.speedGraphValues = new Float[93];
        this.flowIntegers = 0;
        this.flowGraphValues = new Float[93];
    }

    public void resetWidgets() {
        this.m_169413_();
        this.addElements();
        this.rightSideButtonsAdded = false;
        this.leftSideButtonsAdded = false;
    }

    protected void m_280003_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY) {
        ReactorControllerBlockEntity entity = this.container.getTile();
        this.renderCenterPartTexts(graphics);
        if (this.leftSideButtonsAdded) {
            this.renderLeftPartProgress(graphics);
            this.renderLeftPartTexts(graphics);
            if (this.inputBox1.m_5953_(pMouseX, pMouseY)) {
                this.appendHoverText(graphics, pMouseX, pMouseY, new String[]{"25-999\u00b0C"});
            }
            if (this.inputBox2.m_5953_(pMouseX, pMouseY) || this.inputBox3.m_5953_(pMouseX, pMouseY)) {
                this.appendHoverText(graphics, pMouseX, pMouseY, new String[]{"0-100%"});
            }
            if (this.rodSetButton.m_5953_(pMouseX, pMouseY)) {
                this.appendHoverText(graphics, pMouseX, pMouseY, new Component[]{Component.m_237113_((String)"\u2264 ").m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.tooltip.current"))), Component.m_237113_((String)"\u2265\u2264 ").m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.tooltip.all")))});
            }
        }
        if (this.rightSideButtonsAdded) {
            int i;
            this.renderRightPartProgress(graphics);
            this.renderRightPartTexts(graphics);
            if (this.turbineRemove.m_5953_(pMouseX, pMouseY)) {
                this.appendHoverText(graphics, pMouseX, pMouseY, new Component[]{Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.tooltip.remove"))});
            }
            if (this.turbineCopy.m_5953_(pMouseX, pMouseY)) {
                this.appendHoverText(graphics, pMouseX, pMouseY, new Component[]{Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.tooltip.copy_to_all"))});
            }
            if (incrementerFlow.m_5953_(pMouseX, pMouseY)) {
                this.appendHoverText(graphics, pMouseX, pMouseY, new String[]{"\u2264    \u00b11", "\u2265\u2264 \u00b110", "\u2265\u2321 \u00b1100"});
            }
            for (i = 0; i < this.controlRodsButtons.length; ++i) {
                if (!this.controlRodsButtons[i].m_5953_(pMouseX, pMouseY)) continue;
                this.appendHoverText(graphics, pMouseX, pMouseY, new String[]{entity.getControlRodStatus((byte)i) + "%", "\u2320 \u00b1"});
            }
            for (i = 0; i < this.fuelRodsButtons.length; ++i) {
                if (!this.fuelRodsButtons[i].m_5953_(pMouseX, pMouseY)) continue;
                this.appendHoverText(graphics, pMouseX, pMouseY, new String[]{entity.getFuelRodStatus((byte)i) + "% Fuel", entity.getDepletedFuelRodStatus((byte)i) + "% Depleted"});
            }
        }
    }

    public void renderLeftPartProgress(GuiGraphics graphics) {
        int i;
        PoseStack pPoseStack = graphics.m_280168_();
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.14f, 0.14f, 0.14f);
        ReactorControllerBlockEntity entity = this.container.getTile();
        int fuelValue = 0;
        int wasteValue = 0;
        for (i = 0; i < entity.getFuelRodStatus().length; ++i) {
            fuelValue += entity.getFuelRodStatus()[i];
        }
        for (i = 0; i < entity.getDepletedFuelRodStatus().length; ++i) {
            wasteValue += entity.getDepletedFuelRodStatus()[i];
        }
        this.renderRadialProgress(graphics, -1054, -38, this.selectedRod == -1 ? 0 : entity.getControlRodStatus((byte)this.selectedRod), "");
        this.renderRadialProgress(graphics, -808, -38, (int)((float)fuelValue / 8100.0f * 100.0f), "");
        this.renderRadialProgress(graphics, -808, -38, (int)((float)wasteValue / 8100.0f * 100.0f), "blue/");
        this.renderRadialProgress(graphics, -558, -38, (int)Math.floor(this.container.getTile().getReactorCurrentTemperature() / this.container.getTile().getReactorTargetTemperature() * 100.0f), "");
        pPoseStack.m_85849_();
    }

    public void renderRightPartProgress(GuiGraphics graphics) {
        PoseStack pPoseStack = graphics.m_280168_();
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.14f, 0.14f, 0.14f);
        if (this.container.getTile().getTurbinePos().isEmpty()) {
            this.renderRadialProgress(graphics, 1550, 14, 0, "");
        } else {
            BlockEntity blockEntity = this.container.getTile().m_58904_().m_7702_(this.container.getTile().getTurbinePos().get(this.selectedTurbine));
            if (blockEntity instanceof TurbineControllerBlockEntity) {
                TurbineControllerBlockEntity targetEntity = (TurbineControllerBlockEntity)blockEntity;
                this.renderRadialProgress(graphics, 1550, 14, (int)Math.floor(targetEntity.getTargetFlowrate() / 2500.0f * 100.0f), "");
            }
        }
        pPoseStack.m_85849_();
    }

    public void renderRadialProgress(GuiGraphics graphics, int x, int y, int progress, String section) {
        graphics.m_280218_(new ResourceLocation("thoriumreactors", "textures/gui/progress/" + section + "radial_progress_" + (progress >= 0 && progress <= 100 ? progress : 100) + ".png"), x, y, 0, 0, 222, 222);
    }

    public void renderLeftPartTexts(GuiGraphics graphics) {
        PoseStack pPoseStack = graphics.m_280168_();
        ReactorControllerBlockEntity entity = this.container.getTile();
        int fuelValue = 0;
        for (int i = 0; i < this.container.getTile().getFuelRodStatus().length; ++i) {
            fuelValue += this.container.getTile().getFuelRodStatus()[i];
        }
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.4f, 0.4f, 0.4f);
        ScreenUtil.drawCenteredText(Component.m_237113_((String)((byte)this.selectedRod == -1 ? "0" : entity.getControlRodStatus((byte)this.selectedRod) + "%")).m_130938_(ScreenUtil::notoSans), graphics, -323, 48, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237113_((String)(entity.getReactorTargetLoadSet() + "%")).m_130938_(ScreenUtil::notoSans), graphics, -236, 48, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237113_((String)(Math.floor(entity.getReactorTargetTemperature() * 10.0f) / 10.0 + "\u00b0C")).m_130938_(ScreenUtil::notoSans), graphics, -149, 48, 0xFEFEFE);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.7f, 0.7f, 0.7f);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.valve_manipulation")).m_130938_(ScreenUtil::notoSans), graphics, -206, -39, 0xAAAAAA);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.rod_insert")).m_130938_(ScreenUtil::notoSans), graphics, -184, -17, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)(this.selectedRod == -1 ? FormattingUtil.getTranslatable("reactor.text.select") : FormattingUtil.getTranslatable("reactor.text.rod"))).m_130938_(ScreenUtil::notoSans), graphics, -184, 8, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)(this.selectedRod == -1 ? FormattingUtil.getTranslatable("reactor.text.rod") : "#" + this.selectedRod)).m_130938_(ScreenUtil::notoSans), graphics, -184, 17, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.set")).m_130938_(ScreenUtil::notoSans), graphics, -184, 68, 11566128);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.fuel_load")).m_130938_(ScreenUtil::notoSans), graphics, -135, -17, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237113_((String)String.valueOf((int)((float)fuelValue / 8100.0f * 100.0f))).m_130938_(ScreenUtil::notoSans), graphics, -135, 8, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237113_((String)"%").m_130938_(ScreenUtil::notoSans), graphics, -135, 17, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.set")).m_130938_(ScreenUtil::notoSans), graphics, -135, 68, 11566128);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.temp")).m_130938_(ScreenUtil::notoSans), graphics, -85, -17, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237113_((String)String.valueOf((float)Math.round(entity.getReactorCurrentTemperature() * 10.0f) / 10.0f)).m_130938_(ScreenUtil::notoSans), graphics, -85, 8, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237113_((String)"\u00b0C").m_130938_(ScreenUtil::notoSans), graphics, -85, 17, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.set")).m_130938_(ScreenUtil::notoSans), graphics, -85, 68, 11566128);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.system_chart")).m_130938_(ScreenUtil::notoSans), graphics, -206, 97, 0xAAAAAA);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.reactor_status")).m_130938_(ScreenUtil::notoSans), graphics, -165, 193, 0xFEFEFE);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        ScreenUtil.drawText(Component.m_237115_((String)(entity.isScrammed() ? FormattingUtil.getTranslatable("reactor.text.scram") : (entity.getReactorCurrentTemperature() / 971.0f * 100.0f > 104.0f ? (entity.getReactorCurrentTemperature() / 971.0f * 100.0f > 114.0f ? FormattingUtil.getTranslatable("reactor.text.critical") : FormattingUtil.getTranslatable("reactor.text.overload")) : FormattingUtil.getTranslatable("reactor.text.normal")))).m_130938_(ScreenUtil::notoSans), graphics, -132, 141, entity.isScrammed() ? 11075598 : 0xFEFEFE);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(1.7f, 1.7f, 1.7f);
        float value = (float)(Math.floor(entity.getReactorStatus() * 10.0f) / 10.0);
        ScreenUtil.drawRightboundText(Component.m_237113_((String)((Serializable)(entity.getReactorStatus() == 100.0f ? "100" : Float.valueOf(value)) + "%")).m_130938_(ScreenUtil::notoSans), graphics, -26, 80, 0xFEFEFE);
        pPoseStack.m_85849_();
    }

    public void renderRightPartTexts(GuiGraphics graphics) {
        BlockEntity blockEntity;
        PoseStack pPoseStack = graphics.m_280168_();
        ReactorControllerBlockEntity entity = this.container.getTile();
        int fuelValue = 0;
        if (this.container.getTile().getFuelRodStatus().length != 0) {
            for (int i = 0; i < this.container.getTile().getFuelRodStatus().length; ++i) {
                fuelValue += this.container.getTile().getFuelRodStatus()[i];
            }
        }
        TurbineControllerBlockEntity targetEntity = null;
        if (!this.container.getTile().getTurbinePos().isEmpty() && (blockEntity = this.container.getTile().m_58904_().m_7702_(this.container.getTile().getTurbinePos().get(this.selectedTurbine))) instanceof TurbineControllerBlockEntity) {
            TurbineControllerBlockEntity turbineEntity;
            targetEntity = turbineEntity = (TurbineControllerBlockEntity)blockEntity;
        }
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.4f, 0.4f, 0.4f);
        ScreenUtil.drawCenteredText(Component.m_237113_((String)((targetEntity != null ? (int)targetEntity.getTargetFlowrate() : 0) + "mB")).m_130938_(ScreenUtil::notoSans), graphics, 587, 63, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237113_((String)(!entity.getTurbinePos().isEmpty() ? entity.turbinePos.get(this.selectedTurbine).toString().replace("BlockPos{", "").replace("}", "") : "")).m_130938_(ScreenUtil::notoSans), graphics, 676, -22, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.enriched")).m_130938_(ScreenUtil::notoSans), graphics, 577, 407, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.molten_salt")).m_130938_(ScreenUtil::notoSans), graphics, 577, 433, 0xFEFEFE);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.7f, 0.7f, 0.7f);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.turbine_generator")).m_130938_(ScreenUtil::notoSans), graphics, 314, -39, 0xAAAAAA);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.flow")).m_130938_(ScreenUtil::notoSans), graphics, 336, -5, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237113_((String)(targetEntity != null ? String.valueOf((int)targetEntity.getCurrentFlowrate()) : "0")).m_130938_(ScreenUtil::notoSans), graphics, 336, 17, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237113_((String)"mB/t").m_130938_(ScreenUtil::notoSans), graphics, 336, 26, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.steam")).m_130938_(ScreenUtil::notoSans), graphics, 336, 53, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.coil_engage")).m_130938_(ScreenUtil::notoSans), graphics, 410, 10, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.activated")).m_130938_(ScreenUtil::notoSans), graphics, 410, 39, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.on")).m_130938_(ScreenUtil::notoSans), graphics, 387, 25, targetEntity != null ? (!targetEntity.isCoilsEngaged() ? 19459 : 43275) : 0x1F1F1F, false);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.off")).m_130938_(ScreenUtil::notoSans), graphics, 434, 25, targetEntity != null ? (targetEntity.isCoilsEngaged() ? 4983826 : 12459309) : 0x1F1F1F, false);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.on")).m_130938_(ScreenUtil::notoSans), graphics, 387, 54, targetEntity != null ? (!targetEntity.isActivated() ? 19459 : 43275) : 0x1F1F1F, false);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.off")).m_130938_(ScreenUtil::notoSans), graphics, 434, 54, targetEntity != null ? (targetEntity.isActivated() ? 4983826 : 12459309) : 0x1F1F1F, false);
        if (targetEntity != null) {
            ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.producing")).m_130948_(FormattingUtil.hex(8311637)).m_7220_((Component)Component.m_237113_((String)(targetEntity != null ? (targetEntity.isCoilsEngaged() ? FormattingUtil.formatEnergy(targetEntity.getTurbineGeneration()) : "0.0 FE") + "/t" : "0.0 FE/t")).m_130940_(ChatFormatting.GRAY)).m_130938_(ScreenUtil::notoSans), graphics, 320, 88, targetEntity != null ? (!targetEntity.isActivated() ? 0x1F1F1F : 12459309) : 0x1F1F1F);
            ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.speed")).m_130948_(FormattingUtil.hex(5624714)).m_7220_((Component)Component.m_237113_((String)(targetEntity != null ? Math.floor(targetEntity.getRpm() * 100.0f) / 100.0 + " Rpm" : "0.0 Rpm")).m_130940_(ChatFormatting.GRAY)).m_130938_(ScreenUtil::notoSans), graphics, 320, 99, targetEntity != null ? (!targetEntity.isActivated() ? 0x1F1F1F : 12459309) : 0x1F1F1F);
            ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.flowrate")).m_130948_(FormattingUtil.hex(708302)).m_7220_((Component)Component.m_237113_((String)(targetEntity != null ? targetEntity.getCurrentFlowrate() + " mB/t" : "0.0 mB/t")).m_130940_(ChatFormatting.GRAY)).m_130938_(ScreenUtil::notoSans), graphics, 320, 110, targetEntity != null ? (!targetEntity.isActivated() ? 0x1F1F1F : 12459309) : 0x1F1F1F);
        } else {
            ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.no_turbine_added")).m_130940_(ChatFormatting.GRAY).m_130938_(ScreenUtil::notoSans), graphics, 385, 94);
            ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.use_configurator_to_link")).m_130940_(ChatFormatting.GRAY).m_130938_(ScreenUtil::notoSans), graphics, 385, 102);
        }
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.start")).m_130938_(ScreenUtil::notoSans), graphics, 345, 149, entity.getReactorState() != ReactorStateEnum.STARTING ? 19459 : 43275, false);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.run")).m_130938_(ScreenUtil::notoSans), graphics, 345, 169, entity.getReactorState() != ReactorStateEnum.RUNNING ? 4994325 : 11566128, false);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.stop")).m_130938_(ScreenUtil::notoSans), graphics, 345, 188, entity.getReactorState() != ReactorStateEnum.STOP ? 4983826 : 12459309, false);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.insert_rods")).m_130938_(ScreenUtil::notoSans), graphics, 424, 150, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.into_core")).m_130938_(ScreenUtil::notoSans), graphics, 424, 159, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.manual")).m_130938_(ScreenUtil::notoSans), graphics, 424, 178, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.scram")).m_130938_(ScreenUtil::notoSans), graphics, 424, 187, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.uran")).m_130938_(ScreenUtil::notoSans), graphics, 330, 226, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237113_((String)((int)((float)fuelValue / 8100.0f * 100.0f) + "%")).m_130938_(ScreenUtil::notoSans), graphics, 452, 226, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.fuel")).m_130938_(ScreenUtil::notoSans), graphics, 330, 241, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237113_((String)((int)((float)entity.getFluidAmountIn() / (float)entity.getFluidCapacityIn() * 100.0f) + "%")).m_130938_(ScreenUtil::notoSans), graphics, 452, 241, 0xFEFEFE);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.operation")).m_130938_(ScreenUtil::notoSans), graphics, 314, 129, 0xAAAAAA);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.emergency")).m_130938_(ScreenUtil::notoSans), graphics, 393, 129, 0xAAAAAA);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.fuel_status")).m_130938_(ScreenUtil::notoSans), graphics, 314, 214, 0xAAAAAA);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.turbine")).m_7220_((Component)Component.m_237113_((String)(" #" + (this.selectedTurbine + 1)))).m_130938_(ScreenUtil::notoSans), graphics, 271, -17, 0xFEFEFE);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(1.8f, 1.8f, 1.8f);
        ScreenUtil.drawRightboundText(Component.m_237113_((String)"").m_130938_(ScreenUtil::notoSans), graphics, -27, 73, 0xFEFEFE);
        pPoseStack.m_85849_();
    }

    public void renderCenterPartTexts(GuiGraphics graphics) {
        String status;
        PoseStack pPoseStack = graphics.m_280168_();
        ReactorControllerBlockEntity entity = this.container.getTile();
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.7f, 0.7f, 0.7f);
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.thorium_reactor")).m_130938_(ScreenUtil::notoSans), graphics, -2, 1, 0xAAAAAA);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.reactor_overview_interface")).m_130938_(ScreenUtil::notoSans), graphics, -43, -39, 0xAAAAAA);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.8f, 0.8f, 0.8f);
        ScreenUtil.drawRightboundText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.operating_time")).m_130938_(ScreenUtil::notoSans), graphics, 245, 16, 0xAAAAAA);
        ScreenUtil.drawRightboundText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.main_power")).m_130938_(ScreenUtil::notoSans), graphics, 245, 40, 0xAAAAAA);
        ScreenUtil.drawRightboundText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.reactor_status")).m_130938_(ScreenUtil::notoSans), graphics, 245, 69, 0xAAAAAA);
        ScreenUtil.drawRightboundText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.reactor_load")).m_130938_(ScreenUtil::notoSans), graphics, 245, 95, 0xAAAAAA);
        ScreenUtil.drawRightboundText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.containment")).m_130938_(ScreenUtil::notoSans), graphics, 245, 123, 0xAAAAAA);
        ScreenUtil.drawRightboundText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.radiation")).m_130938_(ScreenUtil::notoSans), graphics, 245, 149, 0xAAAAAA);
        ScreenUtil.drawCenteredText(Component.m_237113_((String)entity.getNotification()).m_130938_(ScreenUtil::notoSans), graphics, this.getXSize() / 2, 170, 0xFEFEFE);
        TurbineControllerBlockEntity targetEntity = !entity.getTurbinePos().isEmpty() ? (TurbineControllerBlockEntity)this.container.getTile().m_58904_().m_7702_(entity.getTurbinePos().get(this.selectedTurbine)) : null;
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.temp")).m_7220_((Component)Component.m_237113_((String)", \u00b0C")).m_130938_(ScreenUtil::notoSans), graphics, -21, 189, 0xAAAAAA);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.flow")).m_7220_((Component)Component.m_237113_((String)", ").m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.mbs")))).m_130938_(ScreenUtil::notoSans), graphics, 47, 189, 0xAAAAAA);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.speed_cap")).m_7220_((Component)Component.m_237113_((String)", ").m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.rpm")))).m_130938_(ScreenUtil::notoSans), graphics, 117, 189, 0xAAAAAA);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.generation")).m_7220_((Component)Component.m_237113_((String)", ").m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.fet")))).m_130938_(ScreenUtil::notoSans), graphics, 185, 189, 0xAAAAAA);
        ScreenUtil.drawCenteredText(Component.m_237113_((String)String.valueOf((float)Math.round(entity.getReactorCurrentTemperature() * 10.0f) / 10.0f)).m_130938_(ScreenUtil::notoSans), graphics, 7, 202, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237113_((String)String.valueOf(targetEntity != null ? targetEntity.getCurrentFlowrate() : 0.0f)).m_130938_(ScreenUtil::notoSans), graphics, 76, 202, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237113_((String)String.valueOf(targetEntity != null ? Math.floor(targetEntity.getRpm() * 100.0f) / 100.0 : 0.0)).m_130938_(ScreenUtil::notoSans), graphics, 145, 202, 0xFEFEFE);
        ScreenUtil.drawCenteredText(Component.m_237113_((String)String.valueOf(targetEntity != null ? targetEntity.getTurbineGeneration() : 0.0f)).m_130938_(ScreenUtil::notoSans), graphics, 215, 202, 0xFEFEFE);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        SimpleDateFormat dateFormat = new SimpleDateFormat("mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT-0"));
        long seconds = entity.getReactorRunningSince() / 20L;
        int hours = (int)Math.floor((float)seconds / 3600.0f);
        int feProduction = 0;
        for (BlockPos blockPos : entity.getTurbinePos()) {
            BlockEntity blockEntity = entity.m_58904_().m_7702_(blockPos);
            if (!(blockEntity instanceof TurbineControllerBlockEntity)) continue;
            TurbineControllerBlockEntity controllerBlockEntity = (TurbineControllerBlockEntity)blockEntity;
            feProduction += controllerBlockEntity.isCoilsEngaged() ? (int)Math.floor(controllerBlockEntity.getTurbineGeneration()) : 0;
        }
        String string = entity.isScrammed() ? FormattingUtil.getTranslatable("reactor.text.scram") : (entity.getReactorCurrentTemperature() / 971.0f * 100.0f > 104.0f ? (entity.getReactorCurrentTemperature() / 971.0f * 100.0f > 114.0f ? FormattingUtil.getTranslatable("reactor.text.critical") : FormattingUtil.getTranslatable("reactor.text.overload")) : (status = FormattingUtil.getTranslatable("reactor.text.normal")));
        ScreenUtil.drawRightboundText(Component.m_237115_((String)(entity.getReactorRunningSince() == -1L ? FormattingUtil.getTranslatable("reactor.text.unset") : (String)(hours > 0 ? (Serializable)(hours < 10 ? "0" + hours : Integer.valueOf(hours)) + ":" : "00:") + dateFormat.format(entity.getReactorRunningSince() / 20L * 1000L))).m_130938_(ScreenUtil::notoSans), graphics, 196, 19, 0xFEFEFE);
        ScreenUtil.drawRightboundText(Component.m_237113_((String)FormattingUtil.formatEnergy(feProduction)).m_130938_(ScreenUtil::notoSans), graphics, 196, 38, 0xFEFEFE);
        ScreenUtil.drawRightboundText(Component.m_237115_((String)status).m_130938_(ScreenUtil::notoSans).m_130940_(ChatFormatting.BOLD), graphics, 196, 61, entity.isScrammed() ? 11075598 : (entity.getReactorCurrentTemperature() / 971.0f * 100.0f > 104.0f ? (entity.getReactorCurrentTemperature() / 971.0f * 100.0f > 114.0f ? 10420230 : 11118080) : 43275));
        ScreenUtil.drawRightboundText(Component.m_237113_((String)((int)((entity.getReactorCurrentTemperature() - 22.0f) / 949.0f * 100.0f) + "%")).m_130938_(ScreenUtil::notoSans), graphics, 196, 82, entity.getReactorCurrentTemperature() / 971.0f * 100.0f > 104.0f ? (entity.getReactorCurrentTemperature() / 971.0f * 100.0f > 114.0f ? 10420230 : 11118080) : 43275);
        ScreenUtil.drawRightboundText(Component.m_237113_((String)(entity.getReactorContainment() + "%")).m_130938_(ScreenUtil::notoSans), graphics, 196, 104, 0xFEFEFE);
        ScreenUtil.drawRightboundText(Component.m_237113_((String)(entity.getReactorRadiation() + " ")).m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.usvh"))).m_130938_(ScreenUtil::notoSans), graphics, 196, 125, 0xFEFEFE);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(1.3f, 1.3f, 1.3f);
        dateFormat = new SimpleDateFormat("HH:mm:ss");
        ScreenUtil.drawCenteredText(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.overview")).m_130938_(ScreenUtil::notoSans), graphics, -2, -6, 0xFEFEFE);
        ScreenUtil.drawRightboundText(Component.m_237113_((String)dateFormat.format(new Date())).m_130938_(ScreenUtil::notoSans), graphics, 151, -6, 0xFEFEFE);
        pPoseStack.m_85849_();
    }

    public void updateTempGraphData() {
        float value = this.container.getTile().getReactorCurrentTemperature();
        if (this.tempIntegers < this.tempGraphValues.length) {
            this.tempGraphValues[this.tempIntegers] = Float.valueOf(value);
            ++this.tempIntegers;
        } else {
            for (int i = 1; i < this.tempGraphValues.length; ++i) {
                this.tempGraphValues[i - 1] = this.tempGraphValues[i];
            }
            this.tempGraphValues[this.tempGraphValues.length - 1] = Float.valueOf(value);
        }
    }

    public void updateFlowGraphData() {
        float value;
        TurbineControllerBlockEntity targetEntity = this.container.getTile().getTurbinePos().size() > 0 ? (TurbineControllerBlockEntity)this.container.getTile().m_58904_().m_7702_(this.container.getTile().getTurbinePos().get(this.selectedTurbine)) : null;
        float f = value = targetEntity != null ? targetEntity.getCurrentFlowrate() : 0.0f;
        if (this.flowIntegers < this.flowGraphValues.length) {
            this.flowGraphValues[this.flowIntegers] = Float.valueOf(value);
            ++this.flowIntegers;
        } else {
            for (int i = 1; i < this.flowGraphValues.length; ++i) {
                this.flowGraphValues[i - 1] = this.flowGraphValues[i];
            }
            this.flowGraphValues[this.flowGraphValues.length - 1] = Float.valueOf(value);
        }
    }

    public void updateSpeedGraphData() {
        float value;
        TurbineControllerBlockEntity targetEntity = !this.container.getTile().getTurbinePos().isEmpty() ? (TurbineControllerBlockEntity)this.container.getTile().m_58904_().m_7702_(this.container.getTile().getTurbinePos().get(this.selectedTurbine)) : null;
        float f = value = targetEntity != null ? (float)(Math.floor(targetEntity.getRpm() * 100.0f) / 100.0) : 0.0f;
        if (this.speedIntegers < this.speedGraphValues.length) {
            this.speedGraphValues[this.speedIntegers] = Float.valueOf(value);
            ++this.speedIntegers;
        } else {
            for (int i = 1; i < this.speedGraphValues.length; ++i) {
                this.speedGraphValues[i - 1] = this.speedGraphValues[i];
            }
            this.speedGraphValues[this.speedGraphValues.length - 1] = Float.valueOf(value);
        }
    }

    public void updateGenerationGraphData() {
        float value;
        TurbineControllerBlockEntity targetEntity = !this.container.getTile().getTurbinePos().isEmpty() ? (TurbineControllerBlockEntity)this.container.getTile().m_58904_().m_7702_(this.container.getTile().getTurbinePos().get(this.selectedTurbine)) : null;
        float f = value = targetEntity != null ? targetEntity.getTurbineGeneration() : 0.0f;
        if (this.generationIntegers < this.generationGraphValues.length) {
            this.generationGraphValues[this.generationIntegers] = Float.valueOf(value);
            ++this.generationIntegers;
        } else {
            for (int i = 1; i < this.generationGraphValues.length; ++i) {
                this.generationGraphValues[i - 1] = this.generationGraphValues[i];
            }
            this.generationGraphValues[this.generationGraphValues.length - 1] = Float.valueOf(value);
        }
    }

    public void renderGraph(GuiGraphics graphics, int x, int y, Float[] list) {
        if (list[0] != null) {
            float max = 0.0f;
            float min = 0.0f;
            for (Float aFloat : list) {
                if (aFloat == null || !(aFloat.floatValue() > max)) continue;
                max = aFloat.floatValue();
            }
            min = max;
            for (Float aFloat : list) {
                if (aFloat == null || !(aFloat.floatValue() < min)) continue;
                min = aFloat.floatValue();
            }
            float calculationMax = max - min;
            for (int i = 0; i < list.length && list[i] != null; ++i) {
                float calculationCurrent = list[i].floatValue() - min;
                float blitSize = (int)(calculationCurrent / calculationMax * 20.0f);
                if (blitSize == 0.0f && calculationCurrent == calculationMax) {
                    blitSize = 20.0f;
                }
                if ((calculationMax - 1.0f == calculationCurrent || calculationMax - 0.010009766f == calculationCurrent || calculationMax - 0.100097656f == calculationCurrent) && blitSize == 0.0f) {
                    blitSize = 10.0f;
                }
                if (blitSize == 0.0f) {
                    blitSize = 1.0f;
                }
                graphics.m_280163_(this.getBackgroundTexture(), x + i, (int)((float)y + (20.0f - blitSize)), (float)(this.container.getTile().isScrammed() ? 1021 : 1022), 167.0f, 1, (int)blitSize, 1024, 1024);
            }
        }
    }

    public void appendHoverText(GuiGraphics graphics, int x, int y, String[] texts) {
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        for (String text : texts) {
            if (text.equals("")) continue;
            list.add(Component.m_237113_((String)text).m_130938_(ScreenUtil::notoSans));
        }
        graphics.m_280666_(Minecraft.m_91087_().f_91062_, list, x - this.f_97735_, y - this.f_97736_);
    }

    public void appendHoverText(GuiGraphics graphics, int x, int y, Component[] texts) {
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        for (Component text : texts) {
            if (text.getString().equals("")) continue;
            list.add(text.m_6881_().m_130938_(ScreenUtil::notoSans));
        }
        graphics.m_280666_(Minecraft.m_91087_().f_91062_, list, x - this.f_97735_, y - this.f_97736_);
    }

    public void m_7379_() {
        ((ReactorControllerContainer)this.m_6262_()).getTile().m_6596_();
        super.m_7379_();
    }

    public int getMainSizeX() {
        return 500;
    }

    public int getMainSizeY() {
        return 448;
    }

    public int getLeftSideX() {
        return 226;
    }

    public int getLeftSideY() {
        return 379;
    }

    public int getRightSideX() {
        return 226;
    }

    public int getRightSideY() {
        return 416;
    }

    public ResourceLocation getBackgroundTexture() {
        return new ResourceLocation("thoriumreactors", "textures/gui/thorium_reactor_gui.png");
    }
}

