/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.container.machine;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import unhappycodings.thoriumreactors.client.util.RenderUtil;
import unhappycodings.thoriumreactors.common.blockentity.machine.MachineSaltMelterBlockEntity;
import unhappycodings.thoriumreactors.common.container.base.screen.MachineScreen;
import unhappycodings.thoriumreactors.common.container.machine.MachineSaltMelterContainer;
import unhappycodings.thoriumreactors.common.registration.ModFluids;
import unhappycodings.thoriumreactors.common.util.FormattingUtil;
import unhappycodings.thoriumreactors.common.util.ScreenUtil;

public class MachineSaltMelterScreen
extends MachineScreen<MachineSaltMelterContainer> {
    private final int[][] positionList = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 24, 25, 25, 26, 27, 28, 30, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 44, 45, 47, 48, 49, 50, 50, 51, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 22, 23, 24, 24, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 51, 51, 52, 52, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 21, 21, 22, 23, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 52, 53, 53, 54, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 20, 20, 21, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 54, 55, 55, 0, 0, 0, 0, 0}, {0, 0, 0, 19, 19, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 56, 56, 0, 0, 0, 0, 0}, {0, 0, 18, 18, 18, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 57, 57, 57, 0, 0, 0, 0}, {0, 17, 17, 17, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 58, 58, 58, 58, 0, 0, 0}, {0, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59, 59, 59, 0, 0, 0}, {0, 15, 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 60, 60, 0, 0, 0}, {0, 14, 14, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 61, 61, 0, 0, 0}, {13, 13, 13, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 62, 62, 62, 0, 0}, {12, 12, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 63, 63, 0, 0}, {11, 11, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 0}, {10, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 65, 65, 0, 0}, {9, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66, 66, 66, 0, 0}, {8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 67, 67, 0, 0}, {7, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68, 68, 68, 0, 0}, {6, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 69, 69, 69, 0, 0}, {5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70, 70, 70, 0, 0}, {4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71, 71, 71, 0, 0}, {3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 72, 72, 0, 0}, {2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 73, 73, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 74, 74, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 75, 75, 75, 75, 75, 75}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 76, 76, 76, 76, 76, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 76, 76, 76, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 76, 0, 0, 0}};
    private MachineSaltMelterContainer container;

    public MachineSaltMelterScreen(MachineSaltMelterContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.container = screenContainer;
    }

    @Override
    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTicks, int x, int y) {
        super.m_7286_(graphics, partialTicks, x, y);
        MachineSaltMelterBlockEntity entity = this.container.getTile();
        RenderUtil.renderFluid(this.getGuiLeft() + 118, this.getGuiTop() + 85, 66, 16, entity.getFluidAmountOut(), entity.getFluidCapacityOut(), (Fluid)ModFluids.FLOWING_MOLTEN_SALT.get());
        RenderUtil.renderFluid(this.getGuiLeft() + 118 + 16, this.getGuiTop() + 85, 66, 2, entity.getFluidAmountOut(), entity.getFluidCapacityOut(), (Fluid)ModFluids.FLOWING_MOLTEN_SALT.get());
        RenderUtil.resetGuiTextures(this.getTexture());
        int energyBlitSize = (int)Math.floor(38.0 / ((double)entity.getEnergyCapacity() / (double)entity.getEnergy()));
        graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 153, this.getGuiTop() + 25 + (38 - energyBlitSize), 176, 14, 8, energyBlitSize);
        graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 119, this.getGuiTop() + 22, 176, 52, 4, 63);
        int fanBlitSize = entity.getWorkingDegree() == 0 ? 0 : (int)Math.floor(16.0 / ((double)entity.getWorkingDegree() / (double)entity.getDegree()));
        graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 39, this.getGuiTop() + 45 + (16 - fanBlitSize), 190, 0 + (16 - fanBlitSize), 16, fanBlitSize);
        int height = entity.getMaxRecipeTime() != 0 ? 78 - (int)Math.floor((float)entity.getRecipeTime() / (float)entity.getMaxRecipeTime() * 78.0f) : 0;
        for (int xIndex = 0; xIndex < this.positionList.length; ++xIndex) {
            for (int yIndex = 0; yIndex < this.positionList[xIndex].length; ++yIndex) {
                if (this.positionList[xIndex][yIndex] > height || this.positionList[xIndex][yIndex] == 0) continue;
                graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 66 + yIndex, this.getGuiTop() + 24 + xIndex, 184, 0, 1, 1);
            }
        }
        if (entity.getState()) {
            graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 81, this.getGuiTop() + 89, 177, 8, 6, 1);
        } else {
            graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 88, this.getGuiTop() + 89, 177, 11, 6, 1);
        }
    }

    @Override
    protected void m_280003_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY) {
        super.m_280003_(graphics, pMouseX, pMouseY);
        MachineSaltMelterBlockEntity entity = this.container.getTile();
        PoseStack pPoseStack = graphics.m_280168_();
        ScreenUtil.drawText(Component.m_237115_((String)"key.categories.inventory").m_130938_(ScreenUtil::notoSans), graphics, 8, 106, 0xAAAAAA);
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.7f, 0.7f, 0.7f);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("machines.salt_melter.name")).m_130938_(ScreenUtil::notoSans), graphics, 10, 2, 0xAAAAAA);
        ScreenUtil.drawRightboundText(Component.m_237113_((String)Minecraft.m_91087_().f_91074_.m_6302_()).m_130938_(ScreenUtil::notoSans), graphics, 242, 2, 0xAAAAAA);
        pPoseStack.m_85849_();
        ScreenUtil.drawCenteredText(Component.m_237115_((String)(entity.getState() ? FormattingUtil.getTranslatable("machines.state.running") : FormattingUtil.getTranslatable("machines.state.idle"))).m_130938_(ScreenUtil::notoSans), graphics, 87, 78, 4182051);
        if (ScreenUtil.mouseInArea(this.getGuiLeft() + 39, this.getGuiTop() + 45, this.getGuiLeft() + 54, this.getGuiTop() + 60, pMouseX, pMouseY)) {
            this.appendHoverText(graphics, pMouseX, pMouseY, new String[]{entity.getDegree() + "\u00b0C (" + FormattingUtil.formatPercentNum(entity.getDegree() - 25, entity.getWorkingDegree() - 25, false) + ")"});
        }
        if (ScreenUtil.mouseInArea(this.getGuiLeft() + 153, this.getGuiTop() + 25, this.getGuiLeft() + 161, this.getGuiTop() + 62, pMouseX, pMouseY)) {
            this.appendHoverText(graphics, pMouseX, pMouseY, new String[]{FormattingUtil.formatEnergy(entity.getEnergy()) + " / " + FormattingUtil.formatEnergy(entity.getCapacity()), FormattingUtil.formatPercentNum(entity.getEnergy(), entity.getCapacity(), true)});
        }
        if (ScreenUtil.mouseInArea(this.getGuiLeft() + 119, this.getGuiTop() + 20, this.getGuiLeft() + 136, this.getGuiTop() + 85, pMouseX, pMouseY)) {
            this.appendHoverText(graphics, pMouseX, pMouseY, new Component[]{entity.getFluidAmountOut() > 0 ? Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.fluid")).m_130946_(" ").m_130946_(entity.getFluidOut().getFluid().getFluidType().getDescription().getString()) : Component.m_237119_(), Component.m_237113_((String)(entity.getFluidAmountOut() + " mB / " + entity.getFluidCapacityOut() + " mB")), Component.m_237113_((String)FormattingUtil.formatPercentNum(entity.getFluidAmountOut(), entity.getFluidCapacityOut(), true))});
        }
    }

    @Override
    public void m_7379_() {
        ((MachineSaltMelterContainer)this.m_6262_()).getTile().m_6596_();
        super.m_7379_();
    }

    @Override
    public int getSizeX() {
        return 176;
    }

    @Override
    public int getSizeY() {
        return 198;
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("thoriumreactors", "textures/gui/salt_melter_gui.png");
    }
}

