/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.container.machine;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import unhappycodings.thoriumreactors.client.gui.widgets.ModButton;
import unhappycodings.thoriumreactors.client.util.RenderUtil;
import unhappycodings.thoriumreactors.common.blockentity.machine.MachineFluidEvaporationBlockEntity;
import unhappycodings.thoriumreactors.common.container.base.screen.MachineScreen;
import unhappycodings.thoriumreactors.common.container.machine.MachineFluidEvaporatorContainer;
import unhappycodings.thoriumreactors.common.util.FormattingUtil;
import unhappycodings.thoriumreactors.common.util.ScreenUtil;

public class MachineFluidEvaporatorScreen
extends MachineScreen<MachineFluidEvaporatorContainer> {
    private MachineFluidEvaporatorContainer container;

    public MachineFluidEvaporatorScreen(MachineFluidEvaporatorContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.container = screenContainer;
    }

    @Override
    protected void addButtons() {
        super.addButtons();
        this.addElements();
    }

    protected void addElements() {
        MachineFluidEvaporationBlockEntity tile = (MachineFluidEvaporationBlockEntity)this.getTile();
        this.m_7787_((GuiEventListener)new ModButton(34, 90, 3, 8, null, () -> this.changeDumpMode("input"), null, (BlockEntity)tile, this, 0, 0, true));
        this.m_7787_((GuiEventListener)new ModButton(37, 90, 19, 8, null, () -> this.changeDumpMode("dumpInput"), null, (BlockEntity)tile, this, 0, 0, true));
    }

    @Override
    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTicks, int x, int y) {
        super.m_7286_(graphics, partialTicks, x, y);
        MachineFluidEvaporationBlockEntity entity = this.container.getTile();
        RenderUtil.renderFluid(this.getGuiLeft() + 36, this.getGuiTop() + 64, 45, 16, entity.getFluidAmountIn(), entity.getFluidCapacityIn(), (Fluid)Fluids.f_76193_);
        RenderUtil.renderFluid(this.getGuiLeft() + 36 + 16, this.getGuiTop() + 64, 45, 2, entity.getFluidAmountIn(), entity.getFluidCapacityIn(), (Fluid)Fluids.f_76193_);
        RenderUtil.resetGuiTextures(this.getTexture());
        int energyBlitSize = (int)Math.floor(38.0 / ((double)entity.getEnergyCapacity() / (double)entity.getEnergy()));
        graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 153, this.getGuiTop() + 25 + (38 - energyBlitSize), 176, 14, 8, energyBlitSize);
        graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 37, this.getGuiTop() + 20, 176, 52, 4, 45);
        int height = entity.getMaxRecipeTime() != 0 ? 22 - (int)Math.floor((float)entity.getRecipeTime() / (float)entity.getMaxRecipeTime() * 22.0f) : 0;
        graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 71, this.getGuiTop() + 32 + (22 - height), 184, 15 + (22 - height), 32, height);
        if (entity.isInputDump()) {
            graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 35, this.getGuiTop() + 91, 177, 8, 1, 3);
        } else {
            graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 35, this.getGuiTop() + 94, 177, 11, 1, 3);
        }
        if (entity.getState()) {
            graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 81, this.getGuiTop() + 89, 177, 8, 6, 1);
        } else {
            graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 88, this.getGuiTop() + 89, 177, 11, 6, 1);
        }
    }

    @Override
    protected void m_280003_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY) {
        super.m_280003_(graphics, pMouseX, pMouseY);
        MachineFluidEvaporationBlockEntity entity = this.container.getTile();
        PoseStack pPoseStack = graphics.m_280168_();
        ScreenUtil.drawText(Component.m_237115_((String)"key.categories.inventory").m_130938_(ScreenUtil::notoSans), graphics, 8, 102, 0xAAAAAA);
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.7f, 0.7f, 0.7f);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("machines.fluid_evaporator.name")).m_130938_(ScreenUtil::notoSans), graphics, 10, 2, 0xAAAAAA);
        ScreenUtil.drawRightboundText(Component.m_237113_((String)Minecraft.m_91087_().f_91074_.m_6302_()).m_130938_(ScreenUtil::notoSans), graphics, 242, 2, 0xAAAAAA);
        pPoseStack.m_85849_();
        ScreenUtil.drawCenteredText(Component.m_237115_((String)(entity.getState() ? FormattingUtil.getTranslatable("machines.state.running") : FormattingUtil.getTranslatable("machines.state.idle"))).m_130938_(ScreenUtil::notoSans), graphics, 87, 78, 4182051);
        if (ScreenUtil.mouseInArea(this.getGuiLeft() + 153, this.getGuiTop() + 25, this.getGuiLeft() + 161, this.getGuiTop() + 62, pMouseX, pMouseY)) {
            this.appendHoverText(graphics, pMouseX, pMouseY, new String[]{FormattingUtil.formatEnergy(entity.getEnergy()) + " / " + FormattingUtil.formatEnergy(entity.getCapacity()), FormattingUtil.formatPercentNum(entity.getEnergy(), entity.getCapacity(), true)});
        }
        if (ScreenUtil.mouseInArea(this.getGuiLeft() + 37, this.getGuiTop() + 20, this.getGuiLeft() + 54, this.getGuiTop() + 64, pMouseX, pMouseY)) {
            this.appendHoverText(graphics, pMouseX, pMouseY, new Component[]{entity.getFluidAmountIn() > 0 ? Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.fluid")).m_130946_(" ").m_130946_(entity.getFluidIn().getFluid().getFluidType().getDescription().getString()) : Component.m_237119_(), Component.m_237113_((String)(entity.getFluidAmountIn() + " mB / " + entity.getFluidCapacityIn() + " mB")), Component.m_237113_((String)FormattingUtil.formatPercentNum(entity.getFluidAmountIn(), entity.getFluidCapacityIn(), true))});
        }
        if (ScreenUtil.mouseInArea(this.getGuiLeft() + 34, this.getGuiTop() + 90, this.getGuiLeft() + 36, this.getGuiTop() + 97, pMouseX, pMouseY)) {
            this.appendHoverText(graphics, pMouseX, pMouseY, new Component[]{Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.auto_dump")).m_130946_(" " + entity.isInputDump()), Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.only_while_running"))});
        }
        if (ScreenUtil.mouseInArea(this.getGuiLeft() + 37, this.getGuiTop() + 90, this.getGuiLeft() + 55, this.getGuiTop() + 97, pMouseX, pMouseY)) {
            this.appendHoverText(graphics, pMouseX, pMouseY, new Component[]{Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.dump_instantly"))});
        }
    }

    @Override
    public void m_7379_() {
        this.getTile().m_6596_();
        super.m_7379_();
    }

    @Override
    public int getSizeX() {
        return 176;
    }

    @Override
    public int getSizeY() {
        return 198;
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("thoriumreactors", "textures/gui/fluid_evaporation_gui.png");
    }
}

