/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.container.machine;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import unhappycodings.thoriumreactors.client.gui.widgets.ModButton;
import unhappycodings.thoriumreactors.common.blockentity.machine.MachineBlastFurnaceBlockEntity;
import unhappycodings.thoriumreactors.common.container.base.screen.MachineScreen;
import unhappycodings.thoriumreactors.common.container.machine.MachineBlastFurnaceContainer;
import unhappycodings.thoriumreactors.common.util.FormattingUtil;
import unhappycodings.thoriumreactors.common.util.ScreenUtil;

public class MachineBlastFurnaceScreen
extends MachineScreen<MachineBlastFurnaceContainer> {
    private MachineBlastFurnaceContainer container;

    public MachineBlastFurnaceScreen(MachineBlastFurnaceContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.container = screenContainer;
    }

    @Override
    protected void addButtons() {
        super.addButtons();
        this.addElements();
    }

    protected void addElements() {
        MachineBlastFurnaceBlockEntity tile = ((MachineBlastFurnaceContainer)this.m_6262_()).getTile();
        this.m_7787_((GuiEventListener)new ModButton(34, 90, 3, 8, null, () -> this.changeDumpMode("input"), null, (BlockEntity)tile, this, 0, 0, true));
        this.m_7787_((GuiEventListener)new ModButton(37, 90, 19, 8, null, () -> this.changeDumpMode("dumpInput"), null, (BlockEntity)tile, this, 0, 0, true));
        this.m_7787_((GuiEventListener)new ModButton(116, 90, 3, 8, null, () -> this.changeDumpMode("output"), null, (BlockEntity)tile, this, 0, 0, true));
        this.m_7787_((GuiEventListener)new ModButton(119, 90, 19, 8, null, () -> this.changeDumpMode("dumpOutput"), null, (BlockEntity)tile, this, 0, 0, true));
    }

    @Override
    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTicks, int x, int y) {
        super.m_7286_(graphics, partialTicks, x, y);
        MachineBlastFurnaceBlockEntity entity = this.container.getTile();
        int energyBlitSize = (int)Math.floor(38.0 / (25000.0 / (double)entity.getEnergy()));
        graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 153, this.getGuiTop() + 25 + (38 - energyBlitSize), 176, 14, 9, energyBlitSize);
        int fanBlitSize = (int)Math.floor(16.0 / ((double)entity.getWorkingDegree() / (double)entity.getDegree()));
        graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 79, this.getGuiTop() + 27 + (16 - fanBlitSize), 190, 0 + (16 - fanBlitSize), 16, fanBlitSize);
        int height = entity.getMaxRecipeTime() != 0 ? 34 - (int)Math.floor((float)entity.getRecipeTime() / (float)entity.getMaxRecipeTime() * 34.0f) : 0;
        graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 70, this.getGuiTop() + 48, 184, 16, height, 11);
        if (entity.getState()) {
            graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 81, this.getGuiTop() + 89, 177, 8, 6, 1);
        } else {
            graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 88, this.getGuiTop() + 89, 177, 11, 6, 1);
        }
    }

    @Override
    protected void m_280003_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY) {
        super.m_280003_(graphics, pMouseX, pMouseY);
        MachineBlastFurnaceBlockEntity entity = this.container.getTile();
        PoseStack pPoseStack = graphics.m_280168_();
        ScreenUtil.drawText(Component.m_237115_((String)"key.categories.inventory").m_130938_(ScreenUtil::notoSans), graphics, 8, 102, 0xAAAAAA);
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.7f, 0.7f, 0.7f);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("machines.blast_furnace.name")).m_130938_(ScreenUtil::notoSans), graphics, 10, 2, 0xAAAAAA);
        ScreenUtil.drawRightboundText(Component.m_237113_((String)Minecraft.m_91087_().f_91074_.m_6302_()).m_130938_(ScreenUtil::notoSans), graphics, 242, 2, 0xAAAAAA);
        pPoseStack.m_85849_();
        ScreenUtil.drawCenteredText(Component.m_237115_((String)(entity.getState() ? FormattingUtil.getTranslatable("machines.state.running") : FormattingUtil.getTranslatable("machines.state.idle"))).m_130938_(ScreenUtil::notoSans), graphics, 87, 78, 4182051);
        if (ScreenUtil.mouseInArea(this.getGuiLeft() + 79, this.getGuiTop() + 27, this.getGuiLeft() + 94, this.getGuiTop() + 42, pMouseX, pMouseY)) {
            this.appendHoverText(graphics, pMouseX, pMouseY, new String[]{entity.getDegree() + "\u00b0C (" + FormattingUtil.formatPercentNum(entity.getDegree() - 25, entity.getWorkingDegree() - 25, false) + ")"});
        }
        if (ScreenUtil.mouseInArea(this.getGuiLeft() + 153, this.getGuiTop() + 25, this.getGuiLeft() + 161, this.getGuiTop() + 62, pMouseX, pMouseY)) {
            this.appendHoverText(graphics, pMouseX, pMouseY, new String[]{FormattingUtil.formatEnergy(entity.getEnergy()) + " / " + FormattingUtil.formatEnergy(entity.getCapacity()), FormattingUtil.formatPercentNum(entity.getEnergy(), entity.getCapacity(), true)});
        }
    }

    @Override
    public void m_7379_() {
        ((MachineBlastFurnaceContainer)this.m_6262_()).getTile().m_6596_();
        super.m_7379_();
    }

    @Override
    public int getSizeX() {
        return 176;
    }

    @Override
    public int getSizeY() {
        return 198;
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("thoriumreactors", "textures/gui/blast_furnace_gui.png");
    }
}

