/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.container.base.screen;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import unhappycodings.thoriumreactors.client.gui.widgets.ModButton;
import unhappycodings.thoriumreactors.common.blockentity.base.MachineContainerBlockEntity;
import unhappycodings.thoriumreactors.common.container.base.container.BaseContainer;
import unhappycodings.thoriumreactors.common.container.base.screen.BaseScreen;
import unhappycodings.thoriumreactors.common.network.PacketHandler;
import unhappycodings.thoriumreactors.common.network.toserver.MachineChangedPacket;
import unhappycodings.thoriumreactors.common.network.toserver.MachineDumpModePacket;
import unhappycodings.thoriumreactors.common.network.toserver.MachinePowerablePacket;
import unhappycodings.thoriumreactors.common.network.toserver.MachineRedstoneModePacket;
import unhappycodings.thoriumreactors.common.util.FormattingUtil;
import unhappycodings.thoriumreactors.common.util.ScreenUtil;

public class MachineScreen<T extends BaseContainer>
extends BaseScreen<T> {
    public static final ResourceLocation POWER_OFF = new ResourceLocation("thoriumreactors", "textures/gui/button/power_off.png");
    public static final ResourceLocation POWER_ON = new ResourceLocation("thoriumreactors", "textures/gui/button/power_on.png");
    public static final ResourceLocation REDSTONE_NORMAL = new ResourceLocation("thoriumreactors", "textures/gui/button/redstone_normal.png");
    public static final ResourceLocation REDSTONE_INVERTED = new ResourceLocation("thoriumreactors", "textures/gui/button/redstone_inverted.png");
    public static final ResourceLocation REDSTONE_IGNORED = new ResourceLocation("thoriumreactors", "textures/gui/button/redstone_ignored.png");
    public static final ResourceLocation INFORMATION = new ResourceLocation("thoriumreactors", "textures/gui/button/information.png");
    public static final ResourceLocation WARNING = new ResourceLocation("thoriumreactors", "textures/gui/button/warning.png");
    boolean lastPowerable;
    int lastRedstoneMode;

    public MachineScreen(T screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
    }

    public void refreshWidgets() {
        this.m_169413_();
        this.addButtons();
    }

    protected void m_7856_() {
        this.addButtons();
        super.m_7856_();
    }

    protected void addButtons() {
        MachineContainerBlockEntity tile = (MachineContainerBlockEntity)this.getTile();
        this.m_169394_((Renderable)new ModButton(-18, 6, 16, 16, INFORMATION, null, null, (BlockEntity)tile, this, 16, 32, false));
        this.lastPowerable = tile.isPowerable();
        this.m_142416_((GuiEventListener)new ModButton(-18, 24, 16, 16, this.lastPowerable ? POWER_ON : POWER_OFF, () -> this.changePowerable(!tile.isPowerable()), null, (BlockEntity)tile, this, 16, 32, true));
        this.lastRedstoneMode = tile.getRedstoneMode();
        this.m_142416_((GuiEventListener)new ModButton(-18, 42, 16, 16, this.lastRedstoneMode == 0 ? REDSTONE_IGNORED : (this.lastRedstoneMode == 1 ? REDSTONE_NORMAL : REDSTONE_INVERTED), this::changeRedstoneMode, null, (BlockEntity)tile, this, 16, 32, true));
        if (!this.isSpaceAbove()) {
            this.m_142416_((GuiEventListener)new ModButton(this.getSizeX() + 2, 6, 16, 16, WARNING, null, null, (BlockEntity)tile, this, 16, 32, false));
        }
    }

    protected void m_280003_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY) {
        ArrayList<MutableComponent> list;
        MachineContainerBlockEntity entity = (MachineContainerBlockEntity)this.getTile();
        if (ScreenUtil.mouseInArea(this.getGuiLeft() - 18, this.getGuiTop() + 6, this.getGuiLeft() - 3, this.getGuiTop() + 21, pMouseX, pMouseY)) {
            list = new ArrayList<MutableComponent>();
            list.add(Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.usage")).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)(FormattingUtil.formatEnergy(entity.getState() ? (float)entity.getNeededEnergy() : 0.0f) + "/t"))));
            graphics.m_280666_(Minecraft.m_91087_().f_91062_, list, pMouseX - this.f_97735_, pMouseY - this.f_97736_);
        }
        if (ScreenUtil.mouseInArea(this.getGuiLeft() - 18, this.getGuiTop() + 24, this.getGuiLeft() - 3, this.getGuiTop() + 39, pMouseX, pMouseY)) {
            list = new ArrayList();
            list.add(Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.power")).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)("" + entity.isPowerable()))));
            graphics.m_280666_(Minecraft.m_91087_().f_91062_, list, pMouseX - this.f_97735_, pMouseY - this.f_97736_);
        }
        if (ScreenUtil.mouseInArea(this.getGuiLeft() - 18, this.getGuiTop() + 42, this.getGuiLeft() - 3, this.getGuiTop() + 57, pMouseX, pMouseY)) {
            list = new ArrayList();
            list.add(Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.redstone")).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)(this.lastRedstoneMode == 0 ? FormattingUtil.getTranslatable("machines.tooltip.ignore") : (this.lastRedstoneMode == 1 ? FormattingUtil.getTranslatable("machines.tooltip.normal") : FormattingUtil.getTranslatable("machines.tooltip.inverted"))))));
            graphics.m_280666_(Minecraft.m_91087_().f_91062_, list, pMouseX - this.f_97735_, pMouseY - this.f_97736_);
        }
        if (ScreenUtil.mouseInArea(this.getGuiLeft() + this.getSizeX() + 2, this.getGuiTop() + 6, this.getGuiLeft() + this.getSizeX() + 17, this.getGuiTop() + 21, pMouseX, pMouseY) && !this.isSpaceAbove()) {
            list = new ArrayList();
            list.add(Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.warning")).m_130940_(ChatFormatting.RED));
            list.add(Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.needs_air")));
            list.add(Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.make_space")));
            graphics.m_280666_(Minecraft.m_91087_().f_91062_, list, pMouseX - this.f_97735_, pMouseY - this.f_97736_);
        }
    }

    public boolean isSpaceAbove() {
        return this.getTile().m_58904_().m_8055_(this.getTile().m_58899_().m_7494_()).m_60713_(Blocks.f_50016_);
    }

    protected void changeRedstoneMode() {
        PacketHandler.sendToServer(new MachineRedstoneModePacket(this.getTile().m_58899_()));
        this.sendChangedPacket();
    }

    protected void changePowerable(boolean state) {
        PacketHandler.sendToServer(new MachinePowerablePacket(this.getTile().m_58899_(), state));
        this.sendChangedPacket();
    }

    protected void changeDumpMode(String tag) {
        PacketHandler.sendToServer(new MachineDumpModePacket(this.getTile().m_58899_(), tag));
        this.sendChangedPacket();
    }

    protected void sendChangedPacket() {
        PacketHandler.sendToServer(new MachineChangedPacket(this.getTile().m_58899_()));
    }

    public void appendHoverText(GuiGraphics graphics, int x, int y, String[] texts) {
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        for (String text : texts) {
            if (text.equals("")) continue;
            list.add(Component.m_237113_((String)text));
        }
        graphics.m_280666_(Minecraft.m_91087_().f_91062_, list, x - this.f_97735_, y - this.f_97736_);
    }

    public void appendHoverText(GuiGraphics graphics, int x, int y, Component[] texts) {
        ArrayList<Component> list = new ArrayList<Component>();
        for (Component text : texts) {
            if (text.getString().equals("")) continue;
            list.add(text);
        }
        graphics.m_280666_(Minecraft.m_91087_().f_91062_, list, x - this.f_97735_, y - this.f_97736_);
    }

    @Override
    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTicks, int x, int y) {
        super.m_7286_(graphics, partialTicks, x, y);
        this.refreshWidgets();
    }

    public void m_7379_() {
        this.getTile().m_6596_();
        super.m_7379_();
    }

    @Override
    public int getSizeX() {
        return 0;
    }

    @Override
    public int getSizeY() {
        return 0;
    }

    @Override
    public ResourceLocation getTexture() {
        return null;
    }

    @Override
    public BlockEntity getTile() {
        return ((BaseContainer)this.m_6262_()).getTile();
    }
}

