/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public static ForgeConfigSpec commonConfig;
    public static ForgeConfigSpec.DoubleValue reactorSaltGenerationModifier;
    public static ForgeConfigSpec.DoubleValue turbineEnergyGenerationModifier;

    private static void init(ForgeConfigSpec.Builder commonBuilder) {
        commonBuilder.push("Reactor");
        reactorSaltGenerationModifier = commonBuilder.comment("Modifier of reactor salt generation. 1.0 is default and means normal generation 2.0 means doubled, 0.5 half!").defineInRange("reactor_salt_generation_modifier", 1.0, 0.0, 100.0);
        commonBuilder.pop();
        commonBuilder.push("Turbine");
        turbineEnergyGenerationModifier = commonBuilder.comment("Modifier of turbine energy generation. 1.0 is default and means normal generation 2.0 means doubled, 0.5 half!").defineInRange("turbine_energy_generation_modifier", 1.0, 0.0, 100.0);
        commonBuilder.pop();
    }

    public static void loadConfigFile(ForgeConfigSpec config, String path) {
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
    }

    static {
        ForgeConfigSpec.Builder commonBuilder = new ForgeConfigSpec.Builder();
        CommonConfig.init(commonBuilder);
        commonConfig = commonBuilder.build();
    }
}

