/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.blockentity.turbine;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.block.reactor.ReactorControllerBlock;
import unhappycodings.thoriumreactors.common.block.turbine.TurbineControllerBlock;
import unhappycodings.thoriumreactors.common.blockentity.turbine.TurbinePowerPortBlockEntity;
import unhappycodings.thoriumreactors.common.blockentity.turbine.TurbineValveBlockEntity;
import unhappycodings.thoriumreactors.common.config.CommonConfig;
import unhappycodings.thoriumreactors.common.network.PacketHandler;
import unhappycodings.thoriumreactors.common.network.toclient.turbine.ClientTurbineControllerDataPacket;
import unhappycodings.thoriumreactors.common.registration.ModBlockEntities;
import unhappycodings.thoriumreactors.common.registration.ModDamageSources;
import unhappycodings.thoriumreactors.common.registration.ModFluids;
import unhappycodings.thoriumreactors.common.registration.ModSounds;
import unhappycodings.thoriumreactors.common.util.EnergyUtil;
import unhappycodings.thoriumreactors.common.util.FormattingUtil;

public class TurbineControllerBlockEntity
extends BlockEntity {
    private BlockPos valvePos = BlockPos.f_121853_;
    private BlockPos powerPortPos = BlockPos.f_121853_;
    private String warning = "";
    private boolean assembled;
    private boolean coilsEngaged;
    private boolean activated;
    private float rotation = 0.0f;
    private float rpm = 0.0f;
    private float lastRpm = 0.0f;
    private float ticks = 0.0f;
    private float targetFlowrate = 0.0f;
    private float currentFlowrate = 0.0f;
    private int turbineHeight;
    private float energyModifier;
    private long turbinetime = 0L;

    public TurbineControllerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.TURBINE_CONTROLLER.get(), pPos, pBlockState);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void tick() {
        block17: {
            block16: {
                BlockEntity blockEntity;
                if (this.f_58857_.m_46467_() % 20L == 0L) {
                    ++this.turbinetime;
                }
                if (this.f_58857_.m_46467_() % 40L == 0L) {
                    this.f_58857_.m_5594_(null, this.m_58899_().m_5484_(((Direction)this.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)).m_122424_(), 2).m_5484_(Direction.UP, 1), (SoundEvent)ModSounds.TURBINE_RUN.get(), SoundSource.BLOCKS, this.getRpm() / 2000.0f, 1.0f);
                }
                if (this.valvePos == null || this.powerPortPos == null || !((blockEntity = this.f_58857_.m_7702_(this.valvePos)) instanceof TurbineValveBlockEntity)) break block16;
                TurbineValveBlockEntity valveBlockEntity = (TurbineValveBlockEntity)blockEntity;
                blockEntity = this.f_58857_.m_7702_(this.powerPortPos);
                if (!(blockEntity instanceof TurbinePowerPortBlockEntity)) break block16;
                TurbinePowerPortBlockEntity powerPortBlockEntity = (TurbinePowerPortBlockEntity)blockEntity;
                if (this.coilsEngaged) {
                    if ((float)powerPortBlockEntity.getEnergy() + this.getTurbineGeneration() < (float)powerPortBlockEntity.getCapacity()) {
                        powerPortBlockEntity.setEnergy((int)((float)powerPortBlockEntity.getEnergy() + this.getTurbineGeneration()));
                        EnergyUtil.trySendToNeighbors(this.f_58857_, this.m_58899_(), powerPortBlockEntity.getEnergyStorage(), powerPortBlockEntity.getEnergy(), (int)powerPortBlockEntity.getMaxEnergyTransfer());
                    } else if (powerPortBlockEntity.getEnergy() != powerPortBlockEntity.getCapacity()) {
                        powerPortBlockEntity.setEnergy(powerPortBlockEntity.getCapacity());
                        EnergyUtil.trySendToNeighbors(this.f_58857_, this.m_58899_(), powerPortBlockEntity.getEnergyStorage(), powerPortBlockEntity.getEnergy(), (int)powerPortBlockEntity.getMaxEnergyTransfer());
                    }
                }
                if (this.activated && valveBlockEntity.getFluidIn().isFluidEqual(new FluidStack((Fluid)ModFluids.SOURCE_STEAM.get(), 1)) && valveBlockEntity.getFluidAmountIn() >= 1) {
                    float amount = Math.min((float)valveBlockEntity.getFluidAmountIn(), this.getTargetFlowrate());
                    this.setCurrentFlowrate(amount);
                    if (amount > 1.0f) {
                        valveBlockEntity.setFluidIn(new FluidStack(valveBlockEntity.getFluidIn(), (int)((float)valveBlockEntity.getFluidAmountIn() - amount)));
                        this.setRpm(this.getRpm() + Math.abs(amount / 10.0f) * this.getTurbineRotationModifier(true));
                    }
                    if (this.getRpm() - (1.0f - Math.abs(amount / 5.0f) / 1000.0f) >= 0.0f && (this.getRpm() > 250.0f || this.getTargetFlowrate() == 0.0f)) {
                        this.setRpm(this.getRpm() - (1.0f - Math.abs(amount / 5.0f) / 1000.0f));
                    }
                    break block17;
                } else {
                    if (this.getRpm() > 0.0f) {
                        this.setRpm(this.getRpm() - this.getTurbineRotationModifier(false));
                    }
                    this.setCurrentFlowrate(0.0f);
                }
                break block17;
            }
            this.setAssembled(false);
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)TurbineControllerBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        }
        if (this.turbinetime == 3L && this.getRpm() > 50.0f && this.f_58857_.m_46467_() % 20L == 0L) {
            float random = new Random().nextFloat();
            this.m_58904_().m_5594_(null, this.m_58899_().m_5484_(((Direction)this.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)).m_122424_(), 2).m_5484_(Direction.UP, 1), random < 0.2f ? (SoundEvent)ModSounds.TURBINE_HISS_1.get() : (random < 0.8f ? (SoundEvent)ModSounds.TURBINE_HISS_2.get() : (SoundEvent)ModSounds.TURBINE_HISS_3.get()), SoundSource.BLOCKS, 1.0f, 1.0f);
            ++this.turbinetime;
        } else if (this.turbinetime >= 4L) {
            this.turbinetime = 0L;
        }
        for (Player player : this.f_58857_.m_6907_()) {
            PacketHandler.sendToClient(new ClientTurbineControllerDataPacket(this.m_58899_(), this.coilsEngaged, this.activated, this.targetFlowrate, this.currentFlowrate, this.rpm, this.turbinetime), (ServerPlayer)player);
        }
        if (this.f_58857_.m_46467_() % 10L == 0L) {
            this.turbinePlayerCheck();
        }
    }

    public void turbinePlayerCheck() {
        BlockPos p = this.m_58899_().m_5484_(((Direction)this.m_58900_().m_61143_((Property)ReactorControllerBlock.FACING)).m_122424_(), 2);
        List players = this.f_58857_.m_45976_(ServerPlayer.class, new AABB((double)(p.m_123341_() - 2), (double)(p.m_123342_() - 1), (double)(p.m_123343_() - 2), (double)(p.m_123341_() + 3), (double)(p.m_123342_() + this.getTurbineHeight()), (double)(p.m_123343_() + 3)));
        for (ServerPlayer player : players) {
            player.m_6469_(this.f_58857_.m_269111_().m_269079_(ModDamageSources.GRIND), Float.MAX_VALUE);
        }
    }

    private float getTurbineRotationModifier(boolean upwards) {
        float rpm = this.getRpm();
        if (upwards) {
            return rpm <= 20.0f ? 0.01f : 5.0f / rpm;
        }
        if (rpm > 1999.0f) {
            return 16.5f;
        }
        if (rpm > 1498.0f) {
            return 11.5f;
        }
        if (rpm > 1448.0f) {
            return 10.9f;
        }
        if (rpm > 1400.0f) {
            return 9.9f;
        }
        if (rpm > 1250.0f) {
            return 8.4f;
        }
        if (rpm > 1100.0f) {
            return 7.4f;
        }
        if (rpm > 950.0f) {
            return 6.5f;
        }
        if (rpm > 800.0f) {
            return 4.6f;
        }
        if (rpm > 650.0f) {
            return 2.5f;
        }
        if (rpm > 500.0f) {
            return 1.4f;
        }
        if (rpm > 350.0f) {
            return 1.0f;
        }
        if (rpm > 200.0f) {
            return 0.8f;
        }
        if (rpm > 100.0f) {
            return 0.7f;
        }
        if (rpm > 45.0f) {
            return 0.4f;
        }
        if (rpm > 25.0f) {
            return 0.2f;
        }
        return rpm - 0.002f >= 0.0f ? 0.002f : rpm;
    }

    public float getTurbineGeneration() {
        return this.isCoilsEngaged() ? (float)Math.floor((double)this.getRpm() * ((double)(FormattingUtil.getTurbineGenerationModifier(this.getRpm()) * this.getEnergyModifier()) * (Double)CommonConfig.turbineEnergyGenerationModifier.get()) * 100.0) / 100.0f : 0.0f;
    }

    public int getTurbineHeight() {
        return this.turbineHeight;
    }

    public void setTurbineHeight(int height) {
        this.turbineHeight = height;
    }

    public BlockState getState(BlockPos pos) {
        return this.f_58857_.m_8055_(pos);
    }

    public boolean isCoilsEngaged() {
        return this.coilsEngaged;
    }

    public void setCoilsEngaged(boolean coilsEngaged) {
        this.coilsEngaged = coilsEngaged;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public boolean isAssembled() {
        return this.assembled;
    }

    public void setAssembled(boolean assembled) {
        this.assembled = assembled;
    }

    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public float getRpm() {
        return this.rpm;
    }

    public void setRpm(float rpm) {
        this.rpm = rpm;
    }

    public float getLastRpm() {
        return this.lastRpm;
    }

    public void setLastRpm(float lastRpm) {
        this.lastRpm = lastRpm;
    }

    public float getTicks() {
        return this.ticks;
    }

    public void setTicks(float ticks) {
        this.ticks = ticks;
    }

    public void setValvePos(BlockPos valvePos) {
        this.valvePos = valvePos;
    }

    public BlockPos getValvePos() {
        return this.valvePos;
    }

    public void setPowerPortPos(BlockPos powerPortPos) {
        this.powerPortPos = powerPortPos;
    }

    public BlockPos getPowerPortPos() {
        return this.powerPortPos;
    }

    public float getEnergyModifier() {
        return this.energyModifier;
    }

    public void setEnergyModifier(float energyModifier) {
        this.energyModifier = energyModifier;
    }

    public long getTurbinetime() {
        return this.turbinetime;
    }

    public void setTurbinetime(long turbinetime) {
        this.turbinetime = turbinetime;
    }

    public float getTargetFlowrate() {
        return this.targetFlowrate;
    }

    public void setTargetFlowrate(float targetFlowrate) {
        this.targetFlowrate = targetFlowrate;
    }

    public float getCurrentFlowrate() {
        return this.currentFlowrate;
    }

    public void setCurrentFlowrate(float currentFlowrate) {
        this.currentFlowrate = currentFlowrate;
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("Assembled", this.isAssembled());
        nbt.m_128379_("CoilsEngaged", this.isCoilsEngaged());
        nbt.m_128379_("Activated", this.isActivated());
        nbt.m_128405_("Height", this.getTurbineHeight());
        nbt.m_128356_("TurbineTime", this.getTurbinetime());
        nbt.m_128350_("RPM", this.getRpm());
        nbt.m_128350_("EnergyModifier", this.getEnergyModifier());
        nbt.m_128350_("LastRPM", this.getLastRpm());
        nbt.m_128350_("Rotation", this.getRotation());
        nbt.m_128350_("Ticks", this.getTicks());
        nbt.m_128350_("Flowrate", this.getTargetFlowrate());
        nbt.m_128350_("CurrentFlowrate", this.getCurrentFlowrate());
        nbt.m_128365_("ValvePos", (Tag)this.parsePosToTag(this.getValvePos()));
        nbt.m_128365_("PowerPortPos", (Tag)this.parsePosToTag(this.getPowerPortPos()));
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.setAssembled(tag.m_128471_("Assembled"));
        this.setCoilsEngaged(tag.m_128471_("CoilsEngaged"));
        this.setActivated(tag.m_128471_("Activated"));
        this.setTurbineHeight(tag.m_128451_("Height"));
        this.setTurbinetime(tag.m_128454_("TurbineTime"));
        this.setEnergyModifier(tag.m_128457_("EnergyModifier"));
        this.setRpm(tag.m_128457_("RPM"));
        this.setLastRpm(tag.m_128457_("LastRPM"));
        this.setTargetFlowrate(tag.m_128457_("Flowrate"));
        this.setCurrentFlowrate(tag.m_128457_("CurrentFlowrate"));
        this.setRotation(tag.m_128457_("Rotation"));
        this.setTicks(tag.m_128457_("Ticks"));
        this.setValvePos(BlockEntity.m_187472_((CompoundTag)tag.m_128469_("ValvePos")));
        this.setPowerPortPos(BlockEntity.m_187472_((CompoundTag)tag.m_128469_("PowerPortPos")));
    }

    public void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128379_("Assembled", this.isAssembled());
        nbt.m_128379_("CoilsEngaged", this.isCoilsEngaged());
        nbt.m_128379_("Activated", this.isActivated());
        nbt.m_128405_("Height", this.getTurbineHeight());
        nbt.m_128356_("TurbineTime", this.getTurbinetime());
        nbt.m_128350_("EnergyModifier", this.getEnergyModifier());
        nbt.m_128350_("RPM", this.getRpm());
        nbt.m_128350_("LastRPM", this.getLastRpm());
        nbt.m_128350_("Flowrate", this.getTargetFlowrate());
        nbt.m_128350_("CurrentFlowrate", this.getCurrentFlowrate());
        nbt.m_128365_("ValvePos", (Tag)this.parsePosToTag(this.getValvePos()));
        nbt.m_128365_("PowerPortPos", (Tag)this.parsePosToTag(this.getPowerPortPos()));
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        this.setAssembled(nbt.m_128471_("Assembled"));
        this.setCoilsEngaged(nbt.m_128471_("CoilsEngaged"));
        this.setActivated(nbt.m_128471_("Activated"));
        this.setTurbineHeight(nbt.m_128451_("Height"));
        this.setTurbinetime(nbt.m_128454_("TurbineTime"));
        this.setEnergyModifier(nbt.m_128457_("EnergyModifier"));
        this.setRpm(nbt.m_128457_("RPM"));
        this.setLastRpm(nbt.m_128457_("LastRPM"));
        this.setTargetFlowrate(nbt.m_128457_("Flowrate"));
        this.setCurrentFlowrate(nbt.m_128457_("CurrentFlowrate"));
        this.setValvePos(BlockEntity.m_187472_((CompoundTag)nbt.m_128469_("ValvePos")));
        this.setPowerPortPos(BlockEntity.m_187472_((CompoundTag)nbt.m_128469_("PowerPortPos")));
    }

    public CompoundTag parsePosToTag(BlockPos pos) {
        CompoundTag position = new CompoundTag();
        position.m_128405_("x", pos.m_123341_());
        position.m_128405_("y", pos.m_123342_());
        position.m_128405_("z", pos.m_123343_());
        return position;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (this.m_58904_().f_46443_ && net.getDirection() == PacketFlow.CLIENTBOUND) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_().m_7918_(-10, -10, -10), this.m_58899_().m_7918_(11, 11, 11));
    }
}

