/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.blockentity.thermal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.block.thermal.ThermalValveBlock;
import unhappycodings.thoriumreactors.common.blockentity.ModFluidTank;
import unhappycodings.thoriumreactors.common.blockentity.thermal.base.ThermalFrameBlockEntity;
import unhappycodings.thoriumreactors.common.registration.ModBlockEntities;

public class ThermalValveBlockEntity
extends ThermalFrameBlockEntity {
    public static final int MAX_FLUID_IN = 10000;
    private final ModFluidTank FLUID_TANK_IN = new ModFluidTank(10000, true, true, 0, FluidStack.EMPTY);
    private LazyOptional<FluidTank> lazyFluidInHandler = LazyOptional.empty();

    public ThermalValveBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.THERMAL_VALVE.get(), pPos, pBlockState);
    }

    public void onLoad() {
        super.onLoad();
        this.updateBlock();
        this.lazyFluidInHandler = LazyOptional.of(() -> this.FLUID_TANK_IN);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side != null && side == this.m_58900_().m_61143_((Property)ThermalValveBlock.FACING)) {
            return this.lazyFluidInHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128365_("FluidIn", (Tag)this.FLUID_TANK_IN.writeToNBT(new CompoundTag()));
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        this.FLUID_TANK_IN.readFromNBT(tag.m_128469_("FluidIn"));
        super.handleUpdateTag(tag);
    }

    @Override
    public void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128365_("FluidIn", (Tag)this.FLUID_TANK_IN.writeToNBT(new CompoundTag()));
        super.m_183515_(nbt);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        this.FLUID_TANK_IN.readFromNBT(nbt.m_128469_("FluidIn"));
        super.m_142466_(nbt);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (this.m_58904_().f_46443_ && net.getDirection() == PacketFlow.CLIENTBOUND) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void updateBlock() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 2);
            ThermalValveBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)state);
        }
    }
}

