/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.blockentity.tank;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.block.machine.MachineGeneratorBlock;
import unhappycodings.thoriumreactors.common.energy.IEnergyCapable;
import unhappycodings.thoriumreactors.common.energy.ModEnergyStorage;
import unhappycodings.thoriumreactors.common.network.PacketHandler;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ClientEnergyTankRenderDataPacket;

public class EnergyTankBlockEntity
extends BlockEntity
implements IEnergyCapable {
    public int capacity = 0;
    private final boolean isCreative;
    private LazyOptional<ModEnergyStorage> lazyEnergyHandler = LazyOptional.empty();
    private final ModEnergyStorage ENERGY_STORAGE;

    public EnergyTankBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState, int capacity) {
        super(pType, pPos, pBlockState);
        this.isCreative = capacity == -1;
        this.capacity = capacity;
        if (this.isCreative) {
            this.capacity = Integer.MAX_VALUE;
        }
        this.ENERGY_STORAGE = new ModEnergyStorage(capacity, this.capacity / 100){

            @Override
            public void onEnergyChanged() {
                EnergyTankBlockEntity.this.m_6596_();
                this.energy = this.getEnergyStored();
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY && side != null) {
            return this.lazyEnergyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyEnergyHandler = LazyOptional.of(() -> this.ENERGY_STORAGE);
    }

    public void tick() {
        if (this.isCreative) {
            boolean isAir = this.ENERGY_STORAGE.getEnergyStored() < Integer.MAX_VALUE;
            this.ENERGY_STORAGE.setEnergy(isAir ? 0 : Integer.MAX_VALUE);
        }
        this.updateRenderData();
    }

    public void updateRenderData() {
        BlockPos p = this.m_58899_();
        List players = this.f_58857_.m_45976_(ServerPlayer.class, new AABB((double)(p.m_123341_() - 18), (double)(p.m_123342_() - 18), (double)(p.m_123343_() - 18), (double)(p.m_123341_() + 18), (double)(p.m_123342_() + 18), (double)(p.m_123343_() + 18)));
        for (ServerPlayer player : players) {
            PacketHandler.sendToClient(new ClientEnergyTankRenderDataPacket(this.m_58899_(), this.getEnergy()), player);
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("Energy", this.getEnergy());
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.setEnergy(tag.m_128451_("Energy"));
    }

    public void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128405_("Energy", this.getEnergy());
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        this.setEnergy(nbt.m_128451_("Energy"));
    }

    public ModEnergyStorage getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    @Override
    public boolean canInputEnergy() {
        return false;
    }

    @Override
    public boolean canOutputEnergy(Direction direction) {
        return ((Direction)this.m_58900_().m_61143_((Property)MachineGeneratorBlock.FACING)).m_122424_() == direction;
    }

    public int getEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.ENERGY_STORAGE.setEnergy(energy);
    }

    public int getCapacity() {
        return this.ENERGY_STORAGE.getMaxEnergyStored();
    }

    @Override
    public void setCapacity(int capacity) {
    }

    @Override
    public long getEnergyStored() {
        return this.ENERGY_STORAGE.getEnergyStored();
    }

    @Override
    public long getEnergyCapacity() {
        return this.capacity;
    }

    @Override
    public long getMaxEnergyTransfer() {
        return this.capacity / 100;
    }

    @Override
    public int getEnergyDrain() {
        return 0;
    }

    @Override
    public long removeEnergy(long energy, boolean simulate) {
        return this.ENERGY_STORAGE.extractEnergy((int)energy, simulate);
    }

    @Override
    public long addEnergy(long energy, boolean simulate) {
        return this.ENERGY_STORAGE.receiveEnergy((int)energy, simulate);
    }
}

