/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.blockentity.reactor;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.block.reactor.ReactorValveBlock;
import unhappycodings.thoriumreactors.common.blockentity.ModFluidTank;
import unhappycodings.thoriumreactors.common.blockentity.reactor.base.ReactorFrameBlockEntity;
import unhappycodings.thoriumreactors.common.registration.ModBlockEntities;

public class ReactorValveBlockEntity
extends ReactorFrameBlockEntity
implements WorldlyContainer {
    public static final int MAX_FLUID_IN = 1000;
    private final ModFluidTank FLUID_TANK_IN = new ModFluidTank(1000, true, true, 0, FluidStack.EMPTY);
    private final LazyOptional<IItemHandlerModifiable>[] itemHandler = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])Direction.values());
    private LazyOptional<FluidTank> lazyFluidInHandler = LazyOptional.empty();
    public BlockPos reactorCorePosition = new BlockPos(0, 0, 0);
    public NonNullList<ItemStack> items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);

    public ReactorValveBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.REACTOR_VALVE.get(), pPos, pBlockState);
    }

    public ModFluidTank getFluidTank() {
        return this.FLUID_TANK_IN;
    }

    public FluidStack getFluidIn() {
        return this.FLUID_TANK_IN.getFluid();
    }

    public void setFluidIn(FluidStack stack) {
        this.FLUID_TANK_IN.setFluid(stack);
    }

    public int getFluidCapacityIn() {
        return this.FLUID_TANK_IN.getCapacity();
    }

    public int getFluidSpaceIn() {
        return this.FLUID_TANK_IN.getSpace();
    }

    public int getFluidAmountIn() {
        return this.FLUID_TANK_IN.getFluidAmount();
    }

    public void onLoad() {
        super.onLoad();
        this.updateBlock();
        this.lazyFluidInHandler = LazyOptional.of(() -> this.FLUID_TANK_IN);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)ReactorValveBlock.FACING);
        if (cap == ForgeCapabilities.ITEM_HANDLER && !this.m_58901_() && side != null && facing == side) {
            return this.itemHandler[side.m_122411_()].cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && side != null && side == this.m_58900_().m_61143_((Property)ReactorValveBlock.FACING)) {
            return this.lazyFluidInHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128365_("ReactorCorePosition", (Tag)this.parsePosToTag(this.getReactorCorePosition()));
        nbt.m_128365_("FluidIn", (Tag)this.FLUID_TANK_IN.writeToNBT(new CompoundTag()));
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        this.setReactorCorePosition(BlockEntity.m_187472_((CompoundTag)tag.m_128469_("ReactorCorePosition")));
        this.FLUID_TANK_IN.readFromNBT(tag.m_128469_("FluidIn"));
        super.handleUpdateTag(tag);
    }

    @Override
    public void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128365_("ReactorCorePosition", (Tag)this.parsePosToTag(this.getReactorCorePosition()));
        nbt.m_128365_("FluidIn", (Tag)this.FLUID_TANK_IN.writeToNBT(new CompoundTag()));
        ContainerHelper.m_18976_((CompoundTag)nbt, this.items, (boolean)true);
        super.m_183515_(nbt);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        this.setReactorCorePosition(BlockEntity.m_187472_((CompoundTag)nbt.m_128469_("ReactorCorePosition")));
        this.FLUID_TANK_IN.readFromNBT(nbt.m_128469_("FluidIn"));
        super.m_142466_(nbt);
    }

    @Override
    public CompoundTag parsePosToTag(BlockPos pos) {
        CompoundTag position = new CompoundTag();
        position.m_128405_("x", pos.m_123341_());
        position.m_128405_("y", pos.m_123342_());
        position.m_128405_("z", pos.m_123343_());
        return position;
    }

    public BlockPos getReactorCorePosition() {
        return this.reactorCorePosition;
    }

    public void setReactorCorePosition(BlockPos reactorCorePosition) {
        this.reactorCorePosition = reactorCorePosition;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (this.m_58904_().f_46443_ && net.getDirection() == PacketFlow.CLIENTBOUND) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void updateBlock() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 2);
            ReactorValveBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)state);
        }
    }

    public int[] m_7071_(Direction pSide) {
        return new int[1];
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return true;
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return true;
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(index);
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, @NotNull ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(Player pPlayer) {
        return false;
    }

    public void m_6211_() {
    }
}

