/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.blockentity.reactor;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.block.reactor.ReactorControllerBlock;
import unhappycodings.thoriumreactors.common.block.reactor.ReactorCoreBlock;
import unhappycodings.thoriumreactors.common.block.reactor.ReactorValveBlock;
import unhappycodings.thoriumreactors.common.blockentity.ModFluidTank;
import unhappycodings.thoriumreactors.common.blockentity.reactor.ReactorValveBlockEntity;
import unhappycodings.thoriumreactors.common.blockentity.reactor.base.ReactorFrameBlockEntity;
import unhappycodings.thoriumreactors.common.blockentity.thermal.ThermalControllerBlockEntity;
import unhappycodings.thoriumreactors.common.config.CommonConfig;
import unhappycodings.thoriumreactors.common.container.reactor.ReactorControllerContainer;
import unhappycodings.thoriumreactors.common.enums.ReactorStateEnum;
import unhappycodings.thoriumreactors.common.enums.ValveTypeEnum;
import unhappycodings.thoriumreactors.common.network.PacketHandler;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ClientReactorRenderDataPacket;
import unhappycodings.thoriumreactors.common.registration.ModBlockEntities;
import unhappycodings.thoriumreactors.common.registration.ModBlocks;
import unhappycodings.thoriumreactors.common.registration.ModDamageSources;
import unhappycodings.thoriumreactors.common.registration.ModFluids;
import unhappycodings.thoriumreactors.common.registration.ModItems;
import unhappycodings.thoriumreactors.common.registration.ModSounds;
import unhappycodings.thoriumreactors.common.util.FormattingUtil;
import unhappycodings.thoriumreactors.common.util.SoundUtil;

public class ReactorControllerBlockEntity
extends ReactorFrameBlockEntity
implements MenuProvider {
    public static final int MAX_HEAT = 1320;
    public List<BlockPos> turbinePos;
    public List<BlockPos> valvePos;
    public BlockPos thermalPos = BlockPos.f_121853_;
    public boolean assembled;
    public String notification = "";
    public boolean isReactorActive;
    public boolean isExchangerActive;
    public boolean isTurbineActive;
    public int reactorCapacity;
    long soundTicks;
    private float reactorCurrentTemperature;
    private float reactorTargetTemperature;
    private byte reactorTargetLoadSet;
    private byte reactorCurrentLoadSet;
    private long reactorRunningSince;
    private float reactorStatus = 100.0f;
    private float reactorContainment = 100.0f;
    private float reactorRadiation;
    private float reactorPressure = 29.98f;
    private int reactorHeight = 0;
    private int fuelAdditions = 0;
    private boolean scrammed;
    private ReactorStateEnum reactorState = ReactorStateEnum.STOP;
    public byte[] depletedFuelRodStatus = new byte[81];
    public byte[] fuelRodStatus = new byte[81];
    public byte[] controlRodStatus = new byte[64];
    public byte[] targetControlRodStatus = new byte[64];
    private byte turbineSpeed;
    private byte turbineTargetFlow;
    private byte turbineCurrentFlow;
    private boolean turbineCoilsEngaged;
    private boolean turbineActivated;
    private long turbinePowerGeneration;
    private final ModFluidTank FLUID_TANK_IN = new ModFluidTank(35000, true, true, 0, FluidStack.EMPTY){

        public int getCapacity() {
            return ReactorControllerBlockEntity.this.reactorCapacity / 2;
        }

        public int getSpace() {
            return super.getSpace();
        }
    };
    private final ModFluidTank FLUID_TANK_OUT = new ModFluidTank(35000, true, true, 0, FluidStack.EMPTY){

        public int getCapacity() {
            return ReactorControllerBlockEntity.this.reactorCapacity / 2;
        }

        public int getSpace() {
            return this.getCapacity() - this.getFluidAmount();
        }
    };

    public ReactorControllerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.REACTOR_CONTROLLER.get(), pPos, pBlockState);
    }

    public void onLoad() {
        super.onLoad();
        this.updateBlock();
    }

    public void tick() {
        int reactorLoad;
        if ((Boolean)this.m_58900_().m_61143_((Property)ReactorControllerBlock.POWERED) != this.assembled) {
            this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ReactorControllerBlock.POWERED, (Comparable)Boolean.valueOf(this.assembled)), 3);
        }
        if (this.isAssembled()) {
            this.tryTankReactor();
            this.tryOutputTank();
            this.tryFuelReactor();
            this.updateTemperature();
            if ((this.getFluidAmountIn() > 0 || this.getFluidAmountOut() > 0) && this.f_58857_.m_46467_() % 10L == 0L) {
                this.radiationPlayerCheck();
            }
            if (this.isScrammed()) {
                this.doScramSimulation();
            } else {
                this.updateControlRods();
            }
            if (this.getReactorState() != ReactorStateEnum.STOP) {
                this.doReactorSimulation();
            } else {
                this.setReactorActive(false);
                this.setCoreHeating(false);
            }
            this.updateRenderData();
            this.updateBlock();
            float random = new Random().nextFloat();
            if (this.getReactorPressure() < 30.2f && random < 0.5f) {
                this.setReactorPressure(this.getReactorPressure() + 1.0E-4f);
            } else if (this.getReactorPressure() > 29.7f && random > 0.5f) {
                this.setReactorPressure(this.getReactorPressure() - 1.0E-4f);
            }
        }
        if (this.f_58857_.m_46467_() % 20L == 0L && (reactorLoad = (int)((this.getReactorCurrentTemperature() - 22.0f) / 949.0f * 100.0f)) >= 105) {
            if (this.f_58857_.m_46467_() % 60L == 0L) {
                this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.ALARM_3.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
            }
            this.setReactorStatus(this.getReactorStatus() - ((float)reactorLoad - 105.0f) / 100.0f);
        }
        BlockPos corePos = this.m_58899_().m_5484_(((Direction)this.m_58900_().m_61143_((Property)ReactorControllerBlock.FACING)).m_122424_(), 2);
        if (this.getReactorState() != ReactorStateEnum.STOP) {
            if (this.soundTicks == 0L) {
                this.stopReactorSound((SoundEvent)ModSounds.REACTOR_RUN.get());
                this.stopReactorSound((SoundEvent)ModSounds.REACTOR_SHUTDOWN.get());
                this.f_58857_.m_5594_(null, corePos, (SoundEvent)ModSounds.REACTOR_STARTUP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (this.soundTicks % 92L == 0L && this.soundTicks != 0L) {
                this.f_58857_.m_5594_(null, corePos, (SoundEvent)ModSounds.REACTOR_RUN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            ++this.soundTicks;
        } else {
            if (this.soundTicks > 0L) {
                this.stopReactorSound((SoundEvent)ModSounds.REACTOR_STARTUP.get());
                this.stopReactorSound((SoundEvent)ModSounds.REACTOR_RUN.get());
                this.f_58857_.m_5594_(null, corePos, (SoundEvent)ModSounds.REACTOR_SHUTDOWN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.soundTicks = 0L;
        }
        if (this.soundTicks == 9199L) {
            this.soundTicks = 92L;
        }
    }

    public void stopReactorSound(SoundEvent type) {
        SoundUtil.stopSound(type, SoundSource.BLOCKS, this.m_58899_(), this.f_58857_);
    }

    public void scram(String text) {
        this.setScrammed(true);
        this.setNotification(text);
    }

    public void doScramSimulation() {
        this.setReactorRunningSince(-1L);
        this.setReactorActive(false);
        this.setCoreHeating(false);
        if (!((Boolean)this.m_58900_().m_61143_((Property)ReactorControllerBlock.SCRAMMED)).booleanValue()) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ReactorControllerBlock.SCRAMMED, (Comparable)Boolean.valueOf(true)));
        }
        for (byte i = 0; i < 64; i = (byte)(i + 1)) {
            this.setTargetControlRodStatus(i, (byte)this.getControlRodStatus(i));
            if ((byte)this.getControlRodStatus(i) >= 100) continue;
            this.setControlRodStatus(i, (byte)((byte)this.getControlRodStatus(i) + 1));
        }
        if (this.f_58857_.m_46467_() % 60L == 0L) {
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.ALARM_1.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
        }
        if (this.f_58857_.m_46467_() % 40L == 0L) {
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.ALARM_2.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
        }
        this.setReactorState(ReactorStateEnum.STOP);
        this.updateBlock();
    }

    public void updateControlRods() {
        for (byte i = 0; i < this.getTargetControlRodStatus().length; i = (byte)(i + 1)) {
            if (this.getControlRodStatus(i) > this.getTargetControlRodStatus(i)) {
                this.setControlRodStatus(i, (byte)(this.getControlRodStatus(i) - 1));
                continue;
            }
            if (this.getControlRodStatus(i) >= this.getTargetControlRodStatus(i)) continue;
            this.setControlRodStatus(i, (byte)(this.getControlRodStatus(i) + 1));
        }
    }

    public void doReactorSimulation() {
        if (((Boolean)this.m_58900_().m_61143_((Property)ReactorControllerBlock.SCRAMMED)).booleanValue()) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ReactorControllerBlock.SCRAMMED, (Comparable)Boolean.valueOf(false)));
        }
        this.setReactorRunningSince(this.getReactorRunningSince() + 1L);
        if (this.getFluidAmountIn() < 8000 && !this.isScrammed()) {
            this.scram(Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.text.molten_salt_low_warning")).getString());
            return;
        }
        if (!this.getNotification().isEmpty()) {
            this.setNotification("");
        }
        this.setCoreHeating(true);
        this.setReactorActive(true);
        if (this.getReactorCurrentTemperature() > 100.0f && this.getReactorState() == ReactorStateEnum.RUNNING) {
            int modifier = (int)Math.floor(this.getReactorCurrentTemperature() / 50.0f);
            int amount = (int)(this.getFluidSpaceOut() > modifier ? (double)(this.getFluidAmountIn() >= modifier ? modifier : this.getFluidAmountIn()) * (Double)CommonConfig.reactorSaltGenerationModifier.get() : (double)(this.getFluidSpaceOut() >= modifier ? modifier : this.getFluidSpaceOut()) * (Double)CommonConfig.reactorSaltGenerationModifier.get());
            if (this.FLUID_TANK_OUT.getFluid().isEmpty()) {
                this.FLUID_TANK_OUT.setFluid(new FluidStack((Fluid)ModFluids.SOURCE_HEATED_MOLTEN_SALT.get(), amount));
                this.getFluidIn().shrink(amount);
            } else if (!this.FLUID_TANK_IN.getFluid().isEmpty()) {
                this.getFluidIn().shrink(amount);
                this.getFluidOut().grow(amount);
            }
        }
        if (this.getReactorRunningSince() % 864000L == 0L) {
            int runs = 0;
            for (int i = 0; i < 810; ++i) {
                int randomNumber = new Random().nextInt(81);
                if (this.getFuelRodStatus((byte)randomNumber) > 0) {
                    this.setFuelRodStatus((byte)randomNumber, (byte)(this.getFuelRodStatus((byte)randomNumber) - 1));
                    this.setDepletedFuelRodStatus((byte)randomNumber, (byte)(this.getDepletedFuelRodStatus((byte)randomNumber) + 1));
                    ++runs;
                }
                if (runs == 10) break;
            }
        }
    }

    public void updateTemperature() {
        double random;
        int i;
        int fuelValue = 0;
        int controlValue = 0;
        for (i = 0; i < this.getFuelRodStatus().length; ++i) {
            fuelValue += this.getFuelRodStatus()[i];
        }
        for (i = 0; i < this.getControlRodStatus().length; ++i) {
            controlValue += this.getControlRodStatus()[i];
        }
        float fuelValuePercent = (float)fuelValue / 8100.0f * 100.0f;
        float controlValuePercent = 1.0f - (float)controlValue / 6400.0f;
        float targetTemperature = fuelValuePercent * controlValuePercent / 100.0f * 1320.0f * (this.reactorStatus / 20.0f - 4.0f);
        short normalTemp = (short)(this.f_58857_.m_204166_(this.m_58899_()).m_203656_(Tags.Biomes.IS_COLD) ? 4 : 22);
        this.setReactorTargetTemperature(targetTemperature < (float)normalTemp || this.getReactorState() == ReactorStateEnum.STOP ? (float)normalTemp : targetTemperature);
        if (this.getReactorCurrentTemperature() + this.calculateTemperature(false) < this.getReactorTargetTemperature()) {
            this.setReactorCurrentTemperature(this.getReactorCurrentTemperature() + this.calculateTemperature(false));
        } else if (this.getReactorCurrentTemperature() < this.getReactorTargetTemperature() || this.getReactorCurrentTemperature() > this.getReactorTargetTemperature()) {
            this.setReactorCurrentTemperature(this.getReactorCurrentTemperature() + (float)(this.getReactorCurrentTemperature() < this.getReactorTargetTemperature() ? 1 : -1));
        }
        if (this.isReactorActive() && this.getReactorCurrentTemperature() > 30.0f && (random = Math.random()) > 0.1 && this.getReactorCurrentTemperature() <= this.getReactorTargetTemperature()) {
            this.setReactorCurrentTemperature((float)((double)this.getReactorCurrentTemperature() - random * 2.0));
        }
    }

    public float calculateTemperature(boolean cooling) {
        if (this.getReactorCurrentTemperature() < 440.0f) {
            return cooling ? -1.1f : 10.0f;
        }
        if (this.getReactorCurrentTemperature() < 660.0f) {
            return cooling ? -2.1f : 5.0f;
        }
        return cooling ? -4.1f : 2.0f;
    }

    public void setCoreHeating(boolean state) {
        BlockPos p = this.m_58899_().m_5484_(((Direction)this.m_58900_().m_61143_((Property)ReactorControllerBlock.FACING)).m_122424_(), 2);
        if (this.f_58857_.m_8055_(p).m_60713_((Block)ModBlocks.REACTOR_CORE.get())) {
            this.f_58857_.m_46597_(p, (BlockState)this.f_58857_.m_8055_(p).m_61124_((Property)ReactorCoreBlock.HEATING, (Comparable)Boolean.valueOf(state)));
        }
    }

    public void setCoreFueled(boolean state) {
        BlockPos p = this.m_58899_().m_5484_(((Direction)this.m_58900_().m_61143_((Property)ReactorControllerBlock.FACING)).m_122424_(), 2);
        if (this.f_58857_.m_8055_(p).m_60713_((Block)ModBlocks.REACTOR_CORE.get())) {
            this.f_58857_.m_46597_(p, (BlockState)this.f_58857_.m_8055_(p).m_61124_((Property)ReactorCoreBlock.FUELED, (Comparable)Boolean.valueOf(state)));
        }
    }

    public void radiationPlayerCheck() {
        BlockPos p = this.m_58899_().m_5484_(((Direction)this.m_58900_().m_61143_((Property)ReactorControllerBlock.FACING)).m_122424_(), 2);
        List players = this.f_58857_.m_45976_(ServerPlayer.class, new AABB((double)(p.m_123341_() - 2), (double)(p.m_123342_() - 1), (double)(p.m_123343_() - 2), (double)(p.m_123341_() + 3), (double)(p.m_123342_() + this.getReactorHeight()), (double)(p.m_123343_() + 3)));
        for (ServerPlayer player : players) {
            player.m_6469_(this.f_58857_.m_269111_().m_269079_(ModDamageSources.OVERDOSIS), Float.MAX_VALUE);
        }
    }

    public void updateRenderData() {
        BlockPos p = this.m_58899_();
        List players = this.f_58857_.m_45976_(ServerPlayer.class, new AABB((double)(p.m_123341_() - 18), (double)(p.m_123342_() - 18), (double)(p.m_123343_() - 18), (double)(p.m_123341_() + 18), (double)(p.m_123342_() + 18), (double)(p.m_123343_() + 18)));
        for (ServerPlayer player : players) {
            PacketHandler.sendToClient(new ClientReactorRenderDataPacket(this.m_58899_(), this.getReactorHeight(), this.getFluidIn(), this.getFluidOut()), player);
        }
    }

    public void tryOutputTank() {
        if (this.valvePos != null) {
            for (BlockPos blockPos : this.valvePos) {
                if (!this.f_58857_.m_8055_(blockPos).m_60713_((Block)ModBlocks.REACTOR_VALVE.get())) {
                    return;
                }
                if (this.f_58857_.m_8055_(blockPos).m_61143_(ReactorValveBlock.TYPE) != ValveTypeEnum.FLUID_OUTPUT) continue;
                this.f_58857_.m_7702_(blockPos).getCapability(ForgeCapabilities.FLUID_HANDLER, (Direction)this.f_58857_.m_8055_(blockPos).m_61143_((Property)ReactorValveBlock.FACING)).ifPresent(storage -> {
                    if (this.getFluidOut().isEmpty()) {
                        return;
                    }
                    int free = storage.getTankCapacity(0) - storage.getFluidInTank(0).getAmount();
                    int amount = Math.min(free, this.getFluidAmountOut());
                    if (storage.getFluidInTank(0).isEmpty()) {
                        storage.fill(new FluidStack((Fluid)ModFluids.SOURCE_HEATED_MOLTEN_SALT.get(), amount), IFluidHandler.FluidAction.EXECUTE);
                        this.getFluidOut().shrink(amount);
                    } else {
                        storage.getFluidInTank(0).grow(amount);
                        this.getFluidOut().shrink(amount);
                    }
                });
            }
        }
    }

    public void tryTankReactor() {
        if (this.valvePos != null) {
            for (BlockPos blockPos : this.valvePos) {
                if (!this.f_58857_.m_8055_(blockPos).m_60713_((Block)ModBlocks.REACTOR_VALVE.get())) {
                    return;
                }
                if (this.f_58857_.m_8055_(blockPos).m_61143_(ReactorValveBlock.TYPE) != ValveTypeEnum.FLUID_INPUT) continue;
                this.f_58857_.m_7702_(blockPos).getCapability(ForgeCapabilities.FLUID_HANDLER, (Direction)this.f_58857_.m_8055_(blockPos).m_61143_((Property)ReactorValveBlock.FACING)).ifPresent(storage -> {
                    FluidStack fluidExternal = storage.getFluidInTank(0);
                    int amount = Math.min(this.FLUID_TANK_IN.getCapacity() - this.FLUID_TANK_IN.getFluidAmount(), fluidExternal.getAmount());
                    if (fluidExternal.isFluidEqual(((FlowingFluid)ModFluids.SOURCE_MOLTEN_SALT.get()).m_6859_().m_7968_()) && amount > 0) {
                        if (this.FLUID_TANK_IN.getFluid().isEmpty()) {
                            this.FLUID_TANK_IN.setFluid(new FluidStack((Fluid)ModFluids.SOURCE_MOLTEN_SALT.get(), amount));
                            storage.getFluidInTank(0).shrink(amount);
                        } else if (this.getFluidAmountIn() + amount <= this.getFluidCapacityIn()) {
                            storage.getFluidInTank(0).shrink(amount);
                            this.getFluidIn().grow(amount);
                        }
                    }
                });
            }
        }
    }

    public void tryFuelReactor() {
        if (this.valvePos != null) {
            int i;
            int fuelValue = 0;
            int depletedFuelValue = 0;
            for (i = 0; i < this.getFuelRodStatus().length; ++i) {
                fuelValue += this.getFuelRodStatus()[i];
            }
            for (i = 0; i < this.getDepletedFuelRodStatus().length; ++i) {
                depletedFuelValue += this.getDepletedFuelRodStatus()[i];
            }
            int fuelPercentage = (int)((float)fuelValue / 8100.0f * 100.0f);
            this.setCoreFueled(fuelValue > 0);
            for (BlockPos blockPos : this.valvePos) {
                if (!this.f_58857_.m_8055_(blockPos).m_60713_((Block)ModBlocks.REACTOR_VALVE.get())) {
                    return;
                }
                ReactorValveBlockEntity entity = (ReactorValveBlockEntity)this.f_58857_.m_7702_(blockPos);
                if (this.fuelAdditions == 0 && fuelValue + depletedFuelValue < 8100 && entity.m_8020_(0).m_150930_((Item)ModItems.ENRICHED_URANIUM.get()) && fuelPercentage < this.getReactorTargetLoadSet() && this.f_58857_.m_8055_(blockPos).m_61143_(ReactorValveBlock.TYPE) == ValveTypeEnum.ITEM_INPUT) {
                    entity.m_8020_(0).m_41774_(1);
                    this.fuelAdditions = 10;
                } else if (fuelPercentage >= this.getReactorTargetLoadSet() && this.f_58857_.m_8055_(blockPos).m_61143_(ReactorValveBlock.TYPE) == ValveTypeEnum.ITEM_OUTPUT && this.fuelAdditions == 10) {
                    if (entity.m_8020_(0).m_41619_()) {
                        entity.m_6836_(0, new ItemStack((ItemLike)ModItems.ENRICHED_URANIUM.get(), 1));
                    } else {
                        entity.m_8020_(0).m_41769_(1);
                    }
                    this.fuelAdditions = 0;
                }
                if (this.f_58857_.m_8055_(blockPos).m_61143_(ReactorValveBlock.TYPE) != ValveTypeEnum.ITEM_OUTPUT || depletedFuelValue < 10 || (!entity.m_8020_(0).m_150930_((Item)ModItems.DEPLETED_URANIUM.get()) || entity.m_8020_(0).m_41613_() >= entity.m_8020_(0).m_41741_()) && !entity.m_8020_(0).m_41619_()) continue;
                int runs = 0;
                for (int i2 = 0; i2 < 810; ++i2) {
                    int randomNumber = new Random().nextInt(81);
                    if (this.getDepletedFuelRodStatus((byte)randomNumber) > 0) {
                        this.setDepletedFuelRodStatus((byte)randomNumber, (byte)(this.getDepletedFuelRodStatus((byte)randomNumber) - 1));
                        ++runs;
                    }
                    if (runs == 10) break;
                }
                if (entity.m_8020_(0).m_41619_()) {
                    entity.m_6836_(0, new ItemStack((ItemLike)ModItems.DEPLETED_URANIUM.get(), 1));
                    continue;
                }
                entity.m_8020_(0).m_41769_(1);
            }
            int randomNumber = new Random().nextInt(81);
            if (this.fuelAdditions != 0 && this.getFuelRodStatus((byte)randomNumber) < this.getReactorTargetLoadSet() && this.getDepletedFuelRodStatus((byte)randomNumber) + this.getFuelRodStatus((byte)randomNumber) < 100) {
                this.setFuelRodStatus((byte)randomNumber, (byte)(this.getFuelRodStatus((byte)randomNumber) + 1));
                --this.fuelAdditions;
            }
            if (fuelPercentage >= this.getReactorTargetLoadSet() && this.getFuelRodStatus((byte)randomNumber) > this.getReactorTargetLoadSet() && this.fuelAdditions < 20) {
                this.setFuelRodStatus((byte)randomNumber, (byte)(this.getFuelRodStatus((byte)randomNumber) - 1));
                ++this.fuelAdditions;
            }
        }
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_().m_7918_(-10, -10, -10), this.m_58899_().m_7918_(11, 11, 11));
    }

    public int getReactorCapacity() {
        return this.reactorCapacity;
    }

    public void setReactorCapacity(int reactorCapacity) {
        this.reactorCapacity = reactorCapacity;
    }

    public boolean isReactorActive() {
        return this.isReactorActive;
    }

    public void setReactorActive(boolean reactorActive) {
        this.isReactorActive = reactorActive;
    }

    public boolean isTurbineActive() {
        return this.isTurbineActive;
    }

    public void setTurbineActive(boolean turbineActive) {
        this.isTurbineActive = turbineActive;
    }

    public boolean isExchangerActive() {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.thermalPos);
        if (blockEntity instanceof ThermalControllerBlockEntity) {
            ThermalControllerBlockEntity entity = (ThermalControllerBlockEntity)blockEntity;
            return entity.getConversions() > 3;
        }
        return false;
    }

    public void setExchangerActive(boolean exchangerActive) {
        this.isExchangerActive = exchangerActive;
    }

    public String getNotification() {
        return this.notification;
    }

    public void setNotification(String notification) {
        this.notification = notification;
    }

    public FluidStack getFluidIn() {
        return this.FLUID_TANK_IN.getFluid();
    }

    public int getReactorHeight() {
        return this.reactorHeight;
    }

    public void setReactorHeight(int height) {
        this.reactorHeight = height;
    }

    public void setFluidIn(FluidStack stack) {
        this.FLUID_TANK_IN.setFluid(stack);
    }

    public int getFluidCapacityIn() {
        return this.FLUID_TANK_IN.getCapacity();
    }

    public int getFluidSpaceIn() {
        return this.FLUID_TANK_IN.getSpace();
    }

    public int getFluidAmountIn() {
        return this.FLUID_TANK_IN.getFluidAmount();
    }

    public FluidStack getFluidOut() {
        return this.FLUID_TANK_OUT.getFluid();
    }

    public void setFluidOut(FluidStack stack) {
        this.FLUID_TANK_OUT.setFluid(stack);
    }

    public int getFluidCapacityOut() {
        return this.FLUID_TANK_OUT.getCapacity();
    }

    public int getFluidSpaceOut() {
        return this.FLUID_TANK_OUT.getSpace();
    }

    public int getFluidAmountOut() {
        return this.FLUID_TANK_OUT.getFluidAmount();
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        int i;
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("Assembled", this.isAssembled());
        nbt.m_128350_("ReactorTargetTemperature", this.getReactorTargetTemperature());
        nbt.m_128350_("ReactorCurrentTemperature", this.getReactorCurrentTemperature());
        nbt.m_128344_("ReactorTargetLoadSet", this.getReactorTargetLoadSet());
        nbt.m_128344_("ReactorCurrentLoadSet", this.getReactorCurrentLoadSet());
        nbt.m_128356_("ReactorRunningSince", this.getReactorRunningSince());
        nbt.m_128350_("ReactorStatus", this.getReactorStatus());
        nbt.m_128350_("ReactorContainment", this.getReactorContainment());
        nbt.m_128350_("ReactorRadiation", this.getReactorRadiation());
        nbt.m_128350_("ReactorPressure", this.getReactorPressure());
        nbt.m_128405_("FuelAdditions", this.getFuelAdditions());
        nbt.m_128379_("Scrammed", this.isScrammed());
        nbt.m_128359_("ReactorState", this.getReactorState().toString());
        nbt.m_128365_("FluidIn", (Tag)this.FLUID_TANK_IN.writeToNBT(new CompoundTag()));
        nbt.m_128365_("FluidOut", (Tag)this.FLUID_TANK_OUT.writeToNBT(new CompoundTag()));
        nbt.m_128405_("ReactorCapacity", this.reactorCapacity);
        nbt.m_128405_("ReactorHeight", this.reactorHeight);
        nbt.m_128356_("SoundTicks", this.soundTicks);
        nbt.m_128382_("DepletedFuelRodStatus", this.getDepletedFuelRodStatus());
        nbt.m_128382_("FuelRodStatus", this.getFuelRodStatus());
        nbt.m_128382_("ControlRodStatus", this.getControlRodStatus());
        nbt.m_128382_("TargetControlRodStatus", this.getTargetControlRodStatus());
        nbt.m_128365_("ThermalPos", (Tag)this.parsePosToTag(this.thermalPos));
        for (i = 0; i < 4; ++i) {
            if (this.valvePos == null || this.valvePos.size() - 1 < i) continue;
            nbt.m_128365_("ValvePos-" + i, (Tag)this.parsePosToTag(this.valvePos.get(i)));
        }
        for (i = 0; i < 9; ++i) {
            if (this.turbinePos == null || this.turbinePos.size() - 1 < i) continue;
            nbt.m_128365_("TurbinePos-" + i, (Tag)this.parsePosToTag(this.turbinePos.get(i)));
        }
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        int i;
        this.setAssembled(tag.m_128471_("Assembled"));
        this.setReactorTargetTemperature(tag.m_128457_("ReactorTargetTemperature"));
        this.setReactorCurrentTemperature(tag.m_128457_("ReactorCurrentTemperature"));
        this.setReactorTargetLoadSet(tag.m_128445_("ReactorTargetLoadSet"));
        this.setReactorCurrentLoadSet(tag.m_128445_("ReactorCurrentLoadSet"));
        this.setReactorRunningSince(tag.m_128454_("ReactorRunningSince"));
        this.setReactorStatus(tag.m_128457_("ReactorStatus"));
        this.setReactorContainment(tag.m_128457_("ReactorContainment"));
        this.setReactorRadiation(tag.m_128457_("ReactorRadiation"));
        this.setReactorPressure(tag.m_128457_("ReactorPressure"));
        this.setFuelAdditions(tag.m_128451_("FuelAdditions"));
        this.setScrammed(tag.m_128471_("Scrammed"));
        this.setReactorState(ReactorStateEnum.get(tag.m_128461_("ReactorState")));
        this.FLUID_TANK_IN.readFromNBT(tag.m_128469_("FluidIn"));
        this.FLUID_TANK_OUT.readFromNBT(tag.m_128469_("FluidOut"));
        this.reactorCapacity = tag.m_128451_("ReactorCapacity");
        this.reactorHeight = tag.m_128451_("ReactorHeight");
        this.soundTicks = tag.m_128454_("SoundTicks");
        this.setDepletedFuelRodStatus(tag.m_128463_("DepletedFuelRodStatus"));
        this.setFuelRodStatus(tag.m_128463_("FuelRodStatus"));
        this.setControlRodStatus(tag.m_128463_("ControlRodStatus"));
        this.setTargetControlRodStatus(tag.m_128463_("TargetControlRodStatus"));
        this.valvePos = new ArrayList<BlockPos>(4);
        this.turbinePos = new ArrayList<BlockPos>(9);
        this.thermalPos = BlockEntity.m_187472_((CompoundTag)tag.m_128469_("ThermalPos"));
        for (i = 0; i < 4; ++i) {
            if (!tag.m_128441_("ValvePos-" + i)) continue;
            this.valvePos.add(BlockEntity.m_187472_((CompoundTag)tag.m_128469_("ValvePos-" + i)));
        }
        for (i = 0; i < 9; ++i) {
            if (!tag.m_128441_("TurbinePos-" + i)) continue;
            this.turbinePos.add(BlockEntity.m_187472_((CompoundTag)tag.m_128469_("TurbinePos-" + i)));
        }
    }

    @Override
    public void m_183515_(@NotNull CompoundTag nbt) {
        int i;
        nbt.m_128379_("Assembled", this.isAssembled());
        nbt.m_128350_("ReactorTargetTemperature", this.getReactorTargetTemperature());
        nbt.m_128350_("ReactorCurrentTemperature", this.getReactorCurrentTemperature());
        nbt.m_128344_("ReactorTargetLoadSet", this.getReactorTargetLoadSet());
        nbt.m_128344_("ReactorCurrentLoadSet", this.getReactorCurrentLoadSet());
        nbt.m_128356_("ReactorRunningSince", this.getReactorRunningSince());
        nbt.m_128350_("ReactorStatus", this.getReactorStatus());
        nbt.m_128350_("ReactorContainment", this.getReactorContainment());
        nbt.m_128350_("ReactorRadiation", this.getReactorRadiation());
        nbt.m_128350_("ReactorPressure", this.getReactorPressure());
        nbt.m_128405_("FuelAdditions", this.getFuelAdditions());
        nbt.m_128379_("Scrammed", this.isScrammed());
        nbt.m_128359_("ReactorState", this.getReactorState().toString());
        nbt.m_128365_("FluidIn", (Tag)this.FLUID_TANK_IN.writeToNBT(new CompoundTag()));
        nbt.m_128365_("FluidOut", (Tag)this.FLUID_TANK_OUT.writeToNBT(new CompoundTag()));
        nbt.m_128405_("ReactorCapacity", this.reactorCapacity);
        nbt.m_128405_("ReactorHeight", this.reactorHeight);
        nbt.m_128356_("SoundTicks", this.soundTicks);
        nbt.m_128382_("DepletedFuelRodStatus", this.getDepletedFuelRodStatus());
        nbt.m_128382_("FuelRodStatus", this.getFuelRodStatus());
        nbt.m_128382_("ControlRodStatus", this.getControlRodStatus());
        nbt.m_128382_("TargetControlRodStatus", this.getTargetControlRodStatus());
        nbt.m_128365_("ThermalPos", (Tag)this.parsePosToTag(this.thermalPos));
        for (i = 0; i < 4; ++i) {
            if (this.valvePos == null || this.valvePos.size() - 1 < i) continue;
            nbt.m_128365_("ValvePos-" + i, (Tag)this.parsePosToTag(this.valvePos.get(i)));
        }
        for (i = 0; i < 9; ++i) {
            if (this.turbinePos == null || this.turbinePos.size() - 1 < i) continue;
            nbt.m_128365_("TurbinePos-" + i, (Tag)this.parsePosToTag(this.turbinePos.get(i)));
        }
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        int i;
        this.setAssembled(nbt.m_128471_("Assembled"));
        this.setReactorTargetTemperature(nbt.m_128448_("ReactorTargetTemperature"));
        this.setReactorCurrentTemperature(nbt.m_128448_("ReactorCurrentTemperature"));
        this.setReactorTargetLoadSet(nbt.m_128445_("ReactorTargetLoadSet"));
        this.setReactorCurrentLoadSet(nbt.m_128445_("ReactorCurrentLoadSet"));
        this.setReactorRunningSince(nbt.m_128454_("ReactorRunningSince"));
        this.setReactorStatus(nbt.m_128457_("ReactorStatus"));
        this.setReactorContainment(nbt.m_128457_("ReactorContainment"));
        this.setReactorRadiation(nbt.m_128457_("ReactorRadiation"));
        this.setReactorPressure(nbt.m_128457_("ReactorPressure"));
        this.setFuelAdditions(nbt.m_128451_("FuelAdditions"));
        this.setScrammed(nbt.m_128471_("Scrammed"));
        this.setReactorState(ReactorStateEnum.get(nbt.m_128461_("ReactorState")));
        this.FLUID_TANK_IN.readFromNBT(nbt.m_128469_("FluidIn"));
        this.FLUID_TANK_OUT.readFromNBT(nbt.m_128469_("FluidOut"));
        this.reactorCapacity = nbt.m_128451_("ReactorCapacity");
        this.reactorHeight = nbt.m_128451_("ReactorHeight");
        this.soundTicks = nbt.m_128454_("SoundTicks");
        this.setDepletedFuelRodStatus(nbt.m_128463_("DepletedFuelRodStatus"));
        this.setFuelRodStatus(nbt.m_128463_("FuelRodStatus"));
        this.setControlRodStatus(nbt.m_128463_("ControlRodStatus"));
        this.setTargetControlRodStatus(nbt.m_128463_("TargetControlRodStatus"));
        this.valvePos = new ArrayList<BlockPos>(4);
        this.turbinePos = new ArrayList<BlockPos>(9);
        this.thermalPos = BlockEntity.m_187472_((CompoundTag)nbt.m_128469_("ThermalPos"));
        for (i = 0; i < 4; ++i) {
            if (!nbt.m_128441_("ValvePos-" + i)) continue;
            this.valvePos.add(BlockEntity.m_187472_((CompoundTag)nbt.m_128469_("ValvePos-" + i)));
        }
        for (i = 0; i < 9; ++i) {
            if (!nbt.m_128441_("TurbinePos-" + i)) continue;
            this.turbinePos.add(BlockEntity.m_187472_((CompoundTag)nbt.m_128469_("TurbinePos-" + i)));
        }
    }

    public void setThermalPos(BlockPos thermalPos) {
        this.thermalPos = thermalPos;
    }

    public BlockPos getThermalPos() {
        return this.thermalPos;
    }

    public void setTurbinePos(List<BlockPos> turbinePos) {
        this.turbinePos = turbinePos;
    }

    public List<BlockPos> getTurbinePos() {
        return this.turbinePos;
    }

    public void addTurbinePos(BlockPos pos) {
        if (this.turbinePos == null) {
            this.turbinePos = new ArrayList<BlockPos>(9);
        }
        if (this.turbinePos.size() < 9) {
            this.turbinePos.add(pos);
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (this.m_58904_().f_46443_ && net.getDirection() == PacketFlow.CLIENTBOUND) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"block.thoriumreactors.reactor_controller");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, @NotNull Inventory pInventory, @NotNull Player pPlayer) {
        return new ReactorControllerContainer(pContainerId, pInventory, this.m_58899_(), this.m_58904_(), 0);
    }

    public void setFuelAdditions(int fuelAdditions) {
        this.fuelAdditions = fuelAdditions;
    }

    public int getFuelAdditions() {
        return this.fuelAdditions;
    }

    public boolean isScrammed() {
        return this.scrammed;
    }

    public void setScrammed(boolean scrammed) {
        this.scrammed = scrammed;
    }

    public void updateBlock() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 2);
            ReactorControllerBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)state);
        }
    }

    public byte[] getDepletedFuelRodStatus() {
        return this.depletedFuelRodStatus;
    }

    public byte getDepletedFuelRodStatus(byte index) {
        if (this.getDepletedFuelRodStatus().length == 0) {
            return 0;
        }
        return this.getDepletedFuelRodStatus()[index];
    }

    public void setDepletedFuelRodStatus(byte[] depletedFuelRodStatus) {
        this.depletedFuelRodStatus = depletedFuelRodStatus;
    }

    public void setDepletedFuelRodStatus(byte index, byte value) {
        this.getDepletedFuelRodStatus()[index] = value;
        this.m_6596_();
    }

    public byte[] getFuelRodStatus() {
        return this.fuelRodStatus;
    }

    public byte getFuelRodStatus(byte index) {
        if (this.getFuelRodStatus().length == 0) {
            return 0;
        }
        return this.getFuelRodStatus()[index];
    }

    public void setFuelRodStatus(byte[] fuelRodStatus) {
        this.fuelRodStatus = fuelRodStatus;
        this.m_6596_();
    }

    public void setFuelRodStatus(byte index, byte value) {
        this.getFuelRodStatus()[index] = value;
        this.m_6596_();
    }

    public byte[] getControlRodStatus() {
        return this.controlRodStatus;
    }

    public int getControlRodStatus(byte index) {
        if (this.getControlRodStatus().length == 0) {
            return 0;
        }
        return this.getControlRodStatus()[index];
    }

    public void setControlRodStatus(byte[] controlRodStatus) {
        this.controlRodStatus = controlRodStatus;
    }

    public void setControlRodStatus(byte index, byte value) {
        this.getControlRodStatus()[index] = value;
    }

    public void setTargetControlRodStatus(byte index, byte value) {
        this.getTargetControlRodStatus()[index] = value;
    }

    public byte getTargetControlRodStatus(byte index) {
        return this.targetControlRodStatus[index];
    }

    public void setTargetControlRodStatus(byte[] targetControlRodStatus) {
        this.targetControlRodStatus = targetControlRodStatus;
    }

    public byte[] getTargetControlRodStatus() {
        return this.targetControlRodStatus;
    }

    public BlockState getState(BlockPos pos) {
        return this.f_58857_.m_8055_(pos);
    }

    public boolean isAssembled() {
        return this.assembled;
    }

    public void setAssembled(boolean canBeAssembled) {
        this.assembled = canBeAssembled;
    }

    public float getReactorCurrentTemperature() {
        return this.reactorCurrentTemperature;
    }

    public void setReactorCurrentTemperature(float reactorCurrentTemperature) {
        this.reactorCurrentTemperature = reactorCurrentTemperature;
    }

    public float getReactorTargetTemperature() {
        return this.reactorTargetTemperature;
    }

    public void setReactorTargetTemperature(float reactorTargetTemperature) {
        this.reactorTargetTemperature = reactorTargetTemperature;
    }

    public byte getReactorTargetLoadSet() {
        return this.reactorTargetLoadSet;
    }

    public void setReactorTargetLoadSet(byte reactorTargetLoadSet) {
        this.reactorTargetLoadSet = reactorTargetLoadSet;
    }

    public byte getReactorCurrentLoadSet() {
        return this.reactorCurrentLoadSet;
    }

    public void setReactorCurrentLoadSet(byte reactorCurrentLoadSet) {
        this.reactorCurrentLoadSet = reactorCurrentLoadSet;
    }

    public long getReactorRunningSince() {
        return this.reactorRunningSince;
    }

    public void setReactorRunningSince(long reactorRunningSince) {
        this.reactorRunningSince = reactorRunningSince;
    }

    public float getReactorStatus() {
        return this.reactorStatus;
    }

    public void setReactorStatus(float reactorStatus) {
        this.reactorStatus = reactorStatus;
    }

    public float getReactorContainment() {
        return this.reactorContainment;
    }

    public void setReactorContainment(float reactorContainment) {
        this.reactorContainment = reactorContainment;
    }

    public float getReactorRadiation() {
        return this.reactorRadiation;
    }

    public void setReactorRadiation(float reactorRadiation) {
        this.reactorRadiation = reactorRadiation;
    }

    public float getReactorPressure() {
        return this.reactorPressure;
    }

    public void setReactorPressure(float reactorPressure) {
        this.reactorPressure = reactorPressure;
    }

    public ReactorStateEnum getReactorState() {
        return this.reactorState;
    }

    public void setReactorState(ReactorStateEnum reactorState) {
        this.reactorState = reactorState;
    }

    public boolean isTurbineActivated() {
        return this.turbineActivated;
    }

    public void setTurbineActivated(boolean turbineActivated) {
        this.turbineActivated = turbineActivated;
    }

    public boolean isTurbineCoilsEngaged() {
        return this.turbineCoilsEngaged;
    }

    public void setTurbineCoilsEngaged(boolean turbineCoilsEngaged) {
        this.turbineCoilsEngaged = turbineCoilsEngaged;
    }

    public byte getTurbineTargetFlow() {
        return this.turbineTargetFlow;
    }

    public void setTurbineTargetFlow(byte turbineTargetFlow) {
        this.turbineTargetFlow = turbineTargetFlow;
    }

    public byte getTurbineSpeed() {
        return this.turbineSpeed;
    }

    public void setTurbineSpeed(byte turbineSpeed) {
        this.turbineSpeed = turbineSpeed;
    }

    public byte getTurbineCurrentFlow() {
        return this.turbineCurrentFlow;
    }

    public void setTurbineCurrentFlow(byte turbineCurrentFlow) {
        this.turbineCurrentFlow = turbineCurrentFlow;
    }

    public long getTurbinePowerGeneration() {
        return this.turbinePowerGeneration;
    }

    public void setTurbinePowerGeneration(long turbinePowerGeneration) {
        this.turbinePowerGeneration = turbinePowerGeneration;
    }
}

