/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.blockentity.machine;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.block.machine.MachineFluidEnricherBlock;
import unhappycodings.thoriumreactors.common.blockentity.ModFluidTank;
import unhappycodings.thoriumreactors.common.blockentity.base.MachineContainerBlockEntity;
import unhappycodings.thoriumreactors.common.container.machine.MachineFluidEnricherContainer;
import unhappycodings.thoriumreactors.common.energy.IEnergyCapable;
import unhappycodings.thoriumreactors.common.energy.ModEnergyStorage;
import unhappycodings.thoriumreactors.common.recipe.FluidEnrichingRecipe;
import unhappycodings.thoriumreactors.common.registration.ModBlockEntities;
import unhappycodings.thoriumreactors.common.registration.ModRecipes;
import unhappycodings.thoriumreactors.common.registration.ModSounds;
import unhappycodings.thoriumreactors.common.util.EnergyUtil;

public class MachineFluidEnricherBlockEntity
extends MachineContainerBlockEntity
implements WorldlyContainer,
MenuProvider,
IEnergyCapable {
    public static final int MAX_POWER = 100000;
    public static final int MAX_TRANSFER = 50000;
    public static final int MAX_FLUID_IN = 6000;
    public static final int MAX_FLUID_OUT = 10000;
    public static final int MAX_FLUID_TRANSFER = 100;
    public static final int NEEDED_ENERGY = 54;
    private LazyOptional<ModEnergyStorage> lazyEnergyHandler = LazyOptional.empty();
    private LazyOptional<FluidTank> lazyFluidInHandler = LazyOptional.empty();
    private LazyOptional<FluidTank> lazyFluidOutHandler = LazyOptional.empty();
    private final LazyOptional<? extends IItemHandler>[] itemHandler = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])Direction.values());
    private final ModFluidTank FLUID_TANK_IN = new ModFluidTank(6000, true, false, 0, FluidStack.EMPTY);
    private final ModFluidTank FLUID_TANK_OUT = new ModFluidTank(10000, false, true, -1, FluidStack.EMPTY);
    public FluidStack inputFluid = FluidStack.EMPTY;
    public FluidStack outputFluid = FluidStack.EMPTY;
    public NonNullList<ItemStack> items;
    int operationAfterTicks = 0;
    int recipeTime = 0;
    int maxRecipeTime = 0;
    boolean inputDump;
    boolean outputDump;
    boolean powerable = true;
    int redstoneMode = 0;
    int recipeDefinedTicks;
    private final ModEnergyStorage ENERGY_STORAGE = new ModEnergyStorage(100000, 50000){

        @Override
        public void onEnergyChanged() {
            MachineFluidEnricherBlockEntity.this.m_6596_();
            this.energy = MachineFluidEnricherBlockEntity.this.ENERGY_STORAGE.getEnergyStored();
        }
    };

    public MachineFluidEnricherBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.FLUID_ENRICHER_BLOCK.get(), pPos, pBlockState);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyEnergyHandler = LazyOptional.of(() -> this.ENERGY_STORAGE);
        this.lazyFluidInHandler = LazyOptional.of(() -> this.FLUID_TANK_IN);
        this.lazyFluidOutHandler = LazyOptional.of(() -> this.FLUID_TANK_OUT);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)MachineFluidEnricherBlock.FACING);
        if (cap == ForgeCapabilities.ENERGY && this.supportsEnergy() && side != null && ((Direction)this.m_58900_().m_61143_((Property)MachineFluidEnricherBlock.FACING)).m_122424_() == side) {
            return this.lazyEnergyHandler.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && side != null) {
            if (facing.m_122428_() == side) {
                return this.lazyFluidOutHandler.cast();
            }
            if (facing.m_122427_() == side) {
                return this.lazyFluidInHandler.cast();
            }
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER && !this.m_58901_() && side != null) {
            if (side == Direction.DOWN) {
                return this.itemHandler[side.m_122411_()].cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean canInputEnergy() {
        return true;
    }

    @Override
    public boolean canInputEnergy(Direction direction) {
        return ((Direction)this.m_58900_().m_61143_((Property)MachineFluidEnricherBlock.FACING)).m_122424_() == direction;
    }

    @Override
    public boolean canOutputEnergy() {
        return false;
    }

    @Override
    public boolean canOutputEnergy(Direction direction) {
        return false;
    }

    public void tick() {
        if (this.getState() && this.getRecipeTime() % 20 == 0) {
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.MACHINE_URANIUM_OXIDIZER.get(), SoundSource.BLOCKS, 0.3f, 1.1f);
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.MACHINE_CRYSTALIZER.get(), SoundSource.BLOCKS, 0.3f, 0.9f);
        }
        ((ItemStack)this.items.get(1)).getCapability(ForgeCapabilities.ENERGY).ifPresent(storage -> EnergyUtil.tryDischargeItem(storage, this.ENERGY_STORAGE, this.getMaxInput()));
        if (this.isPowerable() && this.isSpaceAbove()) {
            switch (this.getRedstoneMode()) {
                case 0: {
                    this.operate();
                    break;
                }
                case 1: {
                    if (this.f_58857_.m_276867_(this.m_58899_())) {
                        this.operate();
                        break;
                    }
                    if (!this.getState()) break;
                    this.setState(false);
                    break;
                }
                case 2: {
                    if (!this.f_58857_.m_276867_(this.m_58899_())) {
                        this.operate();
                        break;
                    }
                    if (!this.getState()) break;
                    this.setState(false);
                }
            }
        } else if (this.getState()) {
            this.setState(false);
        }
    }

    public void operate() {
        if (this.hasRecipeNeeds(this.getNeededEnergy())) {
            if (this.getMaxRecipeTime() == 0) {
                this.setMaxRecipeTime(this.getRecipeDefinedTicks());
                this.setRecipeTime(this.getRecipeDefinedTicks());
                this.m_8020_(0).m_41774_(1);
                if (!this.getState()) {
                    this.setState(true);
                }
            }
            if (this.getRecipeTime() > 0 && this.getMaxRecipeTime() > 0 && this.getEnergy() - this.getNeededEnergy() >= 0 && this.getFluidAmountIn() >= this.getFluidAmountNeeded() && this.getFluidAmountOut() + this.getFluidAmountNeeded() <= this.getFluidCapacityOut()) {
                if (!this.getState()) {
                    this.setState(true);
                }
                this.setEnergy(this.getEnergy() - this.getNeededEnergy());
                if (this.getOperationAfterTicks() != 0 && this.getRecipeTime() % this.getOperationAfterTicks() == 0) {
                    this.getFluidIn().shrink(this.getFluidAmountNeeded());
                    if (this.getFluidOut().isEmpty()) {
                        this.setFluidOut(new FluidStack(this.getOutputFluid(), 0));
                    }
                    this.getFluidOut().grow(this.getFluidAmountNeeded());
                }
                this.setRecipeTime(this.getRecipeTime() - 1);
                if (this.getRecipeTime() == 0) {
                    this.setInputFluid(FluidStack.EMPTY);
                    this.setOutputFluid(FluidStack.EMPTY);
                    this.setMaxRecipeTime(0);
                    this.setRecipeDefinedTicks(0);
                    this.setOperationAfterTicks(0);
                }
                if (this.isOutputDump() && this.getFluidAmountOut() > 0) {
                    this.getFluidOut().shrink(this.getFluidAmountOut() - 100 < 100 ? this.getFluidAmountOut() : 100);
                }
                if (this.isInputDump() && this.getFluidAmountIn() > 0) {
                    this.getFluidIn().shrink(this.getFluidAmountIn() - 100 < 100 ? this.getFluidAmountIn() : 100);
                }
            } else if (this.getState()) {
                this.setState(false);
            }
        } else {
            if (this.getState()) {
                this.setState(false);
            }
            if (this.m_8020_(0).m_41619_()) {
                this.setMaxRecipeTime(0);
                this.setRecipeTime(0);
            }
        }
    }

    public boolean hasRecipeNeeds(int energy) {
        if (energy > this.getEnergy()) {
            return false;
        }
        SimpleContainer container = new SimpleContainer(new ItemStack[]{this.m_8020_(0).m_41777_()});
        List recipe = this.f_58857_.m_7465_().m_44013_((RecipeType)ModRecipes.FLUID_ENRICHING_RECIPE_TYPE.get());
        for (FluidEnrichingRecipe decomposingRecipe : recipe) {
            if (decomposingRecipe.matchesAll(container, this.getFluidIn(), this.getFluidOut(), this.m_58904_()) && this.recipeTime == 0 && this.maxRecipeTime == 0) {
                this.setRecipeDefinedTicks(decomposingRecipe.getTicks());
                this.setInputFluid(decomposingRecipe.getFluidIngredient());
                this.setOutputFluid(decomposingRecipe.getResultFluid());
                this.setOperationAfterTicks(decomposingRecipe.getOperationAfterTicks());
                return true;
            }
            if (this.recipeTime == 0 || this.maxRecipeTime == 0 || !decomposingRecipe.matchesFluid(this.getFluidIn(), this.getFluidOut())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getState() {
        return (Boolean)this.m_58900_().m_61143_((Property)MachineFluidEnricherBlock.POWERED);
    }

    public void setState(boolean state) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)MachineFluidEnricherBlock.POWERED, (Comparable)Boolean.valueOf(state)), 3);
    }

    @Override
    public int getFluidAmountNeeded() {
        return this.inputFluid.getAmount();
    }

    public int getFluidProductionAmount() {
        return this.outputFluid.getAmount();
    }

    @Override
    public FluidStack getFluidIn() {
        return this.FLUID_TANK_IN.getFluid();
    }

    @Override
    public void setFluidIn(FluidStack stack) {
        this.FLUID_TANK_IN.setFluid(stack);
    }

    @Override
    public int getFluidCapacityIn() {
        return this.FLUID_TANK_IN.getCapacity();
    }

    @Override
    public int getFluidSpaceIn() {
        return this.FLUID_TANK_IN.getSpace();
    }

    @Override
    public int getFluidAmountIn() {
        return this.FLUID_TANK_IN.getFluidAmount();
    }

    @Override
    public FluidStack getFluidOut() {
        return this.FLUID_TANK_OUT.getFluid();
    }

    @Override
    public void setFluidOut(FluidStack stack) {
        this.FLUID_TANK_OUT.setFluid(stack);
    }

    @Override
    public int getFluidCapacityOut() {
        return this.FLUID_TANK_OUT.getCapacity();
    }

    @Override
    public int getFluidSpaceOut() {
        return this.FLUID_TANK_OUT.getSpace();
    }

    @Override
    public int getFluidAmountOut() {
        return this.FLUID_TANK_OUT.getFluidAmount();
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void setRedstoneMode(int redstoneMode) {
        this.redstoneMode = redstoneMode;
    }

    @Override
    public boolean isPowerable() {
        return this.powerable;
    }

    @Override
    public void setPowerable(boolean powerable) {
        this.powerable = powerable;
    }

    @Override
    public int getNeededEnergy() {
        return 54;
    }

    public int getRecipeTime() {
        return this.recipeTime;
    }

    public void setRecipeTime(int recipeTime) {
        this.recipeTime = recipeTime;
    }

    public int getMaxRecipeTime() {
        return this.maxRecipeTime;
    }

    public void setMaxRecipeTime(int maxRecipeTime) {
        this.maxRecipeTime = maxRecipeTime;
    }

    public int getMaxFluidOut() {
        return 10000;
    }

    @Override
    public int getEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.ENERGY_STORAGE.setEnergy(energy);
    }

    @Override
    public int getCapacity() {
        return this.ENERGY_STORAGE.getMaxEnergyStored();
    }

    @Override
    public void setCapacity(int capacity) {
    }

    public int getMaxInput() {
        return 50000;
    }

    public boolean supportsEnergy() {
        return this.getEnergyCapacity() > 0L;
    }

    @Override
    public boolean isInputDump() {
        return this.inputDump;
    }

    @Override
    public void setInputDump(boolean inputDump) {
        this.inputDump = inputDump;
    }

    @Override
    public boolean isOutputDump() {
        return this.outputDump;
    }

    @Override
    public void setOutputDump(boolean outputDump) {
        this.outputDump = outputDump;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public void setInputFluid(FluidStack inputFluid) {
        this.inputFluid = inputFluid;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    public void setOperationAfterTicks(int operationAfterTicks) {
        this.operationAfterTicks = operationAfterTicks;
    }

    public int getOperationAfterTicks() {
        return this.operationAfterTicks;
    }

    public void setOutputFluid(FluidStack outputFluid) {
        this.outputFluid = outputFluid;
    }

    public void setRecipeDefinedTicks(int recipeDefinedTicks) {
        this.recipeDefinedTicks = recipeDefinedTicks;
    }

    public int getRecipeDefinedTicks() {
        return this.recipeDefinedTicks;
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (this.m_58904_().f_46443_ && net.getDirection() == PacketFlow.CLIENTBOUND) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    @Override
    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("Energy", this.getEnergy());
        nbt.m_128405_("RecipeTime", this.getRecipeTime());
        nbt.m_128405_("MaxRecipeTime", this.getMaxRecipeTime());
        nbt.m_128405_("RedstoneMode", this.getRedstoneMode());
        nbt.m_128405_("OperationAfterTicks", this.getOperationAfterTicks());
        nbt.m_128379_("InputDump", this.isInputDump());
        nbt.m_128379_("OutputDump", this.isOutputDump());
        nbt.m_128379_("Powerable", this.isPowerable());
        nbt.m_128365_("FluidIn", (Tag)this.FLUID_TANK_IN.writeToNBT(new CompoundTag()));
        nbt.m_128365_("FluidOut", (Tag)this.FLUID_TANK_OUT.writeToNBT(new CompoundTag()));
        nbt.m_128365_("InputFluid", (Tag)this.getInputFluid().writeToNBT(new CompoundTag()));
        nbt.m_128365_("OutputFluid", (Tag)this.getOutputFluid().writeToNBT(new CompoundTag()));
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.setEnergy(tag.m_128451_("Energy"));
        this.setRecipeTime(tag.m_128451_("RecipeTime"));
        this.setMaxRecipeTime(tag.m_128451_("MaxRecipeTime"));
        this.setRedstoneMode(tag.m_128451_("RedstoneMode"));
        this.setOperationAfterTicks(tag.m_128451_("OperationAfterTicks"));
        this.setInputDump(tag.m_128471_("InputDump"));
        this.setOutputDump(tag.m_128471_("OutputDump"));
        this.setPowerable(tag.m_128471_("Powerable"));
        this.FLUID_TANK_IN.readFromNBT(tag.m_128469_("FluidIn"));
        this.FLUID_TANK_OUT.readFromNBT(tag.m_128469_("FluidOut"));
        this.setInputFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("InputFluid")));
        this.setOutputFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("OutputFluid")));
    }

    public void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128405_("Energy", this.getEnergy());
        nbt.m_128405_("RecipeTime", this.getRecipeTime());
        nbt.m_128405_("MaxRecipeTime", this.getMaxRecipeTime());
        nbt.m_128405_("RedstoneMode", this.getRedstoneMode());
        nbt.m_128405_("OperationAfterTicks", this.getOperationAfterTicks());
        nbt.m_128379_("InputDump", this.isInputDump());
        nbt.m_128379_("OutputDump", this.isOutputDump());
        nbt.m_128379_("Powerable", this.isPowerable());
        nbt.m_128365_("FluidIn", (Tag)this.FLUID_TANK_IN.writeToNBT(new CompoundTag()));
        nbt.m_128365_("FluidOut", (Tag)this.FLUID_TANK_OUT.writeToNBT(new CompoundTag()));
        nbt.m_128365_("InputFluid", (Tag)this.getInputFluid().writeToNBT(new CompoundTag()));
        nbt.m_128365_("OutputFluid", (Tag)this.getOutputFluid().writeToNBT(new CompoundTag()));
        ContainerHelper.m_18976_((CompoundTag)nbt, this.items, (boolean)true);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        this.setEnergy(nbt.m_128451_("Energy"));
        this.setRecipeTime(nbt.m_128451_("RecipeTime"));
        this.setMaxRecipeTime(nbt.m_128451_("MaxRecipeTime"));
        this.setRedstoneMode(nbt.m_128451_("RedstoneMode"));
        this.setOperationAfterTicks(nbt.m_128451_("OperationAfterTicks"));
        this.setInputDump(nbt.m_128471_("InputDump"));
        this.setOutputDump(nbt.m_128471_("OutputDump"));
        this.setPowerable(nbt.m_128471_("Powerable"));
        this.FLUID_TANK_IN.readFromNBT(nbt.m_128469_("FluidIn"));
        this.FLUID_TANK_OUT.readFromNBT(nbt.m_128469_("FluidOut"));
        this.setInputFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("InputFluid")));
        this.setOutputFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("OutputFluid")));
    }

    @Override
    protected Component m_6820_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Override
    @NotNull
    protected AbstractContainerMenu m_6555_(int pContainerId, @NotNull Inventory pInventory) {
        return new MachineFluidEnricherContainer(pContainerId, pInventory, this.m_58899_(), this.m_58904_(), this.m_6643_());
    }

    @Override
    public int m_6643_() {
        return 4;
    }

    @Override
    public boolean m_7983_() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public ItemStack m_8020_(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(index);
    }

    @Override
    @NotNull
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    @Override
    @NotNull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    @Override
    public void m_6836_(int index, @NotNull ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    @Override
    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    @Override
    public void m_6211_() {
        this.items.clear();
    }

    @Override
    public long getEnergyStored() {
        return this.ENERGY_STORAGE.getEnergyStored();
    }

    @Override
    public long getEnergyCapacity() {
        return 100000L;
    }

    @Override
    public long getMaxEnergyTransfer() {
        return 50000L;
    }

    @Override
    public int getEnergyDrain() {
        return 0;
    }

    @Override
    public long removeEnergy(long energy, boolean simulate) {
        return this.ENERGY_STORAGE.extractEnergy((int)energy, simulate);
    }

    @Override
    public long addEnergy(long energy, boolean simulate) {
        return this.ENERGY_STORAGE.receiveEnergy((int)energy, simulate);
    }

    public int[] m_7071_(Direction pSide) {
        if (pSide == Direction.DOWN) {
            return new int[]{0};
        }
        return new int[0];
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return pDirection == Direction.DOWN;
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return false;
    }
}

