/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.block.turbine;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.client.config.ClientConfig;
import unhappycodings.thoriumreactors.common.block.turbine.TurbineRotorBlock;
import unhappycodings.thoriumreactors.common.blockentity.turbine.TurbineControllerBlockEntity;
import unhappycodings.thoriumreactors.common.blockentity.turbine.base.TurbineFrameBlockEntity;
import unhappycodings.thoriumreactors.common.enums.ParticleTypeEnum;
import unhappycodings.thoriumreactors.common.multiblock.TurbineMultiblocks;
import unhappycodings.thoriumreactors.common.network.PacketHandler;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ClientReactorParticleDataPacket;
import unhappycodings.thoriumreactors.common.registration.ModBlocks;
import unhappycodings.thoriumreactors.common.registration.ModKeyBindings;
import unhappycodings.thoriumreactors.common.util.AdvancementUtil;
import unhappycodings.thoriumreactors.common.util.CalculationUtil;
import unhappycodings.thoriumreactors.common.util.FormattingUtil;
import unhappycodings.thoriumreactors.common.util.KeyBindingUtil;

public class TurbineControllerBlock
extends BaseEntityBlock {
    private static final float NICKEL_MODIFIER = 1.0f;
    private static final float NIOB_MODIFIER = 1.5f;
    private static final float MOLYBDENUM_MODIFIER = 2.0f;
    private static final float NICKEL_BLOCK_VALUE = 0.125f;
    private static final float NIOB_BLOCK_VALUE = 0.1875f;
    private static final float MOLYBDENUM_BLOCK_VALUE = 0.25f;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public TurbineControllerBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(5.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, POWERED});
    }

    public void m_5871_(@NotNull ItemStack pStack, @Nullable BlockGetter pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        if (KeyBindingUtil.isKeyPressed(ModKeyBindings.SHOW_DESCRIPTION) && ((Boolean)ClientConfig.showBlockDescription.get()).booleanValue()) {
            pTooltip.add((Component)Component.m_237115_((String)(this.m_7374_().m_7705_() + "_description")).m_130940_(ChatFormatting.GRAY));
        } else if (((Boolean)ClientConfig.showBlockDescription.get()).booleanValue()) {
            pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.hold")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)ModKeyBindings.SHOW_DESCRIPTION.getKey().m_84875_().getString()).m_130948_(FormattingUtil.hex(5624714))).m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.for_description")).m_130940_(ChatFormatting.GRAY)));
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockPos rotorPos = pos.m_5484_(((Direction)state.m_61143_((Property)FACING)).m_122424_(), 2);
        for (int i = 0; i < 9; ++i) {
            BlockPos loopPos = rotorPos.m_5484_(Direction.UP, i);
            BlockState loopState = level.m_8055_(loopPos);
            if (!loopState.m_60713_((Block)ModBlocks.TURBINE_ROTOR.get())) continue;
            level.m_46597_(loopPos, (BlockState)loopState.m_61124_((Property)TurbineRotorBlock.RENDERING, (Comparable)Boolean.valueOf(false)));
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level levelIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hitResult) {
        TurbineControllerBlockEntity entity = (TurbineControllerBlockEntity)levelIn.m_7702_(pos);
        if (player.m_9236_().f_46443_ || interactionHand == InteractionHand.OFF_HAND) {
            return InteractionResult.SUCCESS;
        }
        if (!entity.isAssembled()) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            int turbineSize = 0;
            boolean canBeAssembled = false;
            for (int i = 8; i >= 5; --i) {
                List<Block> turbineBlocks = CalculationUtil.getBlocks(pos.m_5484_(facing.m_122427_(), 2).m_5484_(Direction.DOWN, 1), pos.m_5484_(facing.m_122428_(), 2).m_5484_(facing.m_122424_(), 4).m_5484_(Direction.UP, i), levelIn);
                if (!TurbineMultiblocks.isTurbine(TurbineMultiblocks.getTurbineFromSize(i), turbineBlocks)) continue;
                canBeAssembled = true;
                turbineSize = i;
                break;
            }
            if (entity.isAssembled() != canBeAssembled) {
                List<BlockPos> turbinePositions = CalculationUtil.getBlockPositions(pos.m_5484_(facing.m_122427_(), 2).m_5484_(Direction.DOWN, 1), pos.m_5484_(facing.m_122428_(), 2).m_5484_(facing.m_122424_(), 4).m_5484_(Direction.UP, turbineSize), levelIn);
                int turbineCount = 0;
                for (BlockPos turbinePosition : turbinePositions) {
                    BlockEntity blockEntity;
                    BlockState blockState = levelIn.m_8055_(turbinePosition);
                    if (blockState.m_60713_((Block)ModBlocks.TURBINE_ROTOR.get())) {
                        if ((Integer)blockState.m_61143_((Property)TurbineRotorBlock.BLADES) != 8 && turbineCount >= 2) {
                            return InteractionResult.FAIL;
                        }
                        levelIn.m_46597_(turbinePosition, (BlockState)blockState.m_61124_((Property)TurbineRotorBlock.RENDERING, (Comparable)Boolean.valueOf(true)));
                        ++turbineCount;
                    }
                    if (blockState.m_60713_((Block)ModBlocks.TURBINE_VALVE.get())) {
                        entity.setValvePos(turbinePosition);
                    }
                    if (blockState.m_60713_((Block)ModBlocks.TURBINE_POWER_PORT.get())) {
                        entity.setPowerPortPos(turbinePosition);
                    }
                    if (!((blockEntity = levelIn.m_7702_(turbinePosition)) instanceof TurbineFrameBlockEntity)) continue;
                    TurbineFrameBlockEntity turbineFrameBlock = (TurbineFrameBlockEntity)blockEntity;
                    turbineFrameBlock.setControllerPos(pos);
                }
                entity.setAssembled(canBeAssembled);
                levelIn.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(canBeAssembled)));
                for (Player curPlayer : levelIn.m_6907_()) {
                    PacketHandler.sendToClient(new ClientReactorParticleDataPacket(this.addParticleOffset(pos, (Direction)state.m_61143_((Property)FACING)), ParticleTypeEnum.TURBINE, 5L, 9L, 5L), (ServerPlayer)curPlayer);
                }
                entity.setTurbineHeight(turbineSize + 1);
                List<Block> turbineBlocks = CalculationUtil.getBlocks(pos.m_5484_(facing.m_122427_(), 2).m_5484_(Direction.DOWN, 1), pos.m_5484_(facing.m_122428_(), 2).m_5484_(facing.m_122424_(), 4).m_5484_(Direction.UP, turbineSize), levelIn);
                List<Block> moderatorBlocks = TurbineMultiblocks.getTurbineModeratorBLocks(TurbineMultiblocks.getTurbineFromSize(turbineSize), turbineBlocks);
                float moderatorModifier = 0.0f;
                for (Block moderatorBlock : moderatorBlocks) {
                    if (((BlockState)moderatorBlock.m_49965_().m_61090_()).m_60713_((Block)ModBlocks.NICKEL_BLOCK.get())) {
                        moderatorModifier += 0.125f;
                        continue;
                    }
                    if (((BlockState)moderatorBlock.m_49965_().m_61090_()).m_60713_((Block)ModBlocks.NIOB_BLOCK.get())) {
                        moderatorModifier += 0.1875f;
                        continue;
                    }
                    if (!((BlockState)moderatorBlock.m_49965_().m_61090_()).m_60713_((Block)ModBlocks.MOLYBDENUM_BLOCK.get())) continue;
                    moderatorModifier += 0.25f;
                }
                entity.setEnergyModifier(moderatorModifier);
                if (!levelIn.f_46443_) {
                    AdvancementUtil.awardAdvancement((ServerLevel)levelIn, (ServerPlayer)player, "turbine_assembled", "impossible");
                }
            }
        } else {
            entity.setAssembled(false);
            entity.setCoilsEngaged(false);
            entity.setActivated(false);
            levelIn.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        }
        return InteractionResult.CONSUME;
    }

    public BlockPos addParticleOffset(BlockPos pos, Direction direction) {
        return switch (direction) {
            case Direction.WEST -> pos.m_7918_(0, -1, -2);
            case Direction.EAST -> pos.m_7918_(-4, -1, -2);
            case Direction.SOUTH -> pos.m_7918_(-2, -1, -4);
            default -> pos.m_7918_(-2, -1, 0);
        };
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new TurbineControllerBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> type) {
        if (level.f_46443_ || !((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
            return null;
        }
        return (a, b, c, blockEntity) -> ((TurbineControllerBlockEntity)blockEntity).tick();
    }
}

