/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.block.reactor;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.block.reactor.base.ReactorFrameBlock;
import unhappycodings.thoriumreactors.common.block.thermal.ThermalControllerBlock;
import unhappycodings.thoriumreactors.common.blockentity.reactor.ReactorControllerBlockEntity;
import unhappycodings.thoriumreactors.common.blockentity.reactor.base.ReactorFrameBlockEntity;
import unhappycodings.thoriumreactors.common.enums.ParticleTypeEnum;
import unhappycodings.thoriumreactors.common.multiblock.ReactorMultiblocks;
import unhappycodings.thoriumreactors.common.network.PacketHandler;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ClientReactorParticleDataPacket;
import unhappycodings.thoriumreactors.common.registration.ModBlocks;
import unhappycodings.thoriumreactors.common.util.AdvancementUtil;
import unhappycodings.thoriumreactors.common.util.CalculationUtil;

public class ReactorControllerBlock
extends ReactorFrameBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty SCRAMMED = BooleanProperty.m_61465_((String)"scrammed");

    public ReactorControllerBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(5.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SCRAMMED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SCRAMMED, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, POWERED, SCRAMMED});
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level levelIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hitResult) {
        ReactorControllerBlockEntity entity = (ReactorControllerBlockEntity)levelIn.m_7702_(pos);
        if (player.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!entity.isAssembled()) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            boolean canBeAssembled = false;
            int height = 1;
            for (int i = 4; i <= 6; ++i) {
                List<Block> reactorBlocks = CalculationUtil.getBlocks(pos.m_5484_(facing.m_122427_(), 2).m_5484_(Direction.DOWN, 1), pos.m_5484_(facing.m_122428_(), 2).m_5484_(facing.m_122424_(), 4).m_5484_(Direction.UP, i - 2), levelIn);
                if (!ReactorMultiblocks.isReactor(ReactorMultiblocks.getReactorFromHeight(i), reactorBlocks)) continue;
                canBeAssembled = true;
                height = i - 1;
            }
            if (entity.isAssembled() != canBeAssembled) {
                entity.valvePos = new ArrayList<BlockPos>(4);
                List<BlockPos> reactorPositions = CalculationUtil.getBlockPositions(pos.m_5484_(facing.m_122427_(), 2).m_5484_(Direction.DOWN, 1), pos.m_5484_(facing.m_122428_(), 2).m_5484_(facing.m_122424_(), 4).m_5484_(Direction.UP, 4), levelIn);
                for (BlockPos reactorPosition : reactorPositions) {
                    BlockEntity blockEntity = levelIn.m_7702_(reactorPosition);
                    if (blockEntity instanceof ReactorFrameBlockEntity) {
                        ReactorFrameBlockEntity reactorFrameBlockEntity = (ReactorFrameBlockEntity)blockEntity;
                        reactorFrameBlockEntity.setControllerPos(pos);
                    }
                    if (!levelIn.m_8055_(reactorPosition).m_60713_((Block)ModBlocks.REACTOR_VALVE.get())) continue;
                    entity.valvePos.add(reactorPosition);
                }
                if (entity.valvePos.size() != 4) {
                    return InteractionResult.CONSUME;
                }
                entity.setAssembled(canBeAssembled);
                entity.setReactorHeight(height);
                entity.setReactorCapacity(9 * (entity.getReactorHeight() - 1) * 1000 - 1000);
                levelIn.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(canBeAssembled)));
                long x = facing == Direction.WEST || facing == Direction.EAST ? 3L : 5L;
                long y = 3L;
                if (x == 3L) {
                    y = 5L;
                }
                for (Player loopPlayer : levelIn.m_6907_()) {
                    PacketHandler.sendToClient(new ClientReactorParticleDataPacket(this.addParticleOffset(pos, (Direction)state.m_61143_((Property)FACING)), ParticleTypeEnum.REACTOR, x, height, y), (ServerPlayer)loopPlayer);
                }
                if (!levelIn.f_46443_) {
                    AdvancementUtil.awardAdvancement((ServerLevel)levelIn, (ServerPlayer)player, "reactor_assembled", "impossible");
                }
            }
        } else {
            MenuProvider namedContainerProvider = this.m_7246_(state, levelIn, pos);
            if (namedContainerProvider != null) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayerEntity = (ServerPlayer)player;
                    NetworkHooks.openScreen((ServerPlayer)serverPlayerEntity, (MenuProvider)namedContainerProvider, (BlockPos)pos);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, levelIn, pos, player, interactionHand, hitResult);
    }

    public BlockPos addParticleOffset(BlockPos pos, Direction direction) {
        return switch (direction) {
            case Direction.WEST -> pos.m_7918_(0, -1, -2);
            case Direction.EAST -> pos.m_7918_(-2, -1, -2);
            case Direction.SOUTH -> pos.m_7918_(-2, -1, -2);
            default -> pos.m_7918_(-2, -1, 0);
        };
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ReactorControllerBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> type) {
        if (level.f_46443_ || !((Boolean)blockState.m_61143_((Property)ThermalControllerBlock.POWERED)).booleanValue()) {
            return null;
        }
        return (a, b, c, blockEntity) -> ((ReactorControllerBlockEntity)blockEntity).tick();
    }
}

