/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.block.chest;

import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.client.config.ClientConfig;
import unhappycodings.thoriumreactors.common.blockentity.chest.SteelChestBlockEntity;
import unhappycodings.thoriumreactors.common.registration.ModBlockEntities;
import unhappycodings.thoriumreactors.common.registration.ModKeyBindings;
import unhappycodings.thoriumreactors.common.util.FormattingUtil;
import unhappycodings.thoriumreactors.common.util.KeyBindingUtil;
import unhappycodings.thoriumreactors.common.util.LootUtil;

public class SteelChestBlock
extends BaseEntityBlock {
    protected static final VoxelShape AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public SteelChestBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public List<ItemStack> m_49635_(@NotNull BlockState pState, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder pParams) {
        return Collections.singletonList(LootUtil.getLoot((BlockEntity)pParams.m_287261_(LootContextParams.f_81462_), (Block)this));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return LootUtil.getLoot(level.m_7702_(pos), (Block)this);
    }

    public void m_5871_(@NotNull ItemStack pStack, @Nullable BlockGetter pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        CompoundTag tag = pStack.m_41784_().m_128469_("BlockEntityTag");
        if (KeyBindingUtil.isKeyPressed(ModKeyBindings.SHOW_DETAILS) && ((Boolean)ClientConfig.showBlockDetails.get()).booleanValue()) {
            ListTag listtag = tag.m_128437_("Items", 10);
            if (!listtag.isEmpty()) {
                pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.contains_items")).m_130940_(ChatFormatting.GRAY));
            }
        } else if (KeyBindingUtil.isKeyPressed(ModKeyBindings.SHOW_DESCRIPTION) && ((Boolean)ClientConfig.showBlockDescription.get()).booleanValue()) {
            pTooltip.add((Component)Component.m_237115_((String)(this.m_7374_().m_7705_() + "_description")).m_130940_(ChatFormatting.GRAY));
        } else {
            if (((Boolean)ClientConfig.showBlockDetails.get()).booleanValue()) {
                pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.hold")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)ModKeyBindings.SHOW_DETAILS.getKey().m_84875_().getString()).m_130948_(FormattingUtil.hex(8311637))).m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.for_details")).m_130940_(ChatFormatting.GRAY)));
            }
            if (((Boolean)ClientConfig.showBlockDescription.get()).booleanValue()) {
                pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.hold")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)ModKeyBindings.SHOW_DESCRIPTION.getKey().m_84875_().getString()).m_130948_(FormattingUtil.hex(5624714))).m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.for_description")).m_130940_(ChatFormatting.GRAY)));
            }
        }
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level levelIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hitResult) {
        MenuProvider namedContainerProvider = this.m_7246_(state, levelIn, pos);
        if (namedContainerProvider != null) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayerEntity, (MenuProvider)namedContainerProvider, (BlockPos)pos);
            }
            PiglinAi.m_34873_((Player)player, (boolean)true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, levelIn, pos, player, interactionHand, hitResult);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return AABB;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)ModBlockEntities.STEEL_CHEST_BLOCK.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel instanceof ServerLevel ? null : (a, b, c, blockEntity) -> ((SteelChestBlockEntity)blockEntity).tick();
    }
}

