/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.client.integration.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import unhappycodings.thoriumreactors.client.integration.jei.JEIModIntegration;
import unhappycodings.thoriumreactors.common.recipe.SaltSmeltingRecipe;
import unhappycodings.thoriumreactors.common.registration.ModBlocks;
import unhappycodings.thoriumreactors.common.util.ScreenUtil;

public class SmeltingRecipeCategory
implements IRecipeCategory<SaltSmeltingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("thoriumreactors", "smelting");
    public static final ResourceLocation TEXTURE = new ResourceLocation("thoriumreactors", "textures/gui/gui_jei_second.png");
    public static final ResourceLocation TEXTURE_ONE = new ResourceLocation("thoriumreactors", "textures/gui/gui_jei.png");
    private final IGuiHelper helper;
    private final IDrawable background;
    private final IDrawable icon;
    private IDrawable heating;

    public SmeltingRecipeCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(TEXTURE, 102, 0, 122, 68).addPadding(this.getGuiTop(), this.getGuiBottom(), this.getGuiLeft(), this.getGuiRight()).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.SALT_MELTER_BLOCK.get()));
        this.helper = helper;
    }

    @NotNull
    public List<Component> getTooltipStrings(@NotNull SaltSmeltingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (ScreenUtil.mouseInArea(this.getGuiLeft() + 23, this.getGuiTop() + 26, this.getGuiLeft() + 38, this.getGuiTop() + 41, (int)mouseX, (int)mouseY)) {
            list.add((Component)Component.m_237113_((String)(recipe.getTemperature() + "\u00b0C")));
        }
        return list;
    }

    public void draw(@NotNull SaltSmeltingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics graphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, graphics, mouseX, mouseY);
        if (this.heating == null) {
            this.heating = this.helper.createAnimatedDrawable(this.helper.createDrawable(TEXTURE_ONE, 240, 231, 16, 16), 80, IDrawableAnimated.StartDirection.BOTTOM, false);
        }
        this.heating.draw(graphics, this.getGuiLeft() + 23, this.getGuiTop() + 26);
        ScreenUtil.drawCenteredText("Salt Melting", graphics, this.getBackground().getWidth() / 2, 6, false);
        ScreenUtil.drawCenteredText(recipe.getTicks() / 20 + "s ", graphics, this.getBackground().getWidth() / 2, this.getGuiTop() + 60, false);
    }

    public int getGuiTop() {
        return 20;
    }

    public int getGuiBottom() {
        return 10;
    }

    public int getGuiLeft() {
        return 10;
    }

    public int getGuiRight() {
        return 30;
    }

    @NotNull
    public RecipeType<SaltSmeltingRecipe> getRecipeType() {
        return JEIModIntegration.SMELTING_RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"block.thoriumreactors.salt_melter_block");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SaltSmeltingRecipe recipe, @NotNull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, this.getGuiLeft() + 23, this.getGuiTop() + 51).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, this.getGuiLeft() + 1, this.getGuiTop() + 26).addIngredients((Ingredient)recipe.m_7527_().get(1));
        builder.addSlot(RecipeIngredientRole.INPUT, this.getGuiLeft() + 23, this.getGuiTop() + 1).addIngredients((Ingredient)recipe.m_7527_().get(2));
        builder.addSlot(RecipeIngredientRole.OUTPUT, this.getGuiLeft() + 103, this.getGuiTop() + 1).setFluidRenderer((long)recipe.getResultFluid().getAmount(), true, 18, 66).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(new FluidStack(recipe.getResultFluid(), (int)(Math.floor((float)recipe.getTicks() / (float)recipe.getOperationAfterTicks()) * (double)recipe.getResultFluid().getAmount()))));
    }
}

