/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.client.integration.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.LavaFluid;
import net.minecraft.world.level.material.WaterFluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import unhappycodings.thoriumreactors.client.config.ClientConfig;
import unhappycodings.thoriumreactors.client.integration.jei.BlastingRecipeCategory;
import unhappycodings.thoriumreactors.client.integration.jei.CentrifugingRecipeCategory;
import unhappycodings.thoriumreactors.client.integration.jei.ConcentratingRecipeCategory;
import unhappycodings.thoriumreactors.client.integration.jei.CrystallizingRecipeCategory;
import unhappycodings.thoriumreactors.client.integration.jei.DecomposingRecipeCategory;
import unhappycodings.thoriumreactors.client.integration.jei.ElectrolysingRecipeCategory;
import unhappycodings.thoriumreactors.client.integration.jei.EvaporatingRecipeCategory;
import unhappycodings.thoriumreactors.client.integration.jei.FluidEnrichingRecipeCategory;
import unhappycodings.thoriumreactors.client.integration.jei.OxidizingRecipeCategory;
import unhappycodings.thoriumreactors.client.integration.jei.SmeltingRecipeCategory;
import unhappycodings.thoriumreactors.client.integration.jei.ThoriumCraftingRecipeCategory;
import unhappycodings.thoriumreactors.common.block.ThoriumCraftingTableBlock;
import unhappycodings.thoriumreactors.common.block.machine.MachineBlastFurnaceBlock;
import unhappycodings.thoriumreactors.common.block.machine.MachineConcentratorBlock;
import unhappycodings.thoriumreactors.common.block.machine.MachineCrystallizerBlock;
import unhappycodings.thoriumreactors.common.block.machine.MachineDecomposerBlock;
import unhappycodings.thoriumreactors.common.block.machine.MachineElectrolyticSaltSeparatorBlock;
import unhappycodings.thoriumreactors.common.block.machine.MachineFluidCentrifugeBlock;
import unhappycodings.thoriumreactors.common.block.machine.MachineFluidEnricherBlock;
import unhappycodings.thoriumreactors.common.block.machine.MachineFluidEvaporationBlock;
import unhappycodings.thoriumreactors.common.block.machine.MachineSaltMelterBlock;
import unhappycodings.thoriumreactors.common.block.machine.MachineUraniumOxidizerBlock;
import unhappycodings.thoriumreactors.common.block.tank.EnergyTankBlock;
import unhappycodings.thoriumreactors.common.block.tank.FluidTankBlock;
import unhappycodings.thoriumreactors.common.container.ThoriumCraftingTableContainer;
import unhappycodings.thoriumreactors.common.container.ThoriumCraftingTableScreen;
import unhappycodings.thoriumreactors.common.container.machine.MachineBlastFurnaceContainer;
import unhappycodings.thoriumreactors.common.container.machine.MachineBlastFurnaceScreen;
import unhappycodings.thoriumreactors.common.container.machine.MachineConcentratorContainer;
import unhappycodings.thoriumreactors.common.container.machine.MachineConcentratorScreen;
import unhappycodings.thoriumreactors.common.container.machine.MachineCrystallizerScreen;
import unhappycodings.thoriumreactors.common.container.machine.MachineDecomposerContainer;
import unhappycodings.thoriumreactors.common.container.machine.MachineDecomposerScreen;
import unhappycodings.thoriumreactors.common.container.machine.MachineElectrolyticSaltSeparatorScreen;
import unhappycodings.thoriumreactors.common.container.machine.MachineFluidCentrifugeScreen;
import unhappycodings.thoriumreactors.common.container.machine.MachineFluidEnricherContainer;
import unhappycodings.thoriumreactors.common.container.machine.MachineFluidEnricherScreen;
import unhappycodings.thoriumreactors.common.container.machine.MachineFluidEvaporatorScreen;
import unhappycodings.thoriumreactors.common.container.machine.MachineSaltMelterContainer;
import unhappycodings.thoriumreactors.common.container.machine.MachineSaltMelterScreen;
import unhappycodings.thoriumreactors.common.container.machine.MachineUraniumOxidizerContainer;
import unhappycodings.thoriumreactors.common.container.machine.MachineUraniumOxidizerScreen;
import unhappycodings.thoriumreactors.common.container.reactor.ReactorControllerScreen;
import unhappycodings.thoriumreactors.common.recipe.BlastingRecipe;
import unhappycodings.thoriumreactors.common.recipe.CentrifugingRecipe;
import unhappycodings.thoriumreactors.common.recipe.ConcentratingRecipe;
import unhappycodings.thoriumreactors.common.recipe.CrystallizingRecipe;
import unhappycodings.thoriumreactors.common.recipe.DecomposingRecipe;
import unhappycodings.thoriumreactors.common.recipe.ElectrolysingRecipe;
import unhappycodings.thoriumreactors.common.recipe.EvaporatingRecipe;
import unhappycodings.thoriumreactors.common.recipe.FluidEnrichingRecipe;
import unhappycodings.thoriumreactors.common.recipe.OxidizingRecipe;
import unhappycodings.thoriumreactors.common.recipe.SaltSmeltingRecipe;
import unhappycodings.thoriumreactors.common.recipe.ThoriumCraftingRecipe;
import unhappycodings.thoriumreactors.common.registration.ModBlocks;
import unhappycodings.thoriumreactors.common.registration.ModContainerTypes;
import unhappycodings.thoriumreactors.common.registration.ModRecipes;

@JeiPlugin
public class JEIModIntegration
implements IModPlugin {
    public static final RecipeType<ThoriumCraftingRecipe> THORIUM_RECIPE_TYPE = new RecipeType(ThoriumCraftingRecipeCategory.UID, ThoriumCraftingRecipe.class);
    public static final RecipeType<ConcentratingRecipe> CONCENTRATING_RECIPE_TYPE = new RecipeType(ConcentratingRecipeCategory.UID, ConcentratingRecipe.class);
    public static final RecipeType<BlastingRecipe> BLASTING_RECIPE_TYPE = new RecipeType(BlastingRecipeCategory.UID, BlastingRecipe.class);
    public static final RecipeType<DecomposingRecipe> DECOMPOSING_RECIPE_TYPE = new RecipeType(DecomposingRecipeCategory.UID, DecomposingRecipe.class);
    public static final RecipeType<OxidizingRecipe> OXIDIZING_RECIPE_TYPE = new RecipeType(OxidizingRecipeCategory.UID, OxidizingRecipe.class);
    public static final RecipeType<FluidEnrichingRecipe> FLUID_ENRICHING_RECIPE_TYPE = new RecipeType(FluidEnrichingRecipeCategory.UID, FluidEnrichingRecipe.class);
    public static final RecipeType<CentrifugingRecipe> CENTRIFUGING_RECIPE_TYPE = new RecipeType(CentrifugingRecipeCategory.UID, CentrifugingRecipe.class);
    public static final RecipeType<CrystallizingRecipe> CRYSTALLIZING_RECIPE_TYPE = new RecipeType(CrystallizingRecipeCategory.UID, CrystallizingRecipe.class);
    public static final RecipeType<ElectrolysingRecipe> ELECTROLYSING_RECIPE_TYPE = new RecipeType(ElectrolysingRecipeCategory.UID, ElectrolysingRecipe.class);
    public static final RecipeType<SaltSmeltingRecipe> SMELTING_RECIPE_TYPE = new RecipeType(SmeltingRecipeCategory.UID, SaltSmeltingRecipe.class);
    public static final RecipeType<EvaporatingRecipe> EVAPORATING_RECIPE_TYPE = new RecipeType(EvaporatingRecipeCategory.UID, EvaporatingRecipe.class);
    public static final int SLOT_DEFAULT = 0;
    public static final int SLOT_DECOMPOSER = 1;
    public static final int PLAYER_INVENTORY_COUNT = 36;

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("thoriumreactors", "jei_plugin");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((ThoriumCraftingTableBlock)((Object)ModBlocks.THORIUM_CRAFTING_TABLE.get())).m_5456_().m_7968_(), new RecipeType[]{THORIUM_RECIPE_TYPE});
        registration.addRecipeCatalyst(((MachineConcentratorBlock)((Object)ModBlocks.CONCENTRATOR_BLOCK.get())).m_5456_().m_7968_(), new RecipeType[]{CONCENTRATING_RECIPE_TYPE});
        registration.addRecipeCatalyst(((MachineBlastFurnaceBlock)((Object)ModBlocks.BLAST_FURNACE_BLOCK.get())).m_5456_().m_7968_(), new RecipeType[]{BLASTING_RECIPE_TYPE});
        registration.addRecipeCatalyst(((MachineDecomposerBlock)((Object)ModBlocks.DECOMPOSER_BLOCK.get())).m_5456_().m_7968_(), new RecipeType[]{DECOMPOSING_RECIPE_TYPE});
        registration.addRecipeCatalyst(((MachineUraniumOxidizerBlock)((Object)ModBlocks.URANIUM_OXIDIZER_BLOCK.get())).m_5456_().m_7968_(), new RecipeType[]{OXIDIZING_RECIPE_TYPE});
        registration.addRecipeCatalyst(((MachineFluidEnricherBlock)((Object)ModBlocks.FLUID_ENRICHER_BLOCK.get())).m_5456_().m_7968_(), new RecipeType[]{FLUID_ENRICHING_RECIPE_TYPE});
        registration.addRecipeCatalyst(((MachineFluidCentrifugeBlock)((Object)ModBlocks.FLUID_CENTRIFUGE_BLOCK.get())).m_5456_().m_7968_(), new RecipeType[]{CENTRIFUGING_RECIPE_TYPE});
        registration.addRecipeCatalyst(((MachineCrystallizerBlock)((Object)ModBlocks.CRYSTALLIZER_BLOCK.get())).m_5456_().m_7968_(), new RecipeType[]{CRYSTALLIZING_RECIPE_TYPE});
        registration.addRecipeCatalyst(((MachineElectrolyticSaltSeparatorBlock)((Object)ModBlocks.ELECTROLYTIC_SALT_SEPARATOR_BLOCK.get())).m_5456_().m_7968_(), new RecipeType[]{ELECTROLYSING_RECIPE_TYPE});
        registration.addRecipeCatalyst(((MachineSaltMelterBlock)((Object)ModBlocks.SALT_MELTER_BLOCK.get())).m_5456_().m_7968_(), new RecipeType[]{SMELTING_RECIPE_TYPE});
        registration.addRecipeCatalyst(((MachineFluidEvaporationBlock)((Object)ModBlocks.FLUID_EVAPORATION_BLOCK.get())).m_5456_().m_7968_(), new RecipeType[]{EVAPORATING_RECIPE_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ThoriumCraftingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ConcentratingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlastingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new DecomposingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new OxidizingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidEnrichingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CentrifugingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrystallizingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ElectrolysingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SmeltingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new EvaporatingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(ThoriumCraftingTableScreen.class, 107, 54, 26, 19, new RecipeType[]{THORIUM_RECIPE_TYPE});
        registration.addRecipeClickArea(MachineConcentratorScreen.class, 66, 41, 43, 12, new RecipeType[]{CONCENTRATING_RECIPE_TYPE});
        registration.addRecipeClickArea(MachineBlastFurnaceScreen.class, 70, 47, 34, 10, new RecipeType[]{BLASTING_RECIPE_TYPE});
        registration.addRecipeClickArea(MachineDecomposerScreen.class, 68, 50, 38, 8, new RecipeType[]{DECOMPOSING_RECIPE_TYPE});
        registration.addRecipeClickArea(MachineUraniumOxidizerScreen.class, 70, 52, 34, 9, new RecipeType[]{OXIDIZING_RECIPE_TYPE});
        registration.addRecipeClickArea(MachineFluidEnricherScreen.class, 70, 52, 34, 9, new RecipeType[]{FLUID_ENRICHING_RECIPE_TYPE});
        registration.addRecipeClickArea(MachineFluidCentrifugeScreen.class, 70, 58, 34, 9, new RecipeType[]{CENTRIFUGING_RECIPE_TYPE});
        registration.addRecipeClickArea(MachineCrystallizerScreen.class, 64, 47, 41, 10, new RecipeType[]{CRYSTALLIZING_RECIPE_TYPE});
        registration.addRecipeClickArea(MachineElectrolyticSaltSeparatorScreen.class, 67, 33, 41, 31, new RecipeType[]{ELECTROLYSING_RECIPE_TYPE});
        registration.addRecipeClickArea(MachineSaltMelterScreen.class, 74, 31, 24, 35, new RecipeType[]{SMELTING_RECIPE_TYPE});
        registration.addRecipeClickArea(MachineFluidEvaporatorScreen.class, 71, 32, 32, 22, new RecipeType[]{EVAPORATING_RECIPE_TYPE});
        registration.addGenericGuiContainerHandler(ReactorControllerScreen.class, new Handler());
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        if (((Boolean)ClientConfig.showCreativeFluidTanksInJEI.get()).booleanValue()) {
            registration.registerSubtypeInterpreter(((FluidTankBlock)((Object)ModBlocks.CREATIVE_FLUID_TANK.get())).m_5456_(), (stack, uidContext) -> {
                CompoundTag data = stack.m_41784_().m_128469_("BlockEntityTag");
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)data.m_128469_("Fluid"));
                return JEIModIntegration.addInterpretation("fluid", fluidStack.getFluid().toString());
            });
        }
        if (((Boolean)ClientConfig.showCreativeEnergyTanksInJEI.get()).booleanValue()) {
            registration.registerSubtypeInterpreter(((EnergyTankBlock)((Object)ModBlocks.CREATIVE_ENERGY_TANK.get())).m_5456_(), (stack, uidContext) -> {
                CompoundTag data = stack.m_41784_().m_128469_("BlockEntityTag");
                int energy = data.m_128451_("Energy");
                return JEIModIntegration.addInterpretation("energy", "" + energy);
            });
        }
    }

    private static String addInterpretation(String nbtRepresentation, String component) {
        return nbtRepresentation.isEmpty() ? component : nbtRepresentation + ":" + component;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        registration.addRecipes(THORIUM_RECIPE_TYPE, rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.THORIUM_RECIPE_TYPE.get()));
        registration.addRecipes(CONCENTRATING_RECIPE_TYPE, rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.CONCENTRATING_RECIPE_TYPE.get()));
        registration.addRecipes(BLASTING_RECIPE_TYPE, rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.BLASTING_RECIPE_TYPE.get()));
        registration.addRecipes(DECOMPOSING_RECIPE_TYPE, rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.DECOMPOSING_RECIPE_TYPE.get()));
        registration.addRecipes(OXIDIZING_RECIPE_TYPE, rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.OXIDIZING_RECIPE_TYPE.get()));
        registration.addRecipes(FLUID_ENRICHING_RECIPE_TYPE, rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.FLUID_ENRICHING_RECIPE_TYPE.get()));
        registration.addRecipes(CENTRIFUGING_RECIPE_TYPE, rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.CENTRIFUGING_RECIPE_TYPE.get()));
        registration.addRecipes(CRYSTALLIZING_RECIPE_TYPE, rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.CRYSTALLIZING_RECIPE_TYPE.get()));
        registration.addRecipes(ELECTROLYSING_RECIPE_TYPE, rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.ELECTROLYSING_RECIPE_TYPE.get()));
        registration.addRecipes(SMELTING_RECIPE_TYPE, rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.SALT_SMELTING_RECIPE_TYPE.get()));
        registration.addRecipes(EVAPORATING_RECIPE_TYPE, rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.EVAPORATING_RECIPE_TYPE.get()));
        ArrayList<ItemStack> blockList = new ArrayList<ItemStack>();
        if (((Boolean)ClientConfig.showCreativeFluidTanksInJEI.get()).booleanValue()) {
            for (Fluid fluid : this.getKnownFluids()) {
                if (!(fluid instanceof ForgeFlowingFluid.Source) && !(fluid instanceof LavaFluid.Source) && !(fluid instanceof WaterFluid.Source)) continue;
                ItemStack blockStack = ((FluidTankBlock)((Object)ModBlocks.CREATIVE_FLUID_TANK.get())).m_5456_().m_7968_();
                FluidStack stack = new FluidStack(fluid, Integer.MAX_VALUE);
                blockStack.m_41784_().m_128365_("BlockEntityTag", (Tag)this.writeToNBT(stack));
                blockList.add(blockStack);
            }
            registration.getIngredientManager().addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, blockList);
        } else {
            blockList.add(new ItemStack((ItemLike)ModBlocks.CREATIVE_FLUID_TANK.get()));
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, blockList);
        }
        blockList = new ArrayList();
        if (((Boolean)ClientConfig.showCreativeEnergyTanksInJEI.get()).booleanValue()) {
            ItemStack blockStack = ((EnergyTankBlock)((Object)ModBlocks.CREATIVE_ENERGY_TANK.get())).m_5456_().m_7968_();
            blockStack.m_41784_().m_128365_("BlockEntityTag", (Tag)this.writeInt(Integer.MAX_VALUE));
            blockList.add(blockStack);
            registration.getIngredientManager().addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, blockList);
        } else {
            blockList.add(new ItemStack((ItemLike)ModBlocks.CREATIVE_ENERGY_TANK.get()));
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, blockList);
        }
    }

    public CompoundTag writeInt(int amount) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Energy", amount);
        return tag;
    }

    public CompoundTag writeToNBT(FluidStack fluidStack) {
        CompoundTag dataTag = new CompoundTag();
        CompoundTag fluidTag = new CompoundTag();
        dataTag.m_128359_("FluidName", ForgeRegistries.FLUIDS.getKey((Object)fluidStack.getFluid()).toString());
        dataTag.m_128405_("Amount", fluidStack.getAmount());
        fluidTag.m_128365_("Fluid", (Tag)dataTag);
        return fluidTag;
    }

    @NotNull
    protected Iterable<Fluid> getKnownFluids() {
        return ForgeRegistries.FLUIDS.getEntries().stream().map(Map.Entry::getValue)::iterator;
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(ThoriumCraftingTableContainer.class, (MenuType)ModContainerTypes.THORIUM_CRAFTING_TABLE_CONTAINER.get(), THORIUM_RECIPE_TYPE, 36, 25, 0, 36);
        registration.addRecipeTransferHandler(MachineConcentratorContainer.class, (MenuType)ModContainerTypes.CONCENTRATOR_CONTAINER.get(), CONCENTRATING_RECIPE_TYPE, 36, 1, 0, 36);
        registration.addRecipeTransferHandler(MachineBlastFurnaceContainer.class, (MenuType)ModContainerTypes.BLAST_FURNACE_CONTAINER.get(), BLASTING_RECIPE_TYPE, 36, 3, 0, 36);
        registration.addRecipeTransferHandler(MachineDecomposerContainer.class, (MenuType)ModContainerTypes.DECOMPOSER_CONTAINER.get(), DECOMPOSING_RECIPE_TYPE, 37, 2, 1, 36);
        registration.addRecipeTransferHandler(MachineUraniumOxidizerContainer.class, (MenuType)ModContainerTypes.URANIUM_OXIDIZER_CONTAINER.get(), OXIDIZING_RECIPE_TYPE, 36, 2, 0, 36);
        registration.addRecipeTransferHandler(MachineFluidEnricherContainer.class, (MenuType)ModContainerTypes.FLUID_ENRICHER_CONTAINER.get(), FLUID_ENRICHING_RECIPE_TYPE, 36, 2, 0, 36);
        registration.addRecipeTransferHandler(MachineSaltMelterContainer.class, (MenuType)ModContainerTypes.SALT_MELTER_CONTAINER.get(), SMELTING_RECIPE_TYPE, 36, 3, 0, 36);
    }

    static class Handler<T extends ReactorControllerScreen>
    implements IGuiContainerHandler<T> {
        Handler() {
        }

        @NotNull
        public List<Rect2i> getGuiExtraAreas(@NotNull ReactorControllerScreen screen) {
            int xPos = screen.f_96543_ - screen.getMainSizeX() / 2;
            int yPos = screen.f_96544_ - screen.getMainSizeY() / 2;
            ArrayList<Rect2i> collection = new ArrayList<Rect2i>();
            collection.add(new Rect2i(xPos / 2, yPos / 2, screen.getMainSizeX() / 2, screen.getMainSizeY() / 2));
            if (((Boolean)ClientConfig.showLeftReactorScreenArea.get()).booleanValue()) {
                collection.add(new Rect2i((xPos - screen.getLeftSideX() + 1) / 2, yPos / 2, screen.getLeftSideX() / 2, screen.getLeftSideY() / 2));
            }
            if (((Boolean)ClientConfig.showRightReactorScreenArea.get()).booleanValue()) {
                collection.add(new Rect2i((xPos + screen.getMainSizeX() + 1) / 2, yPos / 2, screen.getRightSideX() / 2, screen.getRightSideY() / 2));
            }
            return collection;
        }
    }
}

