/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.client.integration.jei;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import unhappycodings.thoriumreactors.client.integration.jei.JEIModIntegration;
import unhappycodings.thoriumreactors.common.recipe.ElectrolysingRecipe;
import unhappycodings.thoriumreactors.common.registration.ModBlocks;
import unhappycodings.thoriumreactors.common.util.ScreenUtil;

public class ElectrolysingRecipeCategory
implements IRecipeCategory<ElectrolysingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("thoriumreactors", "electrolysing");
    public static final ResourceLocation TEXTURE = new ResourceLocation("thoriumreactors", "textures/gui/gui_jei_second.png");
    private final IGuiHelper helper;
    private final IDrawable background;
    private final IDrawable icon;
    private IDrawable tankScaleL;
    private IDrawable tankScaleR;
    private IDrawable progressUp;
    private IDrawable progressDown;

    public ElectrolysingRecipeCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(TEXTURE, 0, 0, 102, 68).addPadding(this.getGuiTop(), this.getGuiBottom(), this.getGuiLeft(), this.getGuiRight()).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.ELECTROLYTIC_SALT_SEPARATOR_BLOCK.get()));
        this.helper = helper;
    }

    public void draw(ElectrolysingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        if (this.progressUp == null) {
            this.progressUp = this.helper.createAnimatedDrawable(this.helper.createDrawable(TEXTURE, 235, 236, 20, 7), recipe.getTicks(), IDrawableAnimated.StartDirection.BOTTOM, false);
            this.progressDown = this.helper.createAnimatedDrawable(this.helper.createDrawable(TEXTURE, 235, 250, 20, 6), recipe.getTicks(), IDrawableAnimated.StartDirection.TOP, false);
            this.tankScaleL = this.helper.createDrawable(TEXTURE, 242, 168, 4, 63);
            this.tankScaleR = this.helper.createDrawable(TEXTURE, 246, 168, 4, 41);
        }
        this.progressUp.draw(guiGraphics, this.getGuiLeft() + 41, this.getGuiTop() + 19);
        this.progressDown.draw(guiGraphics, this.getGuiLeft() + 41, this.getGuiTop() + 32);
        this.tankScaleL.draw(guiGraphics, this.getGuiLeft() + 1, this.getGuiTop() + 2);
        this.tankScaleR.draw(guiGraphics, this.getGuiLeft() + 83, this.getGuiTop() + 24);
        ScreenUtil.drawCenteredText("Electrolytic Separation", guiGraphics, this.getBackground().getWidth() / 2, 6, false);
        ScreenUtil.drawCenteredText(recipe.getTicks() / 20 + "s", guiGraphics, this.getBackground().getWidth() / 2, 71, false);
    }

    public int getGuiTop() {
        return 20;
    }

    public int getGuiBottom() {
        return 10;
    }

    public int getGuiLeft() {
        return 10;
    }

    public int getGuiRight() {
        return 10;
    }

    @NotNull
    public RecipeType<ElectrolysingRecipe> getRecipeType() {
        return JEIModIntegration.ELECTROLYSING_RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"block.thoriumreactors.electrolytic_salt_separator");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ElectrolysingRecipe recipe, @NotNull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, this.getGuiLeft() + 1, this.getGuiTop() + 1).setFluidRenderer((long)recipe.getFluidIngredient().getAmount(), true, 18, 66).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(new FluidStack(recipe.getFluidIngredient(), (int)(Math.floor((float)recipe.getTicks() / (float)recipe.getOperationAfterTicks()) * (double)recipe.getFluidIngredient().getAmount()))));
        builder.addSlot(RecipeIngredientRole.OUTPUT, this.getGuiLeft() + 83, this.getGuiTop() + 23).setFluidRenderer((long)recipe.getResultFluid().getAmount(), true, 18, 44).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(new FluidStack(recipe.getResultFluid(), (int)(Math.floor((float)recipe.getTicks() / (float)recipe.getOperationAfterTicks()) * (double)recipe.getResultFluid().getAmount()))));
        builder.addSlot(RecipeIngredientRole.OUTPUT, this.getGuiLeft() + 84, this.getGuiTop() + 1).addItemStack(recipe.m_8043_(null));
    }
}

