/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.client.integration.jei;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import unhappycodings.thoriumreactors.client.integration.jei.JEIModIntegration;
import unhappycodings.thoriumreactors.common.recipe.DecomposingRecipe;
import unhappycodings.thoriumreactors.common.registration.ModBlocks;
import unhappycodings.thoriumreactors.common.util.ScreenUtil;

public class DecomposingRecipeCategory
implements IRecipeCategory<DecomposingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("thoriumreactors", "decomposing");
    public static final ResourceLocation TEXTURE = new ResourceLocation("thoriumreactors", "textures/gui/gui_jei.png");
    private final IGuiHelper helper;
    private final IDrawable background;
    private final IDrawable icon;
    private IDrawable tankGroin1;
    private IDrawable tankGroin2;
    private IDrawable progress;

    public DecomposingRecipeCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(TEXTURE, 0, 143, 101, 68).addPadding(this.getGuiTop(), this.getGuiBottom(), this.getGuiLeft(), this.getGuiRight()).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.DECOMPOSER_BLOCK.get()));
        this.helper = helper;
    }

    public void draw(@NotNull DecomposingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        if (this.progress == null) {
            this.progress = this.helper.createAnimatedDrawable(this.helper.createDrawable(TEXTURE, 204, 240, 36, 8), recipe.getTicks(), IDrawableAnimated.StartDirection.LEFT, false);
            this.tankGroin1 = this.helper.createDrawable(TEXTURE, 246, 168, 4, 41);
            this.tankGroin2 = this.helper.createDrawable(TEXTURE, 242, 168, 4, 63);
        }
        this.progress.draw(guiGraphics, this.getGuiLeft() + 32, this.getGuiTop() + 32);
        this.tankGroin1.draw(guiGraphics, this.getGuiLeft() + 1, this.getGuiTop() + 25);
        this.tankGroin2.draw(guiGraphics, this.getGuiLeft() + 82, this.getGuiTop() + 2);
        ScreenUtil.drawCenteredText("Decomposing", guiGraphics, this.getBackground().getWidth() / 2, 6, false);
        ScreenUtil.drawCenteredText(recipe.getTicks() / 20 + "s", guiGraphics, this.getBackground().getWidth() / 2, 40, false);
    }

    public int getGuiTop() {
        return 20;
    }

    public int getGuiBottom() {
        return 10;
    }

    public int getGuiLeft() {
        return 10;
    }

    public int getGuiRight() {
        return 10;
    }

    @NotNull
    public RecipeType<DecomposingRecipe> getRecipeType() {
        return JEIModIntegration.DECOMPOSING_RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"block.thoriumreactors.decomposer_block");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DecomposingRecipe recipe, @NotNull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, this.getGuiLeft() + 1, this.getGuiTop() + 1).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, this.getGuiLeft() + 1, this.getGuiTop() + 23).setFluidRenderer((long)recipe.getFluidIngredient().getAmount(), true, 17, 44).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(new FluidStack(recipe.getFluidIngredient(), (int)(Math.floor((float)recipe.getTicks() / (float)recipe.getOperationAfterTicks()) * (double)recipe.getFluidIngredient().getAmount()))));
        builder.addSlot(RecipeIngredientRole.OUTPUT, this.getGuiLeft() + 82, this.getGuiTop() + 1).setFluidRenderer((long)recipe.getResultFluid().getAmount(), true, 18, 66).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(new FluidStack(recipe.getResultFluid(), (int)(Math.floor((float)recipe.getTicks() / (float)recipe.getOperationAfterTicks()) * (double)recipe.getResultFluid().getAmount()))));
    }
}

