/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.client.integration.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import unhappycodings.thoriumreactors.client.integration.jei.JEIModIntegration;
import unhappycodings.thoriumreactors.common.recipe.ConcentratingRecipe;
import unhappycodings.thoriumreactors.common.registration.ModBlocks;
import unhappycodings.thoriumreactors.common.util.ScreenUtil;

public class ConcentratingRecipeCategory
implements IRecipeCategory<ConcentratingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("thoriumreactors", "concentrating");
    public static final ResourceLocation TEXTURE = new ResourceLocation("thoriumreactors", "textures/gui/gui_jei.png");
    private final IGuiHelper helper;
    private final IDrawable background;
    private final IDrawable icon;
    private IDrawable progress;

    public ConcentratingRecipeCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(TEXTURE, 0, 90, 100, 18).addPadding(20, 20, 20, 20).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.CONCENTRATOR_BLOCK.get()));
        this.helper = helper;
    }

    public void draw(ConcentratingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        if (this.progress == null) {
            this.progress = this.helper.createAnimatedDrawable(this.helper.createDrawable(TEXTURE, 181, 246, 41, 10), recipe.getTicks(), IDrawableAnimated.StartDirection.LEFT, false);
        }
        this.progress.draw(guiGraphics, 50, 24);
        ScreenUtil.drawCenteredText("Concentrating", guiGraphics, this.getBackground().getWidth() / 2, 6, false);
        ScreenUtil.drawCenteredText(recipe.getTicks() / 20 + "s", guiGraphics, this.getBackground().getWidth() / 2, 40, false);
    }

    @NotNull
    public RecipeType<ConcentratingRecipe> getRecipeType() {
        return JEIModIntegration.CONCENTRATING_RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"block.thoriumreactors.concentrator_block");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ConcentratingRecipe recipe, @NotNull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 21, 21).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 21).addItemStack(recipe.m_8043_(null));
    }
}

