/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.client.gui.widgets.base;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import unhappycodings.thoriumreactors.client.gui.GuiUtil;
import unhappycodings.thoriumreactors.client.gui.widgets.ModButton;

public abstract class BaseWidget
extends AbstractWidget {
    public final AbstractContainerScreen<?> screen;
    protected final List<BaseWidget> children = new ArrayList<BaseWidget>();
    protected BlockEntity tile;
    protected Minecraft minecraft = Minecraft.m_91087_();
    protected int leftPos;
    protected int topPos;

    public BaseWidget(int x, int y, int width, int height, BlockEntity tile, AbstractContainerScreen<?> screen) {
        super(screen.getGuiLeft() + x, screen.getGuiTop() + y, width, height, (Component)Component.m_237119_());
        this.tile = tile;
        this.screen = screen;
        this.leftPos = screen.getGuiLeft();
        this.topPos = screen.getGuiTop();
    }

    public BaseWidget(int x, int y, int width, int height, int imageWidth, int imageHeight) {
        super((width - imageWidth) / 2 + x, (height - imageHeight) / 2 + y, width, height, (Component)Component.m_237119_());
        this.screen = null;
        this.leftPos = (width - imageWidth) / 2;
        this.topPos = (height - imageHeight) / 2;
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int x, int y, float partialTicks) {
        GuiUtil.reset();
        for (BaseWidget child : this.children) {
            child.m_88315_(graphics, x, y, this.minecraft.m_91297_());
        }
    }

    public void m_5716_(double pMouseX, double pMouseY) {
        for (BaseWidget child : this.children) {
            if (!(child instanceof ModButton)) continue;
            child.m_5716_(pMouseX, pMouseY);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        for (BaseWidget child : this.children) {
            if (!(child instanceof ModButton)) continue;
            child.m_6375_(pMouseX, pMouseY, pButton);
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public void m_7435_(@NotNull SoundManager pHandler) {
        if (this instanceof ModButton) {
            super.m_7435_(pHandler);
        }
    }

    public <ELEMENT extends BaseWidget> ELEMENT addChild(ELEMENT child) {
        this.children.add(child);
        return child;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return super.m_5953_(mouseX, mouseY) || this.children.stream().anyMatch(child -> child.m_5953_(mouseX, mouseY));
    }
}

