/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.function;

import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.function.ThrowingConsumer;
import org.burningwave.core.function.ThrowingRunnable;
import org.burningwave.core.function.ThrowingSupplier;

public interface Executor {
    public static <E extends Throwable> void runAndLogExceptions(ThrowingRunnable<? extends Throwable> runnable) {
        try {
            runnable.run();
        }
        catch (Throwable exc) {
            StaticComponentContainer.ManagedLoggerRepository.logError(() -> Executor.class.getName(), exc);
        }
    }

    public static <E extends Throwable> void runAndIgnoreExceptions(ThrowingRunnable<? extends Throwable> runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static <E extends Throwable> void run(ThrowingRunnable<E> runnable) {
        try {
            runnable.run();
        }
        catch (Throwable exc) {
            StaticComponentContainer.Driver.throwException(exc);
        }
    }

    public static <I, E extends Throwable> void accept(ThrowingConsumer<I, E> consumer, I input) {
        try {
            consumer.accept(input);
        }
        catch (Throwable exc) {
            StaticComponentContainer.Driver.throwException(exc);
        }
    }

    public static <E extends Throwable> void run(ThrowingRunnable<E> runnable, int attemptsNumber) {
        while (true) {
            block3: {
                try {
                    runnable.run();
                }
                catch (Throwable exc) {
                    if (attemptsNumber <= 1) break block3;
                    StaticComponentContainer.Driver.throwException(exc);
                }
            }
            --attemptsNumber;
        }
    }

    public static <T, E extends Throwable> T get(ThrowingSupplier<T, ? extends E> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable exc) {
            return StaticComponentContainer.Driver.throwException(exc);
        }
    }

    public static <T, E extends Throwable> T get(ThrowingSupplier<T, ? extends E> supplier, int attemptsNumber) {
        while (true) {
            try {
                return supplier.get();
            }
            catch (Throwable exc) {
                if (attemptsNumber > 1) {
                    StaticComponentContainer.Driver.throwException(exc);
                }
                --attemptsNumber;
                continue;
            }
            break;
        }
    }
}

