/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.v20.client.gui;

import java.util.Objects;
import javax.annotation.Nonnull;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.MinecraftAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.input.KeyStateCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.util.MathHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.Wrapped;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ScreenWrapper1_20
extends Screen
implements Wrapped<ScreenAPI> {
    protected final ScreenAPI wrapped;
    protected boolean isOpen;

    public ScreenWrapper1_20(ScreenAPI wrapped) {
        super((Component)wrapped.getTitle().getAsComponent());
        this.wrapped = wrapped;
    }

    public boolean charTyped(char c, int mods) {
        if (SharedConstants.isAllowedChatCharacter((char)c) && this.wrapped.onCharTyped(c)) {
            return true;
        }
        return super.charTyped(c, mods);
    }

    protected KeyStateCache getKeyState() {
        return new KeyStateCache(ScreenWrapper1_20.hasAltDown(), ScreenWrapper1_20.hasControlDown(), ScreenWrapper1_20.hasShiftDown());
    }

    @Override
    public ScreenAPI getWrapped() {
        return this.wrapped;
    }

    public void init() {
        if (Objects.nonNull(this.wrapped)) {
            this.wrapped.onScreenOpened();
        }
        this.isOpen = true;
    }

    protected boolean isActivelyTicking() {
        return Objects.nonNull(this.wrapped) && this.wrapped.isActivelyTicking();
    }

    public boolean isPauseScreen() {
        return Objects.isNull(this.wrapped) || this.wrapped.shouldPauseGame();
    }

    public boolean keyPressed(int keyCode, int scanCode, int mod) {
        if (Objects.nonNull(this.wrapped)) {
            String pasted;
            String copied;
            if (keyCode == 256) {
                if (this.wrapped.onCloseRequested(true)) {
                    this.onClose();
                }
                return true;
            }
            if (keyCode == 259 && this.wrapped.onBackspace()) {
                return true;
            }
            if (Screen.isSelectAll((int)keyCode) && this.wrapped.onSelectAll()) {
                return true;
            }
            if (Screen.isCopy((int)keyCode) && Objects.nonNull(copied = this.wrapped.onCopy())) {
                TextFieldHelper.setClipboardContents((Minecraft)this.minecraft(), (String)copied);
                return true;
            }
            if (Screen.isPaste((int)keyCode) && this.wrapped.onPaste(pasted = TextFieldHelper.getClipboardContents((Minecraft)this.minecraft()))) {
                return true;
            }
            if (Screen.isCut((int)keyCode) && Objects.nonNull(copied = this.wrapped.onCut())) {
                TextFieldHelper.setClipboardContents((Minecraft)this.minecraft(), (String)copied);
                return true;
            }
            if (this.wrapped.onKeyPressed(this.getKeyState(), keyCode)) {
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, mod);
    }

    protected Minecraft minecraft() {
        MinecraftAPI<?> api = ClientHelper.getMinecraft();
        return Objects.nonNull(api) ? (Minecraft)api.unwrap() : null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (Objects.nonNull(this.wrapped)) {
            RenderContext ctx = RenderContext.get(ClientHelper.getMinecraft());
            double x = -1.0 + mouseX * ctx.getScale().getScreenScaleX();
            double y = 1.0 - mouseY * ctx.getScale().getScreenScaleY();
            if (mouseButton == 0 ? this.wrapped.onLeftClick(x, y) : mouseButton == 1 && this.wrapped.onRightClick(x, y)) {
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (Objects.nonNull(this.wrapped) && delta != 0.0 && (delta >= 1.0 ? this.wrapped.scrollUp(MathHelper.clamp(delta, -1.0, 1.0)) : this.wrapped.scrollDown(MathHelper.clamp(delta, -1.0, 1.0)))) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, delta);
    }

    public void onClose() {
        this.isOpen = false;
        if (Objects.nonNull(this.wrapped)) {
            this.wrapped.onScreenClosed();
        }
        super.onClose();
    }

    public void render(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (Objects.nonNull(this.wrapped)) {
            RenderContext ctx = RenderContext.get(ClientHelper.getMinecraft());
            ctx.setPartialTicks(partialTicks);
            ctx.getRenderer().setMatrix(graphics);
            double x = -1.0 + (double)mouseX * ctx.getScale().getScreenScaleX();
            double y = 1.0 - (double)mouseY * ctx.getScale().getScreenScaleY();
            this.wrapped.draw(ctx, x, y);
        }
    }

    public void resize(@Nonnull Minecraft mc, int width, int height) {
        super.resize(mc, width, height);
        MinecraftAPI<?> minecraft = ClientHelper.getMinecraft();
        if (Objects.nonNull(this.wrapped) && Objects.nonNull(minecraft)) {
            this.wrapped.onResolutionUpdated(minecraft.getWindow());
        }
    }

    public void tick() {
        if (this.isActivelyTicking() && this.isOpen) {
            this.wrapped.onTick();
        }
    }
}

