/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.v20.client;

import com.mojang.blaze3d.platform.Window;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.client.MinecraftAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.MinecraftWindow;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.v20.client.font.Font1_20;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.v20.client.render.Render1_20;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class Minecraft1_20
extends MinecraftAPI<Minecraft> {
    public static MinecraftAPI<?> getInstance() {
        return new Minecraft1_20(Minecraft.getInstance());
    }

    protected Minecraft1_20(Minecraft mc, Render1_20 render) {
        super(mc, new Font1_20(), render);
    }

    public Minecraft1_20(Minecraft mc) {
        super(mc, new Font1_20(), new Render1_20());
    }

    @Override
    public void addResourcePackFolder(File dir) {
    }

    @Override
    @Nullable
    public Object getCurrentScreen() {
        return Objects.nonNull(this.wrapped) ? ((Minecraft)this.wrapped).screen : null;
    }

    @Override
    public int getDisplayHeight() {
        return ((Minecraft)this.wrapped).getWindow().getHeight();
    }

    @Override
    public int getDisplayWidth() {
        return ((Minecraft)this.wrapped).getWindow().getWidth();
    }

    @Override
    public int getGUIScale() {
        return Objects.nonNull(this.wrapped) && Objects.nonNull(((Minecraft)this.wrapped).options) ? (Integer)((Minecraft)this.wrapped).options.guiScale().get() : 0;
    }

    @Override
    @Nullable
    public PlayerAPI<?, ?> getPlayer() {
        return WrapperHelper.wrapPlayer(((Minecraft)this.wrapped).player);
    }

    @Nullable
    private HitResult getTarget() {
        return Objects.nonNull(this.wrapped) ? ((Minecraft)this.wrapped).hitResult : null;
    }

    @Override
    @Nullable
    public BlockEntityAPI<?, ?> getTargetBlockEntity() {
        HitResult target = this.getTarget();
        if (target instanceof BlockHitResult && target.getType() == HitResult.Type.BLOCK) {
            BlockPos pos = ((BlockHitResult)target).getBlockPos();
            ClientLevel world = ((Minecraft)this.wrapped).level;
            return Objects.nonNull(world) ? WrapperHelper.wrapBlockEntity(world.getBlockEntity(pos)) : null;
        }
        return null;
    }

    @Override
    @Nullable
    public EntityAPI<?, ?> getTargetEntity() {
        HitResult target = this.getTarget();
        return target instanceof EntityHitResult ? WrapperHelper.wrapEntity(((EntityHitResult)target).getEntity()) : null;
    }

    @Override
    public MinecraftWindow getWindow() {
        Window window;
        Window window2 = window = Objects.nonNull(this.wrapped) ? ((Minecraft)this.wrapped).getWindow() : null;
        if (Objects.isNull(window)) {
            TILRef.logFatal("Unable to get MinecraftWindow since the Minecraft main window is null?", new Object[0]);
            return new MinecraftWindow(1.0, 1.0, 0);
        }
        return new MinecraftWindow(window.getGuiScaledWidth(), window.getGuiScaledHeight(), (int)window.getGuiScale());
    }

    @Override
    @Nullable
    public WorldAPI<?> getWorld() {
        return Objects.nonNull(this.wrapped) && Objects.nonNull(((Minecraft)this.wrapped).level) ? WrapperHelper.wrapWorld(((Minecraft)this.wrapped).level) : null;
    }

    @Override
    public <S> boolean isCurrentScreen(S screen) {
        return Objects.nonNull(this.wrapped) && ((Minecraft)this.wrapped).screen == screen;
    }

    @Override
    public boolean isCurrentScreenAPI() {
        return false;
    }

    @Override
    public boolean isDisplayFocused() {
        return Objects.nonNull(this.wrapped) && ((Minecraft)this.wrapped).isWindowActive();
    }

    @Override
    public boolean isFinishedLoading() {
        return !this.isLoading();
    }

    @Override
    public boolean isFullScreen() {
        return Objects.nonNull(this.wrapped) && ((Minecraft)this.wrapped).getWindow().isFullscreen();
    }

    @Override
    public boolean isPaused() {
        return Objects.nonNull(this.wrapped) && ((Minecraft)this.wrapped).isPaused();
    }

    @Override
    public <T> Supplier<T> scheduleReturnable(Supplier<T> supplier) {
        CompletableFuture future = ((Minecraft)this.wrapped).submit(supplier);
        return () -> {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                TILRef.logError("Failed to retrieve CompletableFuture instance!", ex);
            }
            return null;
        };
    }

    @Override
    public void scheduleRunnable(Runnable runnable) {
        ((Minecraft)this.wrapped).submit(runnable).getNow(null);
    }
}

