/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.core.asm;

import java.util.Map;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ModWriter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.TypeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class ModWriterNeoForge
extends ModWriter {
    protected static final Type DIST = TypeHelper.neoforged("api/distmarker/Dist");
    protected static final Type EVENT_BUS = TypeHelper.neoforged("bus/api/IEventBus");
    protected static final Type EVENT_SUBSCRIBER = TypeHelper.neofml("common/Mod$EventBusSubscriber");
    protected static final Type EVENT_SUBSCRIBER_BUS = TypeHelper.neofml("common/Mod$EventBusSubscriber$Bus");
    protected static final Type MOD_ANNOTATION = TypeHelper.neofml("common/Mod");
    protected static final Type SUBSCRIBE_EVENT = TypeHelper.neoforged("bus/api/SubscribeEvent");

    protected ModWriterNeoForge(CoreAPI core, MultiVersionModInfo info, int javaVersion) {
        super(core, info, javaVersion);
    }

    @Override
    protected void addClassAnnotations(ClassVisitor visitor) {
        this.writeClassAnnotation(visitor, MOD_ANNOTATION, mod -> mod.visit("value", (Object)this.info.getModID()));
    }

    protected void addEntryHooks(MethodVisitor visitor, String method) {
        super.addEntryHooks(visitor, true, method, false);
    }

    protected void addEventSubscriber(ClassVisitor visitor, String modid, boolean modBus, boolean client, boolean server) {
        this.writeClassAnnotation(visitor, this.getEventSubscriberType(), annotation -> {
            annotation.visit("modid", (Object)modid);
            if (modBus) {
                annotation.visitEnum("bus", this.getEventSubscriberBusType().getDescriptor(), "MOD");
            }
            if (client && !server || !client && server) {
                this.writeAnnotationArray((AnnotationVisitor)annotation, "value", array -> array.visitEnum(null, DIST.getDescriptor(), client ? "CLIENT" : "DEDICATED_SERVER"));
            }
        });
    }

    protected Map.Entry<ClassWriter, Type> addInnerEventSubscriber(ClassVisitor outerClass, String modid, boolean modBus, boolean client, boolean server, String innerName, String ... entryMethods) {
        return this.addInnerClass(outerClass, innerName, inner -> {
            this.addEventSubscriber((ClassVisitor)inner, modid, modBus, client, server);
            for (String methodName : entryMethods) {
                Type eventType = (Type)this.entryPointMethodTypes.get(methodName);
                this.writeMethod((ClassVisitor)inner, cv -> ASMHelper.getMethod(cv, 9, methodName, eventType.getArgumentTypes()), method -> {
                    this.writeMethodAnnotation((MethodVisitor)method, SUBSCRIBE_EVENT, annotation -> {});
                    this.addEntryHooks((MethodVisitor)method, methodName);
                });
            }
        });
    }

    @Override
    protected MethodVisitor getConstructor(ClassVisitor visitor) {
        return ASMHelper.getConstructor(visitor, 1, EVENT_BUS);
    }

    @Override
    protected Type getEventMethod(String className) {
        className = (((String)className).startsWith("FMLServer") ? "server" : "lifecycle") + "/" + (String)className;
        return TypeHelper.method(Type.VOID_TYPE, TypeHelper.neofml("event/" + (String)className));
    }

    protected Type getEventSubscriberBusType() {
        return EVENT_SUBSCRIBER_BUS;
    }

    protected Type getEventSubscriberType() {
        return EVENT_SUBSCRIBER;
    }

    @Override
    protected void mappedEntryPointMethods(Map<String, String[]> redirects, Map<String, Type> types) {
        this.mapEntryPointMethod(redirects, types, "<init>", ASMRef.EMPTY_METHOD, "onConstructed", "onPreRegistration");
        this.mapEntryPointMethod(redirects, types, "clientSetup", this.getEventMethod("FMLClientSetupEvent"), "checkClientSetup");
        this.mapEntryPointMethod(redirects, types, "commonSetup", this.getEventMethod("FMLCommonSetupEvent"), "onCommonSetup");
        this.mapEntryPointMethod(redirects, types, "dedicatedServerSetup", this.getEventMethod("FMLDedicatedServerSetupEvent"), "checkDedicatedServerSetup");
        this.mapEntryPointMethod(redirects, types, "interModEnqueue", this.getEventMethod("InterModEnqueueEvent"), "onInterModEnqueue");
        this.mapEntryPointMethod(redirects, types, "interModProcess", this.getEventMethod("InterModProcessEvent"), "onInterModProcess");
        this.mapEntryPointMethod(redirects, types, "loadComplete", this.getEventMethod("FMLLoadCompleteEvent"), "onLoadComplete");
        this.mapEntryPointMethod(redirects, types, "serverAboutToStart", this.getEventMethod("FMLServerAboutToStartEvent"), "onServerAboutToStart");
        this.mapEntryPointMethod(redirects, types, "serverStarting", this.getEventMethod("FMLServerStartingEvent"), "onServerStarting");
        this.mapEntryPointMethod(redirects, types, "serverStarted", this.getEventMethod("FMLServerStartedEvent"), "onServerStarted");
        this.mapEntryPointMethod(redirects, types, "serverStopping", this.getEventMethod("FMLServerStoppingEvent"), "onServerStopping");
        this.mapEntryPointMethod(redirects, types, "serverStopped", this.getEventMethod("FMLServerStoppedEvent"), "onServerStopped");
    }

    @Override
    protected final void writeConstructor(ClassVisitor visitor) {
        String extraDataDesc = TypeHelper.voidMethodDesc(ASMRef.OBJECT_TYPE);
        this.writeConstructor(visitor, constructor -> {
            constructor.visitVarInsn(25, 0);
            constructor.visitFieldInsn(180, this.modTypeInternal, "entryPoint", this.entryPointDesc);
            constructor.visitVarInsn(25, 1);
            constructor.visitMethodInsn(182, this.entryPointInternal, "setExtraData", extraDataDesc, false);
        });
    }
}

