/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.core;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.NeoForgeCoreLoader;
import net.neoforged.neoforgespi.language.ILifecycleEvent;
import net.neoforged.neoforgespi.language.IModLanguageProvider;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.burningwave.core.assembler.StaticComponentContainer;

public class TILLanguageProvider
implements IModLanguageProvider {
    private static final String IMPL_PKG = "mods.thecomputerizer.theimpossiblelibrary.neoforge.core";
    private static final String NEOFORGE_PKG = "net.neoforged.neoforgespi";
    private static final String MOD_PROVIDER_IMPL = "mods.thecomputerizer.theimpossiblelibrary.neoforge.core.TILLanguageProvider";
    private static final String MOD_PROVIDER_SERVICE = "net.neoforged.neoforgespi.language.IModLanguageProvider";
    final Object core;
    final Object versionProvider;

    public TILLanguageProvider() {
        TILRef.logInfo("Initializing multiversion language provider (NeoForge edition)", new Object[0]);
        ClassLoader pluginLoader = NeoForgeCoreLoader.layerClassLoader("PLUGIN");
        this.core = NeoForgeCoreLoader.initCoreAPI(pluginLoader);
        Object object = this.versionProvider = Objects.nonNull(this.core) ? (Object)StaticComponentContainer.Methods.invoke(this.core, "getLaunguageProvider", new Object[0]) : null;
        if (Objects.nonNull(this.versionProvider)) {
            TILRef.logInfo("Successfully initialized versioned language provider on {}", this.versionProvider.getClass().getClassLoader());
        } else {
            TILRef.logError("Initialized versioned language provider as null", new Object[0]);
        }
    }

    public <R extends ILifecycleEvent<R>> void consumeLifecycleEvent(Supplier<R> ignored) {
    }

    public Consumer<ModFileScanData> getFileVisitor() {
        Consumer visitor = scan -> {};
        if (Objects.nonNull(this.versionProvider)) {
            visitor = (Consumer)StaticComponentContainer.Methods.invoke(this.versionProvider, "getFileVisitor", this.core, this);
        } else {
            TILRef.logError("Version specific language provider not found! Did it fail to load?", new Object[0]);
        }
        return visitor;
    }

    public String name() {
        return "multiversionprovider";
    }

    static {
        NeoForgeCoreLoader.removeServiceFrom(MOD_PROVIDER_SERVICE, MOD_PROVIDER_IMPL, "BOOT");
        try {
            ClassLoader plugin = TILLanguageProvider.class.getClassLoader();
            NeoForgeCoreLoader.resyncModules(plugin, "PLUGIN", NeoForgeCoreLoader.bootLoader());
        }
        catch (Throwable t) {
            TILRef.logError("Failed to resync modules to BOOT layer", t);
        }
    }
}

