/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.core;

import cpw.mods.modlauncher.Launcher;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ReflectionHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.NeoForgeCoreLoader;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.IModLocator;

public class MultiVersionModLocator
implements IModLocator {
    private static final String IMPL_PKG = "mods.thecomputerizer.theimpossiblelibrary.neoforge.core";
    private static final String NEOFORGE_PKG = "net.neoforged.neoforgespi";
    private static final String MOD_LOCATOR_IMPL = "mods.thecomputerizer.theimpossiblelibrary.neoforge.core.MultiVersionModLocator";
    private static final String MOD_LOCATOR_SERVICE = "net.neoforged.neoforgespi.locating.IModLocator";
    private final Object localLocator;

    public MultiVersionModLocator() {
        Object instance;
        ClassLoader loader = this.getClass().getClassLoader();
        ClassLoader bootLoader = Launcher.class.getClassLoader();
        TILRef.logInfo("Core NeoForge Locator plugin loaded on {}", loader);
        if (!loader.equals(bootLoader)) {
            TILRef.logInfo("That's the wrong ClassLoader... Retrieving locator instance from the right ClassLoader {}", bootLoader);
        }
        Object object = this.localLocator = Objects.nonNull(instance = NeoForgeCoreLoader.initCoreAPI(bootLoader)) ? ReflectionHelper.invokeMethod(instance.getClass(), "getModLocator", instance, new Class[]{ClassLoader.class}, instance.getClass().getClassLoader()) : null;
        if (Objects.nonNull(this.localLocator)) {
            TILRef.logInfo("Found mod locator {}", this.localLocator.getClass());
        } else {
            TILRef.logFatal("Failed to find mod locator! Unable to load multiversion mods", new Object[0]);
        }
    }

    public void initArguments(Map<String, ?> arguments) {
        if (Objects.nonNull(this.localLocator)) {
            ClassLoader loader = this.getClass().getClassLoader();
            TILDev.logInfo("Initializing mod locator with {}", loader);
            ReflectionHelper.invokeMethod(this.localLocator.getClass(), "initFor", this.localLocator, new Class[]{ClassLoader.class, IModLocator.class}, loader, this);
        } else {
            TILRef.logFatal("Locator is null and cannot load multiversion mods! Did it fail to initialize?", new Object[0]);
        }
    }

    public boolean isValid(IModFile file) {
        return true;
    }

    public String name() {
        return "multiversionloader";
    }

    public void scanFile(IModFile file, Consumer<Path> pathConsumer) {
    }

    public List<IModLocator.ModFileOrException> scanMods() {
        List files = null;
        if (Objects.nonNull(this.localLocator)) {
            files = (List)ReflectionHelper.invokeMethod(this.localLocator.getClass(), "scanMods", this.localLocator, new Class[]{IModLocator.class}, this);
        } else {
            TILRef.logFatal("Locator is null and cannot scan for multiversion mods! Did it fail to initialize?", new Object[0]);
        }
        return Objects.nonNull(files) ? files : Collections.emptyList();
    }

    static {
        ClassLoader loader = MultiVersionModLocator.class.getClassLoader();
        NeoForgeCoreLoader.fixForServiceLayer();
        Object instance = NeoForgeCoreLoader.initCoreAPI(loader);
        if (Objects.isNull(instance)) {
            throw new RuntimeException("Failed to retrieve CoreAPI instance for MultiVersionModLocator");
        }
        if (loader != NeoForgeCoreLoader.bootLoader()) {
            NeoForgeCoreLoader.fixService(MOD_LOCATOR_SERVICE, MOD_LOCATOR_IMPL, loader, true);
        }
    }
}

